/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedConv2DWithBiasSumAndRelu<V extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedConv2DWithBiasSumAndRelu";
    private Output<V> output;
    private Output<TFloat32> minOutput;
    private Output<TFloat32> maxOutput;

    public static <V extends TType> QuantizedConv2DWithBiasSumAndRelu<V> create(Scope scope, Operand<? extends TType> input, Operand<? extends TType> filter, Operand<TFloat32> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> summand, Class<V> outType, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minFilter.asOutput());
        opBuilder.addInput(maxFilter.asOutput());
        opBuilder.addInput(summand.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.dilations != null) {
                    long[] dilationsArray = new long[opts.dilations.size()];
                    for (i = 0; i < dilationsArray.length; ++i) {
                        dilationsArray[i] = (Long)opts.dilations.get(i);
                    }
                    opBuilder.setAttr("dilations", dilationsArray);
                }
                if (opts.paddingList == null) continue;
                long[] paddingListArray = new long[opts.paddingList.size()];
                for (i = 0; i < paddingListArray.length; ++i) {
                    paddingListArray[i] = (Long)opts.paddingList.get(i);
                }
                opBuilder.setAttr("padding_list", paddingListArray);
            }
        }
        return new QuantizedConv2DWithBiasSumAndRelu<V>(opBuilder.build());
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public static Options paddingList(List<Long> paddingList) {
        return new Options().paddingList(paddingList);
    }

    public Output<V> output() {
        return this.output;
    }

    public Output<TFloat32> minOutput() {
        return this.minOutput;
    }

    public Output<TFloat32> maxOutput() {
        return this.maxOutput;
    }

    private QuantizedConv2DWithBiasSumAndRelu(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOutput = operation.output(outputIdx++);
        this.maxOutput = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Long> dilations;
        private List<Long> paddingList;

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        public Options paddingList(List<Long> paddingList) {
            this.paddingList = paddingList;
            return this;
        }

        private Options() {
        }
    }
}

