/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedMatMul<V extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedMatMul";
    private Output<V> out;
    private Output<TFloat32> minOut;
    private Output<TFloat32> maxOut;

    public static <V extends TType, W extends TType> QuantizedMatMul<V> create(Scope scope, Operand<? extends TType> a, Operand<? extends TType> b, Operand<TFloat32> minA, Operand<TFloat32> maxA, Operand<TFloat32> minB, Operand<TFloat32> maxB, Class<V> Toutput, Class<W> Tactivation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.addInput(minA.asOutput());
        opBuilder.addInput(maxA.asOutput());
        opBuilder.addInput(minB.asOutput());
        opBuilder.addInput(maxB.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("Toutput", Operands.toDataType(Toutput));
        opBuilder.setAttr("Tactivation", Operands.toDataType(Tactivation));
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB == null) continue;
                opBuilder.setAttr("transpose_b", opts.transposeB);
            }
        }
        return new QuantizedMatMul<V>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public Output<V> out() {
        return this.out;
    }

    public Output<TFloat32> minOut() {
        return this.minOut;
    }

    public Output<TFloat32> maxOut() {
        return this.maxOut;
    }

    private QuantizedMatMul(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        private Options() {
        }
    }
}

