/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class ScaleAndTranslate
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "ScaleAndTranslate";
    private Output<TFloat32> resizedImages;

    public static ScaleAndTranslate create(Scope scope, Operand<? extends TNumber> images, Operand<TInt32> size, Operand<TFloat32> scale, Operand<TFloat32> translation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(translation.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.kernelType != null) {
                    opBuilder.setAttr("kernel_type", opts.kernelType);
                }
                if (opts.antialias == null) continue;
                opBuilder.setAttr("antialias", opts.antialias);
            }
        }
        return new ScaleAndTranslate(opBuilder.build());
    }

    public static Options kernelType(String kernelType) {
        return new Options().kernelType(kernelType);
    }

    public static Options antialias(Boolean antialias) {
        return new Options().antialias(antialias);
    }

    public Output<TFloat32> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.resizedImages;
    }

    private ScaleAndTranslate(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static class Options {
        private String kernelType;
        private Boolean antialias;

        public Options kernelType(String kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        public Options antialias(Boolean antialias) {
            this.antialias = antialias;
            return this;
        }

        private Options() {
        }
    }
}

