/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class ShuffleAndRepeatDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ShuffleAndRepeatDatasetV2";
    private Output<?> handle;

    public static ShuffleAndRepeatDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> bufferSize, Operand<TInt64> seed, Operand<TInt64> seed2, Operand<TInt64> count, Operand<?> seedGenerator, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("ShuffleAndRepeatDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.addInput(seed.asOutput());
        opBuilder.addInput(seed2.asOutput());
        opBuilder.addInput(count.asOutput());
        opBuilder.addInput(seedGenerator.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.reshuffleEachIteration == null) continue;
                opBuilder.setAttr("reshuffle_each_iteration", opts.reshuffleEachIteration);
            }
        }
        return new ShuffleAndRepeatDataset(opBuilder.build());
    }

    public static Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
        return new Options().reshuffleEachIteration(reshuffleEachIteration);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private ShuffleAndRepeatDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean reshuffleEachIteration;

        public Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
            this.reshuffleEachIteration = reshuffleEachIteration;
            return this;
        }

        private Options() {
        }
    }
}

