/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class OptionalGetValue
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "OptionalGetValue";
    private List<Output<?>> components;

    public static OptionalGetValue create(Scope scope, Operand<?> optional, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(optional.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new OptionalGetValue(opBuilder.build());
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    private OptionalGetValue(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }
}

