/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;

public final class Batch
extends RawOp {
    public static final String OP_NAME = "Batch";
    private List<Output<?>> batchedTensors;
    private Output<TInt64> batchIndex;
    private Output<TInt64> id;

    public static Batch create(Scope scope, Iterable<Operand<?>> inTensors, Long numBatchThreads, Long maxBatchSize, Long batchTimeoutMicros, Long gradTimeoutMicros, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInputList(Operands.asOutputs(inTensors));
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_batch_threads", numBatchThreads);
        opBuilder.setAttr("max_batch_size", maxBatchSize);
        opBuilder.setAttr("batch_timeout_micros", batchTimeoutMicros);
        opBuilder.setAttr("grad_timeout_micros", gradTimeoutMicros);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxEnqueuedBatches != null) {
                    opBuilder.setAttr("max_enqueued_batches", opts.maxEnqueuedBatches);
                }
                if (opts.allowedBatchSizes != null) {
                    long[] allowedBatchSizesArray = new long[opts.allowedBatchSizes.size()];
                    for (int i = 0; i < allowedBatchSizesArray.length; ++i) {
                        allowedBatchSizesArray[i] = (Long)opts.allowedBatchSizes.get(i);
                    }
                    opBuilder.setAttr("allowed_batch_sizes", allowedBatchSizesArray);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.batchingQueue == null) continue;
                opBuilder.setAttr("batching_queue", opts.batchingQueue);
            }
        }
        return new Batch(opBuilder.build());
    }

    public static Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
        return new Options().maxEnqueuedBatches(maxEnqueuedBatches);
    }

    public static Options allowedBatchSizes(List<Long> allowedBatchSizes) {
        return new Options().allowedBatchSizes(allowedBatchSizes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options batchingQueue(String batchingQueue) {
        return new Options().batchingQueue(batchingQueue);
    }

    public List<Output<?>> batchedTensors() {
        return this.batchedTensors;
    }

    public Output<TInt64> batchIndex() {
        return this.batchIndex;
    }

    public Output<TInt64> id() {
        return this.id;
    }

    private Batch(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int batchedTensorsLength = operation.outputListLength("batched_tensors");
        this.batchedTensors = Arrays.asList(operation.outputList(outputIdx, batchedTensorsLength));
        outputIdx += batchedTensorsLength;
        this.batchIndex = operation.output(outputIdx++);
        this.id = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxEnqueuedBatches;
        private List<Long> allowedBatchSizes;
        private String container;
        private String sharedName;
        private String batchingQueue;

        public Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
            this.maxEnqueuedBatches = maxEnqueuedBatches;
            return this;
        }

        public Options allowedBatchSizes(List<Long> allowedBatchSizes) {
            this.allowedBatchSizes = allowedBatchSizes;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options batchingQueue(String batchingQueue) {
            this.batchingQueue = batchingQueue;
            return this;
        }

        private Options() {
        }
    }
}

