/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.ArrayList;
import org.tensorflow.DeviceSpec;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.NameScope;
import org.tensorflow.op.Op;

public final class Scope {
    private final ExecutionEnvironment env;
    private final Iterable<Op> controlDependencies;
    private final NameScope nameScope;
    private final DeviceSpec deviceSpec;

    public Scope(ExecutionEnvironment env) {
        this(env, new NameScope(), new ArrayList<Op>(), DeviceSpec.newBuilder().build());
    }

    public ExecutionEnvironment env() {
        return this.env;
    }

    public Scope withSubScope(String childScopeName) {
        return new Scope(this.env, this.nameScope.withSubScope(childScopeName), this.controlDependencies, this.deviceSpec);
    }

    public Scope withName(String opName) {
        return new Scope(this.env, this.nameScope.withName(opName), this.controlDependencies, this.deviceSpec);
    }

    public Scope withNameAsSubScope(String defaultName) {
        return new Scope(this.env, this.nameScope.withSubScope(this.nameScope.makeOpName(defaultName)), this.controlDependencies, this.deviceSpec);
    }

    public Scope withDevice(DeviceSpec deviceSpec) {
        return new Scope(this.env, this.nameScope, this.controlDependencies, deviceSpec);
    }

    public String makeOpName(String defaultName) {
        return this.nameScope.makeOpName(defaultName);
    }

    private Scope(ExecutionEnvironment env, NameScope nameScope, Iterable<Op> controlDependencies, DeviceSpec deviceSpec) {
        this.env = env;
        this.nameScope = nameScope;
        this.controlDependencies = controlDependencies;
        this.deviceSpec = deviceSpec;
    }

    public Scope withControlDependencies(Iterable<Op> controls) {
        for (Op control : controls) {
            this.env.checkInput(control);
        }
        return new Scope(this.env, this.nameScope, controls, this.deviceSpec);
    }

    public OperationBuilder apply(OperationBuilder builder) {
        builder.setDevice(this.deviceSpec.toString());
        return this.applyControlDependencies(builder);
    }

    public OperationBuilder applyControlDependencies(OperationBuilder builder) {
        for (Op control : this.controlDependencies) {
            builder = builder.addControlInput(control.op());
        }
        return builder;
    }

    public String getDeviceString() {
        return this.deviceSpec.toString();
    }
}

