/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.index;

import java.util.StringJoiner;
import org.tensorflow.ndarray.impl.dimension.Dimension;
import org.tensorflow.ndarray.index.Index;

final class At
implements Index {
    private final long coord;
    private final boolean keepDim;

    @Override
    public long numElements(Dimension dim) {
        return 1L;
    }

    @Override
    public long mapCoordinate(long coordinate, Dimension dim) {
        long coord = this.coord >= 0L ? this.coord : dim.numElements() + this.coord;
        return dim.positionOf(coord);
    }

    @Override
    public Dimension apply(Dimension dim) {
        if (!this.keepDim) {
            throw new UnsupportedOperationException("Should be handled in DimensionalSpace.");
        }
        return dim.withIndex(this);
    }

    @Override
    public boolean isPoint() {
        return !this.keepDim;
    }

    At(long coord, boolean keepDim) {
        this.coord = coord;
        this.keepDim = keepDim;
    }

    @Override
    public long begin() {
        return this.coord;
    }

    @Override
    public long end() {
        return this.coord + 1L;
    }

    public String toString() {
        return new StringJoiner(", ", At.class.getSimpleName() + "(", ")").add("coord=" + this.coord).add("keepDim=" + this.keepDim).toString();
    }
}

