/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray;

import java.util.Arrays;

public final class Shape {
    public static long UNKNOWN_SIZE = -1L;
    private final long[] dimensionSizes;
    private Long size;

    public static Shape unknown() {
        return new Shape(null);
    }

    public static Shape scalar() {
        return new Shape(new long[0]);
    }

    public static Shape of(long ... dimensionSizes) {
        if (dimensionSizes == null || dimensionSizes.length == 0) {
            return Shape.scalar();
        }
        return new Shape(dimensionSizes);
    }

    public long size() {
        if (this.size == null) {
            this.size = Shape.computeSize(this.dimensionSizes);
        }
        return this.size;
    }

    public long size(int i) {
        if (this.dimensionSizes == null) {
            return UNKNOWN_SIZE;
        }
        if (i >= 0) {
            return this.dimensionSizes[i];
        }
        return this.dimensionSizes[this.dimensionSizes.length + i];
    }

    public int numDimensions() {
        return this.dimensionSizes != null ? this.dimensionSizes.length : -1;
    }

    public boolean hasUnknownDimension() {
        if (this.dimensionSizes == null) {
            return true;
        }
        for (long dimSize : this.dimensionSizes) {
            if (dimSize != UNKNOWN_SIZE) continue;
            return true;
        }
        return false;
    }

    public boolean isScalar() {
        return this.dimensionSizes != null && this.dimensionSizes.length == 0;
    }

    public boolean isVector() {
        return this.dimensionSizes != null && this.dimensionSizes.length == 1;
    }

    public boolean isMatrix() {
        return this.dimensionSizes != null && this.dimensionSizes.length == 2;
    }

    public boolean isUnknown() {
        return this.dimensionSizes == null;
    }

    public long[] asArray() {
        if (this.dimensionSizes == null) {
            return null;
        }
        return Arrays.copyOf(this.dimensionSizes, this.dimensionSizes.length);
    }

    public int hashCode() {
        return this.dimensionSizes != null ? Arrays.hashCode(this.dimensionSizes) : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Shape) {
            Shape otherShape = (Shape)obj;
            if (otherShape.hasUnknownDimension()) {
                return false;
            }
            return Arrays.equals(this.dimensionSizes, otherShape.dimensionSizes);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.dimensionSizes);
    }

    private Shape(long[] dimensionSizes) {
        this.dimensionSizes = dimensionSizes;
    }

    public Shape head() {
        return this.take(1);
    }

    public Shape take(int n) {
        if (n > this.numDimensions()) {
            throw new ArrayIndexOutOfBoundsException("Cannot take " + n + " dimensions, shape has only " + this.numDimensions() + ".");
        }
        long[] newDimensions = new long[n];
        System.arraycopy(this.dimensionSizes, 0, newDimensions, 0, n);
        return Shape.of(newDimensions);
    }

    public Shape tail() {
        if (this.dimensionSizes.length < 2) {
            return Shape.of(new long[0]);
        }
        return Shape.of(Arrays.copyOfRange(this.dimensionSizes, 1, this.dimensionSizes.length));
    }

    public Shape takeLast(int n) {
        if (n > this.numDimensions()) {
            throw new ArrayIndexOutOfBoundsException("Cannot take last " + n + " dimensions, shape has only " + this.numDimensions() + ".");
        }
        long[] newDimensions = new long[n];
        System.arraycopy(this.dimensionSizes, this.numDimensions() - n, newDimensions, 0, n);
        return Shape.of(newDimensions);
    }

    public Shape subShape(int begin, int end) {
        if (end > this.numDimensions()) {
            throw new ArrayIndexOutOfBoundsException("End index " + end + " out of bounds: shape only has " + this.numDimensions() + " dimensions.");
        }
        if (begin < 0) {
            throw new ArrayIndexOutOfBoundsException("Begin index " + begin + " out of bounds: cannot be less than 0.");
        }
        long[] newDimensions = new long[end - begin];
        System.arraycopy(this.dimensionSizes, begin, newDimensions, 0, end - begin);
        return Shape.of(newDimensions);
    }

    public Shape prepend(long firstDimension) {
        long[] newDimensions = new long[this.dimensionSizes.length + 1];
        newDimensions[0] = firstDimension;
        System.arraycopy(this.dimensionSizes, 0, newDimensions, 1, this.dimensionSizes.length);
        return Shape.of(newDimensions);
    }

    public Shape append(long lastDimension) {
        long[] newDimensions = new long[this.dimensionSizes.length + 1];
        newDimensions[newDimensions.length - 1] = lastDimension;
        System.arraycopy(this.dimensionSizes, 0, newDimensions, 0, this.dimensionSizes.length);
        return Shape.of(newDimensions);
    }

    public Shape prepend(Shape other) {
        long[] newDimensions = new long[other.dimensionSizes.length + this.dimensionSizes.length];
        System.arraycopy(other.dimensionSizes, 0, newDimensions, 0, other.dimensionSizes.length);
        System.arraycopy(this.dimensionSizes, 0, newDimensions, other.dimensionSizes.length, this.dimensionSizes.length);
        return Shape.of(newDimensions);
    }

    public Shape append(Shape other) {
        long[] newDimensions = new long[this.dimensionSizes.length + other.dimensionSizes.length];
        System.arraycopy(this.dimensionSizes, 0, newDimensions, 0, this.dimensionSizes.length);
        System.arraycopy(other.dimensionSizes, 0, newDimensions, this.dimensionSizes.length, other.dimensionSizes.length);
        return Shape.of(newDimensions);
    }

    private static long computeSize(long[] dimensionSizes) {
        if (dimensionSizes == null) {
            return UNKNOWN_SIZE;
        }
        long computedSize = 1L;
        for (long dimensionSize : dimensionSizes) {
            if (dimensionSize == UNKNOWN_SIZE) {
                return UNKNOWN_SIZE;
            }
            computedSize *= dimensionSize;
        }
        return computedSize;
    }

    public boolean isCompatibleWith(Shape shape) {
        if (!this.isUnknown() && !shape.isUnknown()) {
            if (this.numDimensions() != shape.numDimensions()) {
                return false;
            }
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (Shape.isCompatible(this.size(i), shape.size(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCompatible(long dim, long otherDim) {
        return dim == UNKNOWN_SIZE || otherDim == UNKNOWN_SIZE || dim == otherDim;
    }
}

