/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.impl.dense.IntDenseNdArray;
import org.tensorflow.types.TInt32;

public final class TInt32Mapper
extends TensorMapper<TInt32> {
    @Override
    protected TInt32 mapDense(RawTensor tensor) {
        IntDataBuffer buffer = TensorBuffers.toInts(TInt32Mapper.nativeHandle(tensor));
        return new DenseTInt32(tensor, buffer);
    }

    private static final class DenseTInt32
    extends IntDenseNdArray
    implements TInt32 {
        final RawTensor rawTensor;

        public Class<TInt32> type() {
            return TInt32.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTInt32(RawTensor rawTensor, IntDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

