/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.nlp.embedding;

import ai.djl.Model;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.nn.core.Embedding;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class GloveWordEmbeddingTranslatorFactory
implements TranslatorFactory {
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.singleton(new Pair(String.class, NDList.class));
    }

    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        if (!this.isSupported(input, output)) {
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        String unknownToken = ArgumentsUtil.stringValue(arguments, (String)"unknownToken");
        return new GloveWordEmbeddingTranslator(unknownToken);
    }

    private static final class GloveWordEmbeddingTranslator
    implements Translator<String, NDList> {
        private String unknownToken;
        private Embedding<String> embedding;

        public GloveWordEmbeddingTranslator(String unknownToken) {
            this.unknownToken = unknownToken;
        }

        public void prepare(TranslatorContext ctx) {
            try {
                this.embedding = (Embedding)ctx.getBlock();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("The model was not an embedding", e);
            }
        }

        public NDList processOutput(TranslatorContext ctx, NDList list) {
            list.detach();
            return list;
        }

        public NDList processInput(TranslatorContext ctx, String input) {
            if (this.embedding.hasItem((Object)input)) {
                return new NDList(new NDArray[]{ctx.getNDManager().create(this.embedding.embed((Object)input))});
            }
            return new NDList(new NDArray[]{ctx.getNDManager().create(this.embedding.embed((Object)this.unknownToken))});
        }
    }
}

