/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.jna.MxnetLibrary;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Utils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "mxnet";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static MxnetLibrary loadLibrary() {
        String libName = LibUtils.getLibName();
        logger.debug("Loading mxnet library from: {}", (Object)libName);
        if (System.getProperty("os.name").startsWith("Linux")) {
            ConcurrentHashMap<String, Integer> options = new ConcurrentHashMap<String, Integer>();
            int rtld = 1;
            options.put("open-flags", rtld);
            return (MxnetLibrary)Native.load((String)libName, MxnetLibrary.class, options);
        }
        return (MxnetLibrary)Native.load((String)libName, MxnetLibrary.class);
    }

    public static String getLibName() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null) {
            libName = LibUtils.findLibraryInClasspath();
        }
        return libName;
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = Utils.getEnvOrSystemProperty((String)"MXNET_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static synchronized String findLibraryInClasspath() {
        String overrideVersion = Utils.getEnvOrSystemProperty((String)"MXNET_VERSION");
        if (overrideVersion != null) {
            ai.djl.util.Platform platform = ai.djl.util.Platform.detectPlatform((String)LIB_NAME, (String)overrideVersion);
            return LibUtils.downloadMxnet(platform);
        }
        ai.djl.util.Platform platform = ai.djl.util.Platform.detectPlatform((String)LIB_NAME);
        if (platform.isPlaceholder()) {
            return LibUtils.downloadMxnet(platform);
        }
        return LibUtils.loadLibraryFromClasspath(platform);
    }

    private static String loadLibraryFromClasspath(ai.djl.util.Platform platform) {
        String string;
        block18: {
            Path tmp = null;
            try {
                String libName = System.mapLibraryName(LIB_NAME);
                Path cacheFolder = Utils.getEngineCacheDir((String)LIB_NAME);
                String version = platform.getVersion();
                String flavor = platform.getFlavor();
                if ("cpu".equals(flavor)) {
                    flavor = "mkl";
                } else if (!flavor.endsWith("mkl")) {
                    flavor = flavor + "mkl";
                }
                String classifier = platform.getClassifier();
                Path dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier);
                logger.debug("Using cache dir: {}", (Object)dir);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "native/lib/" + file;
                    logger.info("Extracting {} to cache ...", (Object)libPath);
                    try (InputStream is = ClassLoaderUtils.getResourceAsStream((String)libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block18;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract MXNet native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        List<String> mappedLibNames = Platform.isMac() ? Arrays.asList("libmxnet.dylib", "libmxnet.jnilib", "libmxnet.so") : Collections.singletonList(System.mapLibraryName(LIB_NAME));
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            for (String name : mappedLibNames) {
                if (p.isFile() && p.getName().endsWith(name)) {
                    return p.getAbsolutePath();
                }
                File file = new File(path, name);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String downloadMxnet(ai.djl.util.Platform platform) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean supported(ai.djl.util.Platform platform) {
        String version = platform.getVersion();
        if (version.startsWith("1.8.") || version.startsWith("1.9.")) {
            String flavor = platform.getFlavor();
            String cudaArch = platform.getCudaArch();
            if (flavor.startsWith("cu11")) {
                if (version.startsWith("1.8.")) {
                    return Arrays.asList("50", "60", "70", "80").contains(cudaArch);
                }
                return Arrays.asList("50", "60", "70", "75", "80", "86").contains(cudaArch);
            }
            if (flavor.startsWith("cu10")) {
                return Arrays.asList("30", "50", "60", "70", "75").contains(cudaArch);
            }
        }
        return true;
    }
}

