/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private Supplier<T> supplier;
    private Consumer<T> consumer;

    public ObjectPool(Supplier<T> supplier, Consumer<T> consumer) {
        this.supplier = supplier;
        this.consumer = consumer;
    }

    public T acquire() {
        T item = this.queue.poll();
        if (item == null && this.supplier != null) {
            return this.supplier.get();
        }
        return item;
    }

    public void recycle(T item) {
        if (this.consumer != null) {
            this.consumer.accept(item);
        }
        this.queue.add(item);
    }
}

