/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.Device;
import ai.djl.engine.EngineException;
import ai.djl.mxnet.engine.CachedOp;
import ai.djl.mxnet.engine.MxDeviceType;
import ai.djl.mxnet.engine.MxNDArray;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.engine.MxSymbolBlock;
import ai.djl.mxnet.engine.Symbol;
import ai.djl.mxnet.jna.FunctionInfo;
import ai.djl.mxnet.jna.LibFeature;
import ai.djl.mxnet.jna.LibUtils;
import ai.djl.mxnet.jna.MxnetLibrary;
import ai.djl.mxnet.jna.NativeSize;
import ai.djl.mxnet.jna.NativeSizeByReference;
import ai.djl.mxnet.jna.ObjectPool;
import ai.djl.mxnet.jna.PointerArray;
import ai.djl.mxnet.jna.StringArray;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.nn.Parameter;
import ai.djl.util.PairList;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class JnaUtils {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final ObjectPool<PointerByReference> REFS = new ObjectPool<PointerByReference>(PointerByReference::new, r -> r.setValue(null));
    private static final String[] OP_NAME_PREFIX = new String[]{"_contrib_", "_linalg_", "_sparse_", "_image_", "_random_"};
    private static final MxnetLibrary LIB = LibUtils.loadLibrary();
    private static final Map<String, FunctionInfo> OPS = JnaUtils.getNdArrayFunctions();
    private static final Set<String> FEATURES = JnaUtils.getFeaturesInternal();

    private JnaUtils() {
    }

    public static int getVersion() {
        IntBuffer version = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXGetVersion(version));
        return version.get();
    }

    public static Set<String> getAllOpNames() {
        IntBuffer outSize = IntBuffer.allocate(1);
        PointerByReference outArray = REFS.acquire();
        JnaUtils.checkCall(LIB.MXListAllOpNames(outSize, outArray));
        int size = outSize.get();
        Pointer[] pointers = outArray.getValue().getPointerArray(0L, size);
        HashSet<String> set = new HashSet<String>();
        for (Pointer p : pointers) {
            set.add(p.getString(0L, StandardCharsets.UTF_8.name()));
        }
        REFS.recycle(outArray);
        return set;
    }

    public static Map<String, FunctionInfo> getNdArrayFunctions() {
        Set<String> opNames = JnaUtils.getAllOpNames();
        ConcurrentHashMap<String, FunctionInfo> map = new ConcurrentHashMap<String, FunctionInfo>();
        PointerByReference ref = REFS.acquire();
        for (String opName : opNames) {
            JnaUtils.checkCall(LIB.NNGetOpHandle(opName, ref));
            String functionName = JnaUtils.getOpNamePrefix(opName);
            map.put(functionName, JnaUtils.getFunctionByName(opName, functionName, ref.getValue()));
            ref.setValue(null);
        }
        REFS.recycle(ref);
        return map;
    }

    public static FunctionInfo op(String opName) {
        if (!OPS.containsKey(opName)) {
            throw new IllegalArgumentException("Unknown operator: " + opName);
        }
        return OPS.get(opName);
    }

    private static FunctionInfo getFunctionByName(String name, String functionName, Pointer handle) {
        String[] nameRef = new String[]{name};
        String[] description = new String[1];
        IntBuffer numArgs = IntBuffer.allocate(1);
        PointerByReference argNameRef = REFS.acquire();
        PointerByReference argTypeRef = REFS.acquire();
        PointerByReference argDescRef = REFS.acquire();
        String[] keyVarArgs = new String[1];
        String[] returnType = new String[1];
        JnaUtils.checkCall(LIB.MXSymbolGetAtomicSymbolInfo(handle, nameRef, description, numArgs, argNameRef, argTypeRef, argDescRef, keyVarArgs, returnType));
        int count = numArgs.get();
        PairList arguments = new PairList();
        if (count != 0) {
            String[] argNames = argNameRef.getValue().getStringArray(0L, count, StandardCharsets.UTF_8.name());
            String[] argTypes = argTypeRef.getValue().getStringArray(0L, count, StandardCharsets.UTF_8.name());
            for (int i = 0; i < argNames.length; ++i) {
                arguments.add((Object)argNames[i], (Object)argTypes[i]);
            }
        }
        REFS.recycle(argNameRef);
        REFS.recycle(argTypeRef);
        REFS.recycle(argDescRef);
        return new FunctionInfo(handle, functionName, (PairList<String, String>)arguments);
    }

    public static int getGpuCount() {
        IntBuffer count = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXGetGPUCount(count));
        return count.get();
    }

    public static long[] getGpuMemory(Device device) {
        if (!device.isGpu()) {
            throw new IllegalArgumentException("Only GPU device is allowed.");
        }
        int deviceId = device.getDeviceId();
        long[] ret = new long[2];
        LongBuffer freeMem = LongBuffer.wrap(ret, 0, 1);
        LongBuffer totalMem = LongBuffer.wrap(ret, 1, 1);
        JnaUtils.checkCall(LIB.MXGetGPUMemoryInformation64(deviceId, freeMem, totalMem));
        return ret;
    }

    public static Set<String> getFeatures() {
        return FEATURES;
    }

    private static Set<String> getFeaturesInternal() {
        PointerByReference ref = REFS.acquire();
        NativeSizeByReference outSize = new NativeSizeByReference();
        JnaUtils.checkCall(LIB.MXLibInfoFeatures(ref, outSize));
        int size = outSize.getValue().intValue();
        if (size == 0) {
            REFS.recycle(ref);
            return Collections.emptySet();
        }
        LibFeature pointer = new LibFeature(ref.getValue());
        pointer.read();
        LibFeature[] features = (LibFeature[])pointer.toArray(size);
        HashSet<String> set = new HashSet<String>();
        for (LibFeature feature : features) {
            if (feature.getEnabled() != 1) continue;
            set.add(feature.getName());
        }
        REFS.recycle(ref);
        return set;
    }

    public static int randomSeed(int seed) {
        return LIB.MXRandomSeed(seed);
    }

    public static Pointer createNdArray(Device device, Shape shape, DataType dtype, int size, boolean delayedAlloc) {
        int deviceType = MxDeviceType.toDeviceType(device);
        int deviceId = device.getDeviceId();
        int delay = delayedAlloc ? 1 : 0;
        PointerByReference ref = REFS.acquire();
        long[] shapeArray = shape.getShape();
        JnaUtils.checkCall(LIB.MXNDArrayCreateEx64(shapeArray, size, deviceType, deviceId, delay, dtype.ordinal(), ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static Pointer createSparseNdArray(SparseFormat fmt, Device device, Shape shape, DataType dtype, DataType[] auxDTypes, Shape[] auxShapes, boolean delayedAlloc) {
        long[] shapeArray = shape.getShape();
        int deviceType = MxDeviceType.toDeviceType(device);
        int deviceId = device.getDeviceId();
        int delay = delayedAlloc ? 1 : 0;
        PointerByReference ref = REFS.acquire();
        IntBuffer auxDTypesInt = IntBuffer.wrap(Arrays.stream(auxDTypes).mapToInt(Enum::ordinal).toArray());
        IntBuffer auxNDims = IntBuffer.wrap(Arrays.stream(auxShapes).mapToInt(Shape::dimension).toArray());
        long[] auxShapesInt = Arrays.stream(auxShapes).mapToLong(Shape::head).toArray();
        JnaUtils.checkCall(LIB.MXNDArrayCreateSparseEx64(fmt.getValue(), shapeArray, shapeArray.length, deviceType, deviceId, delay, dtype.ordinal(), auxDTypes.length, auxDTypesInt, auxNDims, auxShapesInt, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static void ndArraySyncCopyFromNdArray(MxNDArray dest, MxNDArray src, int location) {
        JnaUtils.checkCall(LIB.MXNDArraySyncCopyFromNDArray((Pointer)dest.getHandle(), (Pointer)src.getHandle(), location));
    }

    public static NDList loadNdArray(MxNDManager manager, Path path, Device device) {
        IntBuffer handlesSize = IntBuffer.allocate(1);
        PointerByReference handlesRef = REFS.acquire();
        PointerByReference namesRef = REFS.acquire();
        IntBuffer namesSize = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXNDArrayLoad(path.toString(), handlesSize, handlesRef, namesSize, namesRef));
        int ndArrayCount = handlesSize.get();
        int nameCount = namesSize.get();
        if (nameCount > 0 && ndArrayCount != nameCount) {
            throw new IllegalStateException("Mismatch between names and arrays in checkpoint file: " + path.toString());
        }
        Pointer[] handles = handlesRef.getValue().getPointerArray(0L, ndArrayCount);
        NDList ndList = new NDList();
        if (nameCount == 0) {
            for (Pointer handle : handles) {
                ndList.add((Object)manager.create(handle));
            }
        } else {
            String[] names = namesRef.getValue().getStringArray(0L, nameCount);
            for (int i = 0; i < ndArrayCount; ++i) {
                MxNDArray array = manager.create(handles[i]);
                array.setName(names[i]);
                ndList.add((Object)array);
            }
        }
        REFS.recycle(namesRef);
        REFS.recycle(handlesRef);
        if (Device.cpu().equals((Object)device)) {
            return ndList;
        }
        NDList ret = ndList.toDevice(device, true);
        ndList.close();
        return ret;
    }

    public static void freeNdArray(Pointer ndArray) {
        JnaUtils.checkNDArray(ndArray, "free");
        JnaUtils.checkCall(LIB.MXNDArrayFree(ndArray));
    }

    public static void waitToRead(Pointer ndArray) {
        JnaUtils.checkNDArray(ndArray, "wait to read");
        JnaUtils.checkCall(LIB.MXNDArrayWaitToRead(ndArray));
    }

    public static void waitToWrite(Pointer ndArray) {
        JnaUtils.checkNDArray(ndArray, "wait to write");
        JnaUtils.checkCall(LIB.MXNDArrayWaitToWrite(ndArray));
    }

    public static void waitAll() {
        JnaUtils.checkCall(LIB.MXNDArrayWaitAll());
    }

    public static void syncCopyToCPU(Pointer ndArray, Pointer data, int len) {
        NativeSize size = new NativeSize(len);
        JnaUtils.checkNDArray(ndArray, "copy from");
        JnaUtils.checkNDArray(data, "copy to");
        JnaUtils.checkCall(LIB.MXNDArraySyncCopyToCPU(ndArray, data, size));
    }

    public static void syncCopyFromCPU(Pointer ndArray, Buffer data, int len) {
        NativeSize size = new NativeSize(len);
        Pointer pointer = Native.getDirectBufferPointer((Buffer)data);
        JnaUtils.checkCall(LIB.MXNDArraySyncCopyFromCPU(ndArray, pointer, size));
    }

    public static PairList<Pointer, SparseFormat> imperativeInvoke(Pointer function, NDArray[] src, NDArray[] dest, PairList<String, ?> params) {
        String[] values;
        String[] keys;
        if (params == null) {
            keys = EMPTY_ARRAY;
            values = EMPTY_ARRAY;
        } else {
            keys = (String[])params.keyArray((Object[])EMPTY_ARRAY);
            values = (String[])params.values().stream().map(Object::toString).toArray(String[]::new);
        }
        StringArray keyArray = StringArray.of(keys);
        StringArray valueArray = StringArray.of(values);
        PointerArray srcArray = JnaUtils.toPointerArray(src);
        PointerArray destArray = JnaUtils.toPointerArray(dest);
        PointerByReference destRef = REFS.acquire();
        destRef.setValue((Pointer)destArray);
        PointerByReference destSType = REFS.acquire();
        IntBuffer numOutputs = IntBuffer.allocate(1);
        numOutputs.put(0, 1);
        JnaUtils.checkCall(LIB.MXImperativeInvokeEx(function, src.length, srcArray, numOutputs, destRef, keys.length, keyArray, valueArray, destSType));
        int numOfOutputs = numOutputs.get(0);
        Pointer[] ptrArray = destRef.getValue().getPointerArray(0L, numOfOutputs);
        int[] sTypes = destSType.getValue().getIntArray(0L, numOfOutputs);
        PairList pairList = new PairList();
        for (int i = 0; i < numOfOutputs; ++i) {
            pairList.add((Object)ptrArray[i], (Object)SparseFormat.fromValue((int)sTypes[i]));
        }
        REFS.recycle(destRef);
        REFS.recycle(destSType);
        srcArray.recycle();
        keyArray.recycle();
        valueArray.recycle();
        if (destArray != null) {
            destArray.recycle();
        }
        return pairList;
    }

    public static SparseFormat getStorageType(Pointer ndArray) {
        IntBuffer type = IntBuffer.allocate(1);
        JnaUtils.checkNDArray(ndArray, "get the storage type of");
        JnaUtils.checkCall(LIB.MXNDArrayGetStorageType(ndArray, type));
        return SparseFormat.fromValue((int)type.get());
    }

    public static Device getDevice(Pointer ndArray) {
        IntBuffer deviceType = IntBuffer.allocate(1);
        IntBuffer deviceId = IntBuffer.allocate(1);
        JnaUtils.checkNDArray(ndArray, "get the device of");
        JnaUtils.checkCall(LIB.MXNDArrayGetContext(ndArray, deviceType, deviceId));
        String deviceTypeStr = MxDeviceType.fromDeviceType(deviceType.get(0));
        return Device.of((String)deviceTypeStr, (int)deviceId.get(0));
    }

    public static Shape getShape(Pointer ndArray) {
        IntBuffer dim = IntBuffer.allocate(1);
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkNDArray(ndArray, "get the shape of");
        JnaUtils.checkCall(LIB.MXNDArrayGetShapeEx64(ndArray, dim, ref));
        int nDim = dim.get();
        if (nDim == 0) {
            REFS.recycle(ref);
            return new Shape(new long[0]);
        }
        long[] shape = ref.getValue().getLongArray(0L, nDim);
        REFS.recycle(ref);
        return new Shape(shape);
    }

    public static DataType getDataType(Pointer ndArray) {
        IntBuffer dataType = IntBuffer.allocate(1);
        JnaUtils.checkNDArray(ndArray, "get the data type of");
        JnaUtils.checkCall(LIB.MXNDArrayGetDType(ndArray, dataType));
        return DataType.values()[dataType.get()];
    }

    public static boolean autogradSetIsRecording(boolean isRecording) {
        IntBuffer prev = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXAutogradSetIsRecording(isRecording ? 1 : 0, prev));
        return prev.get(0) == 1;
    }

    public static boolean autogradSetTraining(boolean isTraining) {
        IntBuffer prev = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXAutogradSetIsTraining(isTraining ? 1 : 0, prev));
        return prev.get(0) == 1;
    }

    public static boolean autogradIsRecording() {
        ByteBuffer isRecording = ByteBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXAutogradIsRecording(isRecording));
        return isRecording.get(0) == 1;
    }

    public static boolean autogradIsTraining() {
        ByteBuffer isTraining = ByteBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXAutogradIsTraining(isTraining));
        return isTraining.get(0) == 1;
    }

    public static void autogradMarkVariables(int numVar, Pointer varHandles, IntBuffer reqsArray, Pointer gradHandles) {
        PointerByReference varRef = REFS.acquire();
        PointerByReference gradRef = REFS.acquire();
        varRef.setValue(varHandles);
        gradRef.setValue(gradHandles);
        JnaUtils.checkCall(LIB.MXAutogradMarkVariables(numVar, varRef, reqsArray, gradRef));
        REFS.recycle(varRef);
        REFS.recycle(gradRef);
    }

    public static void autogradBackward(NDList array, int retainGraph) {
        PointerByReference ref = REFS.acquire();
        PointerArray pa = JnaUtils.toPointerArray(array);
        JnaUtils.checkCall(LIB.MXAutogradBackward(array.size(), pa, ref, retainGraph));
        REFS.recycle(ref);
        pa.recycle();
    }

    public static void autogradBackwardExecute(int numOutput, NDList array, NDArray outgrad, int numVariables, Pointer varHandles, int retainGraph, int createGraph, int isTrain, Pointer gradHandles, Pointer gradSparseFormat) {
        PointerByReference varRef = REFS.acquire();
        PointerByReference gradRef = REFS.acquire();
        PointerByReference gradSparseFormatRef = REFS.acquire();
        varRef.setValue(varHandles);
        gradRef.setValue(gradHandles);
        gradSparseFormatRef.setValue(gradSparseFormat);
        PointerArray inputHandles = JnaUtils.toPointerArray(array);
        PointerArray ogradHandles = PointerArray.of(new Pointer[0]);
        JnaUtils.checkCall(LIB.MXAutogradBackwardEx(numOutput, inputHandles, ogradHandles, numVariables, varRef, retainGraph, createGraph, isTrain, gradRef, gradSparseFormatRef));
        REFS.recycle(varRef);
        REFS.recycle(gradRef);
        REFS.recycle(gradSparseFormatRef);
        inputHandles.recycle();
        ogradHandles.recycle();
    }

    public static Pointer autogradGetSymbol(NDArray array) {
        Pointer handle = (Pointer)((MxNDArray)array).getHandle();
        PointerByReference out = REFS.acquire();
        JnaUtils.checkCall(LIB.MXAutogradGetSymbol(handle, out));
        Pointer pointer = out.getValue();
        REFS.recycle(out);
        return pointer;
    }

    public static int isNumpyMode() {
        IntBuffer ret = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXIsNumpyShape(ret));
        return ret.get();
    }

    public static void setNumpyMode(NumpyMode mode) {
        IntBuffer ret = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXSetIsNumpyShape(mode.ordinal(), ret));
    }

    public static Pointer getGradient(Pointer handle) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkNDArray(handle, "get the gradient for");
        JnaUtils.checkCall(LIB.MXNDArrayGetGrad(handle, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static Pointer parameterStoreCreate(String type) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXKVStoreCreate(type, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static void parameterStoreClose(Pointer handle) {
        JnaUtils.checkCall(LIB.MXKVStoreFree(handle));
    }

    public static void parameterStoreInit(Pointer handle, int num, String[] keys, NDList vals) {
        JnaUtils.checkNDArray(handle, "initialize the parameter store with");
        PointerArray pa = JnaUtils.toPointerArray(vals);
        JnaUtils.checkCall(LIB.MXKVStoreInitEx(handle, num, keys, pa));
        pa.recycle();
    }

    public static void parameterStorePush(Pointer handle, int num, String[] keys, NDList vals, int priority) {
        JnaUtils.checkNDArray(handle, "push to the parameter store with");
        PointerArray pa = JnaUtils.toPointerArray(vals);
        JnaUtils.checkCall(LIB.MXKVStorePushEx(handle, num, keys, pa, priority));
        pa.recycle();
    }

    public static void parameterStorePull(Pointer handle, int num, int[] keys, NDList vals, int priority) {
        JnaUtils.checkNDArray(handle, "pull from the parameter store with");
        PointerArray pa = JnaUtils.toPointerArray(vals);
        JnaUtils.checkCall(LIB.MXKVStorePull(handle, num, keys, pa, priority));
        pa.recycle();
    }

    public static void parameterStorePull(Pointer handle, int num, String[] keys, NDList vals, int priority) {
        JnaUtils.checkNDArray(handle, "pull from the parameter store with");
        PointerArray pa = JnaUtils.toPointerArray(vals);
        JnaUtils.checkCall(LIB.MXKVStorePullEx(handle, num, keys, pa, priority));
        pa.recycle();
    }

    public static void parameterStorePushPull(Pointer handle, int inputNum, String[] inputKeys, int outputNum, String[] outputKey, NDList inputs, NDList outputs, int priority) {
        JnaUtils.checkNDArray(handle, "push from the parameter store with");
        PointerArray inputHandles = JnaUtils.toPointerArray(inputs);
        PointerArray outputHandles = JnaUtils.toPointerArray(outputs);
        JnaUtils.checkCall(LIB.MXKVStorePushPullEx(handle, inputNum, inputKeys, outputNum, outputKey, inputHandles, outputHandles, priority));
        inputHandles.recycle();
        outputHandles.recycle();
    }

    public static void parameterStoreSetUpdater(Pointer handle, MxnetLibrary.MXKVStoreUpdater updater, MxnetLibrary.MXKVStoreStrUpdater stringUpdater, Pointer updaterHandle) {
        JnaUtils.checkCall(LIB.MXKVStoreSetUpdaterEx(handle, updater, stringUpdater, updaterHandle));
    }

    public static void parameterStoreSetUpdater(Pointer handle, MxnetLibrary.MXKVStoreUpdater updater, Pointer updaterHandle) {
        JnaUtils.checkCall(LIB.MXKVStoreSetUpdater(handle, updater, updaterHandle));
    }

    public static Pointer detachGradient(Pointer handle) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXNDArrayDetach(handle, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static Pointer getSymbolOutput(Pointer symbol, int index) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolGetOutput(symbol, index, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static String[] listSymbolOutputs(Pointer symbol) {
        IntBuffer size = IntBuffer.allocate(1);
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolListOutputs(symbol, size, ref));
        String[] ret = JnaUtils.toStringArray(ref, size.get());
        REFS.recycle(ref);
        return ret;
    }

    public static void freeSymbol(Pointer symbol) {
        JnaUtils.checkCall(LIB.MXSymbolFree(symbol));
    }

    public static String[] listSymbolNames(Pointer symbol) {
        IntBuffer size = IntBuffer.allocate(1);
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.NNSymbolListInputNames(symbol, 0, size, ref));
        String[] ret = JnaUtils.toStringArray(ref, size.get());
        REFS.recycle(ref);
        return ret;
    }

    public static String[] listSymbolArguments(Pointer symbol) {
        IntBuffer size = IntBuffer.allocate(1);
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolListArguments(symbol, size, ref));
        String[] ret = JnaUtils.toStringArray(ref, size.get());
        REFS.recycle(ref);
        return ret;
    }

    public static String[] listSymbolAuxiliaryStates(Pointer symbol) {
        IntBuffer size = IntBuffer.allocate(1);
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolListAuxiliaryStates(symbol, size, ref));
        String[] ret = JnaUtils.toStringArray(ref, size.get());
        REFS.recycle(ref);
        return ret;
    }

    public static Pointer getSymbolInternals(Pointer symbol) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolGetInternals(symbol, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static Pointer createSymbolFromFile(String path) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolCreateFromFile(path, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static Pointer createSymbolFromString(String json) {
        PointerByReference ref = REFS.acquire();
        JnaUtils.checkCall(LIB.MXSymbolCreateFromJSON(json, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return pointer;
    }

    public static String getSymbolString(Pointer symbol) {
        String[] holder = new String[1];
        JnaUtils.checkCall(LIB.MXSymbolSaveToJSON(symbol, holder));
        return holder[0];
    }

    private static List<Shape> recoverShape(NativeSizeByReference size, PointerByReference nDim, PointerByReference data) {
        int shapeLength = (int)size.getValue().longValue();
        if (shapeLength == 0) {
            return new ArrayList<Shape>();
        }
        int[] dims = nDim.getValue().getIntArray(0L, shapeLength);
        int flattenedLength = 0;
        for (int dim : dims) {
            flattenedLength += dim;
        }
        long[] flattenedShapes = data.getValue().getPointer(0L).getLongArray(0L, flattenedLength);
        int idx = 0;
        ArrayList<Shape> result = new ArrayList<Shape>();
        for (int dim : dims) {
            long[] shape = new long[dim];
            System.arraycopy(flattenedShapes, idx, shape, 0, dim);
            idx += dim;
            result.add(new Shape(shape));
        }
        return result;
    }

    public static List<List<Shape>> inferShape(Symbol symbol, PairList<String, Shape> args) {
        Pointer handler = (Pointer)symbol.getHandle();
        int numArgs = args.size();
        String[] keys = args.keys().toArray(new String[0]);
        long[] indPtr = new long[numArgs + 1];
        Shape flattened = new Shape(new long[0]);
        indPtr[0] = 0L;
        for (int i = 0; i < args.size(); ++i) {
            Shape shape = (Shape)args.valueAt(i);
            indPtr[i + 1] = shape.dimension();
            flattened = flattened.addAll(shape);
        }
        long[] flattenedShapeArray = flattened.getShape();
        NativeSizeByReference inShapeSize = new NativeSizeByReference();
        PointerByReference inShapeNDim = REFS.acquire();
        PointerByReference inShapeData = REFS.acquire();
        NativeSizeByReference outShapeSize = new NativeSizeByReference();
        PointerByReference outShapeNDim = REFS.acquire();
        PointerByReference outShapeData = REFS.acquire();
        NativeSizeByReference auxShapeSize = new NativeSizeByReference();
        PointerByReference auxShapeNDim = REFS.acquire();
        PointerByReference auxShapeData = REFS.acquire();
        IntBuffer complete = IntBuffer.allocate(1);
        JnaUtils.checkCall(LIB.MXSymbolInferShapeEx64(handler, numArgs, keys, indPtr, flattenedShapeArray, inShapeSize, inShapeNDim, inShapeData, outShapeSize, outShapeNDim, outShapeData, auxShapeSize, auxShapeNDim, auxShapeData, complete));
        if (complete.get() != 0) {
            return Arrays.asList(JnaUtils.recoverShape(inShapeSize, inShapeNDim, inShapeData), JnaUtils.recoverShape(outShapeSize, outShapeNDim, outShapeData), JnaUtils.recoverShape(auxShapeSize, auxShapeNDim, auxShapeData));
        }
        throw new IllegalArgumentException("Cannot infer shape based on the data provided!");
    }

    public static void loadLib(String path, boolean verbose) {
        int intVerbose = verbose ? 1 : 0;
        JnaUtils.checkCall(LIB.MXLoadLib(path, intVerbose));
    }

    public static Pointer optimizeFor(Symbol current, String backend, Device device) {
        PointerByReference returnedSymbolHandle = REFS.acquire();
        PointerByReference[] placeHolders = new PointerByReference[]{REFS.acquire(), REFS.acquire(), REFS.acquire(), REFS.acquire(), REFS.acquire(), REFS.acquire()};
        JnaUtils.checkCall(LIB.MXOptimizeForBackend((Pointer)current.getHandle(), backend, MxDeviceType.toDeviceType(device), returnedSymbolHandle, 0, placeHolders[0], 0, placeHolders[1], 0, new String[0], new String[0], IntBuffer.allocate(1), placeHolders[2], placeHolders[3], IntBuffer.allocate(1), placeHolders[4], placeHolders[5]));
        Pointer ptr = returnedSymbolHandle.getValue();
        REFS.recycle(returnedSymbolHandle);
        Arrays.stream(placeHolders).forEach(REFS::recycle);
        return ptr;
    }

    public static CachedOp createCachedOp(MxSymbolBlock block, MxNDManager manager, boolean training) {
        Symbol symbol = block.getSymbol();
        List<Parameter> parameters = block.getAllParameters();
        PairList dataIndices = new PairList();
        ArrayList<Integer> paramIndices = new ArrayList<Integer>();
        int index = 0;
        for (Parameter parameter : parameters) {
            if (parameter.isInitialized()) {
                paramIndices.add(index);
            } else {
                dataIndices.add((Object)parameter.getName(), (Object)index);
            }
            ++index;
        }
        Pointer symbolHandle = (Pointer)symbol.getHandle();
        PointerByReference ref = REFS.acquire();
        String staticAlloc = "1";
        String staticShape = "1";
        if (!Boolean.parseBoolean(System.getProperty("ai.djl.mxnet.static_alloc", "true"))) {
            staticAlloc = "0";
        }
        if (!Boolean.parseBoolean(System.getProperty("ai.djl.mxnet.static_shape", "true"))) {
            staticShape = "0";
        }
        String[] keys = new String[]{"data_indices", "param_indices", "static_alloc", "static_shape"};
        String[] values = new String[]{dataIndices.values().toString(), ((Object)paramIndices).toString(), staticAlloc, staticShape};
        JnaUtils.checkCall(LIB.MXCreateCachedOpEx(symbolHandle, keys.length, keys, values, ref));
        Pointer pointer = ref.getValue();
        REFS.recycle(ref);
        return new CachedOp(pointer, manager, parameters, paramIndices, (PairList<String, Integer>)dataIndices);
    }

    public static void freeCachedOp(Pointer handle) {
        JnaUtils.checkCall(LIB.MXFreeCachedOp(handle));
    }

    public static MxNDArray[] cachedOpInvoke(MxNDManager manager, Pointer cachedOpHandle, MxNDArray[] inputs) {
        IntBuffer buf = IntBuffer.allocate(1);
        PointerArray array = JnaUtils.toPointerArray((NDArray[])inputs);
        PointerByReference ref = REFS.acquire();
        PointerByReference outSTypeRef = REFS.acquire();
        JnaUtils.checkCall(LIB.MXInvokeCachedOpEx(cachedOpHandle, inputs.length, (Pointer)array, buf, ref, outSTypeRef));
        int numOutputs = buf.get();
        Pointer[] ptrArray = ref.getValue().getPointerArray(0L, numOutputs);
        int[] sTypes = outSTypeRef.getValue().getIntArray(0L, numOutputs);
        MxNDArray[] output = new MxNDArray[numOutputs];
        for (int i = 0; i < numOutputs; ++i) {
            output[i] = sTypes[i] != 0 ? manager.create(ptrArray[i], SparseFormat.fromValue((int)sTypes[i])) : manager.create(ptrArray[i]);
        }
        REFS.recycle(ref);
        REFS.recycle(outSTypeRef);
        array.recycle();
        return output;
    }

    public static void checkCall(int ret) {
        if (ret != 0) {
            throw new EngineException("MXNet engine call failed: " + JnaUtils.getLastError());
        }
    }

    private static PointerArray toPointerArray(NDList vals) {
        Pointer[] valPointers = new Pointer[vals.size()];
        for (int i = 0; i < vals.size(); ++i) {
            valPointers[i] = (Pointer)((MxNDArray)((Object)vals.get(i))).getHandle();
        }
        return PointerArray.of(valPointers);
    }

    private static PointerArray toPointerArray(NDArray[] vals) {
        if (vals == null) {
            return null;
        }
        Pointer[] valPointers = new Pointer[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            valPointers[i] = (Pointer)((MxNDArray)vals[i]).getHandle();
        }
        return PointerArray.of(valPointers);
    }

    private static void checkNDArray(Pointer pointer, String msg) {
        if (pointer == null) {
            throw new IllegalArgumentException("Tried to " + msg + " an MXNet NDArray that was already closed");
        }
    }

    private static String getLastError() {
        return LIB.MXGetLastError();
    }

    private static String[] toStringArray(PointerByReference ref, int size) {
        if (size == 0) {
            return new String[0];
        }
        Pointer[] pointers = ref.getValue().getPointerArray(0L, size);
        String[] arr = new String[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = pointers[i].getString(0L, StandardCharsets.UTF_8.name());
        }
        return arr;
    }

    private static String getOpNamePrefix(String name) {
        for (String prefix : OP_NAME_PREFIX) {
            if (!name.startsWith(prefix)) continue;
            return name.substring(prefix.length());
        }
        return name;
    }

    public static enum NumpyMode {
        OFF,
        THREAD_LOCAL_ON,
        GLOBAL_ON;

    }
}

