/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.tabular.CsvDataset;
import ai.djl.basicdataset.tabular.utils.Feature;
import ai.djl.basicdataset.tabular.utils.Featurizers;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.csv.CSVFormat;

public class DailyDelhiClimate
extends CsvDataset {
    private static final String ARTIFACT_ID = "daily-delhi-climate";
    private static final String VERSION = "3.0";
    private Dataset.Usage usage;
    private MRL mrl;
    private boolean prepared;

    DailyDelhiClimate(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    @Override
    public void prepare(Progress progress) throws IOException {
        Path csvFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Path root = this.mrl.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                csvFile = root.resolve("DailyDelhiClimateTrain.csv");
                break;
            }
            case TEST: {
                csvFile = root.resolve("DailyDelhiClimateTest.csv");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        this.csvUrl = csvFile.toUri().toURL();
        super.prepare(progress);
        this.prepared = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvDataset.CsvBuilder<Builder> {
        Repository repository;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "daily-delhi-climate";
        Dataset.Usage usage;
        List<String> featureArray = new ArrayList<String>(Arrays.asList("date", "meantemp", "humidity", "wind_speed", "meanpressure"));

        Builder() {
            this.repository = BasicDatasets.REPOSITORY;
            this.usage = Dataset.Usage.TRAIN;
            this.csvFormat = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setSkipHeaderRecord(true).setIgnoreHeaderCase(true).setTrim(true).get();
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this.self();
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this.self();
        }

        public Builder addFeature(String name) {
            if ("date".equals(name)) {
                return (Builder)((Object)this.addFeature(new Feature(name, Featurizers.getEpochDayFeaturizer("yyyy-MM-dd"))));
            }
            return (Builder)((Object)this.addNumericFeature(name));
        }

        public List<String> getAvailableFeatures() {
            return this.featureArray;
        }

        @Override
        public DailyDelhiClimate build() {
            if (this.features.isEmpty()) {
                for (String name : this.featureArray) {
                    this.addFeature(name);
                }
            }
            return new DailyDelhiClimate(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.Tabular.ANY, this.groupId, this.artifactId, DailyDelhiClimate.VERSION);
        }
    }
}

