/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv;

import ai.djl.basicdataset.cv.CocoMetadata;
import ai.djl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CocoUtils {
    private Path annotationPath;
    private boolean prepared;
    private List<Long> imageIds;
    private Map<Long, CocoMetadata.Image> imageMap;
    private Map<Long, CocoMetadata.Annotation> annotationMap;
    private Map<Long, List<Long>> imageToAnn;
    private Map<Long, Integer> categoryIdMap;

    CocoUtils(Path annotationPath) {
        this.annotationPath = annotationPath;
        this.imageIds = new ArrayList<Long>();
        this.imageMap = new HashMap<Long, CocoMetadata.Image>();
        this.annotationMap = new HashMap<Long, CocoMetadata.Annotation>();
        this.imageToAnn = new HashMap<Long, List<Long>>();
        this.categoryIdMap = new HashMap<Long, Integer>();
    }

    public void prepare() throws IOException {
        if (!this.prepared) {
            CocoMetadata metadata;
            try (BufferedReader reader = Files.newBufferedReader(this.annotationPath);){
                metadata = (CocoMetadata)JsonUtils.GSON.fromJson((Reader)reader, CocoMetadata.class);
            }
            this.createIndex(metadata);
            this.prepared = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createIndex(CocoMetadata metadata) {
        void var3_8;
        for (CocoMetadata.Annotation annotation : metadata.getAnnotations()) {
            long imageId = annotation.getImageId();
            long id = annotation.getId();
            if (!this.imageToAnn.containsKey(imageId)) {
                this.imageToAnn.put(annotation.getImageId(), new ArrayList());
            }
            this.imageToAnn.get(imageId).add(id);
            this.annotationMap.put(id, annotation);
        }
        for (CocoMetadata.Image image : metadata.getImages()) {
            this.imageIds.add(image.getId());
            this.imageMap.put(image.getId(), image);
        }
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        for (CocoMetadata.Category category : metadata.getCategories()) {
            categoryIds.add(category.getId());
        }
        boolean bl = false;
        while (var3_8 < categoryIds.size()) {
            this.categoryIdMap.put((Long)categoryIds.get((int)var3_8), (int)var3_8);
            ++var3_8;
        }
        Collections.sort(this.imageIds);
    }

    public List<Long> getImageIds() {
        return this.imageIds;
    }

    public Path getRelativeImagePath(long imageId) {
        CocoMetadata.Image image = this.imageMap.get(imageId);
        String[] cocoUrl = image.getCocoUrl().split("/");
        return Paths.get(cocoUrl[cocoUrl.length - 2], new String[0]).resolve(Paths.get(cocoUrl[cocoUrl.length - 1], new String[0]));
    }

    public List<Long> getAnnotationIdByImageId(long imageId) {
        return this.imageToAnn.get(imageId);
    }

    public CocoMetadata.Annotation getAnnotationById(long annotationId) {
        return this.annotationMap.get(annotationId);
    }

    public int mapCategoryId(long originalCategoryId) {
        return this.categoryIdMap.get(originalCategoryId);
    }
}

