/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular.utils;

import ai.djl.basicdataset.tabular.utils.DynamicBuffer;
import ai.djl.basicdataset.tabular.utils.Featurizer;
import ai.djl.basicdataset.tabular.utils.PreparedFeaturizer;
import ai.djl.modality.Classifications;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class Featurizers {
    private static final Featurizer NUMERIC_FEATURIZER = new NumericFeaturizer();

    private Featurizers() {
    }

    public static Featurizer getNumericFeaturizer() {
        return Featurizers.getNumericFeaturizer(false);
    }

    public static Featurizer getNumericFeaturizer(boolean normalize) {
        if (normalize) {
            return new NormalizedNumericFeaturizer();
        }
        return NUMERIC_FEATURIZER;
    }

    public static Featurizer getStringFeaturizer() {
        return Featurizers.getStringFeaturizer(true);
    }

    public static Featurizer getStringFeaturizer(boolean onehotEncode) {
        if (onehotEncode) {
            return new PreparedOneHotStringFeaturizer();
        }
        return new StringFeaturizer();
    }

    public static Featurizer getStringFeaturizer(Map<String, Integer> map, boolean onehotEncode) {
        if (onehotEncode) {
            return new OneHotStringFeaturizer(map);
        }
        return new StringFeaturizer(map);
    }

    public static Featurizer getEpochDayFeaturizer(String datePattern) {
        return new EpochDayFeaturizer(datePattern);
    }

    private static final class EpochDayFeaturizer
    implements Featurizer {
        String datePattern;

        EpochDayFeaturizer(String datePattern) {
            this.datePattern = datePattern;
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            LocalDate ld = LocalDate.parse(input, DateTimeFormatter.ofPattern(this.datePattern));
            long day = ld.toEpochDay();
            buf.put(day);
        }

        @Override
        public int dataRequired() {
            return 1;
        }

        @Override
        public Object deFeaturize(float[] data) {
            return LocalDate.ofEpochDay(Math.round(data[0]));
        }
    }

    private static final class StringFeaturizer
    extends BaseStringFeaturizer {
        private boolean autoMap;

        StringFeaturizer() {
            super(new HashMap<String, Integer>());
            this.autoMap = true;
        }

        StringFeaturizer(Map<String, Integer> map) {
            super(map);
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            Integer index = (Integer)this.map.get(input);
            if (index != null) {
                buf.put(index.intValue());
                return;
            }
            if (!this.autoMap) {
                throw new IllegalArgumentException("Value: " + input + " not found in the map.");
            }
            int value = this.map.size();
            this.map.put(input, value);
            buf.put(value);
        }

        @Override
        public Object deFeaturize(float[] data) {
            if (this.classNames.size() != this.map.size()) {
                this.buildClassNames();
            }
            return super.deFeaturize(data);
        }
    }

    private static final class PreparedOneHotStringFeaturizer
    extends OneHotStringFeaturizer
    implements PreparedFeaturizer {
        public PreparedOneHotStringFeaturizer() {
            super(null);
        }

        @Override
        public void prepare(List<String> inputs) {
            this.map = new ConcurrentHashMap();
            TreeSet<String> uniqueInputs = new TreeSet<String>(inputs);
            for (String input : uniqueInputs) {
                if (this.map.containsKey(input)) continue;
                this.map.put(input, this.map.size());
            }
            this.buildClassNames();
        }
    }

    private static class OneHotStringFeaturizer
    extends BaseStringFeaturizer {
        public OneHotStringFeaturizer(Map<String, Integer> map) {
            super(map);
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            for (int i = 0; i < this.map.size(); ++i) {
                buf.put(i == (Integer)this.map.get(input) ? 1.0f : 0.0f);
            }
        }
    }

    private static abstract class BaseStringFeaturizer
    implements Featurizer {
        protected Map<String, Integer> map;
        protected List<String> classNames;

        public BaseStringFeaturizer(Map<String, Integer> map) {
            this.map = map;
            if (map != null) {
                this.buildClassNames();
            }
        }

        @Override
        public int dataRequired() {
            return this.map.size();
        }

        @Override
        public Object deFeaturize(float[] data) {
            ArrayList<Double> probabilities = new ArrayList<Double>(data.length);
            float[] fArray = data;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float d = Float.valueOf(fArray[i]);
                probabilities.add(Double.valueOf(d.floatValue()));
            }
            return new Classifications(this.classNames, probabilities);
        }

        protected final void buildClassNames() {
            this.classNames = Arrays.asList(new String[this.map.size()]);
            for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
                this.classNames.set(entry.getValue(), entry.getKey());
            }
        }
    }

    private static final class NormalizedNumericFeaturizer
    implements PreparedFeaturizer {
        private float mean;
        private float std;

        private NormalizedNumericFeaturizer() {
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            float value = (Float.parseFloat(input) - this.mean) / this.std;
            buf.put(value);
        }

        @Override
        public void prepare(List<String> inputs) {
            this.calculateMean(inputs);
            this.calculateStd(inputs);
        }

        private void calculateMean(List<String> inputs) {
            double sum = 0.0;
            for (String input : inputs) {
                sum += (double)Float.parseFloat(input);
            }
            this.mean = (float)(sum / (double)inputs.size());
        }

        private void calculateStd(List<String> inputs) {
            double sum = 0.0;
            for (String input : inputs) {
                sum += Math.pow(Float.parseFloat(input) - this.mean, 2.0);
            }
            this.std = (float)Math.sqrt(sum / (double)inputs.size());
        }

        @Override
        public int dataRequired() {
            return 1;
        }

        @Override
        public Object deFeaturize(float[] data) {
            return Float.valueOf(data[0]);
        }
    }

    private static final class NumericFeaturizer
    implements Featurizer {
        private NumericFeaturizer() {
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            buf.put(Float.parseFloat(input));
        }

        @Override
        public int dataRequired() {
            return 1;
        }

        @Override
        public Object deFeaturize(float[] data) {
            return Float.valueOf(data[0]);
        }
    }
}

