/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.nlp;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.RawDataset;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Batch;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;

public class CookingStackExchange
implements RawDataset<Path> {
    private static final String ARTIFACT_ID = "cooking_stackexchange";
    private Dataset.Usage usage;
    private Path root;
    private Resource resource;
    private boolean prepared;

    CookingStackExchange(Builder builder) {
        this.usage = builder.usage;
        MRL mrl = MRL.dataset((Application)Application.NLP.ANY, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, "1.0");
    }

    @Override
    public Path getData() throws IOException {
        this.prepare(null);
        return this.root;
    }

    public Iterable<Batch> getData(NDManager manager) {
        return null;
    }

    public void prepare(Progress progress) throws IOException {
        Artifact.Item item;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        switch (this.usage) {
            case TRAIN: {
                item = (Artifact.Item)artifact.getFiles().get("train");
                break;
            }
            case TEST: {
                item = (Artifact.Item)artifact.getFiles().get("test");
                break;
            }
            default: {
                throw new IOException("Only training and testing dataset supported.");
            }
        }
        this.root = this.resource.getRepository().getFile(item, "").toAbsolutePath();
        this.prepared = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "cooking_stackexchange";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public CookingStackExchange build() {
            return new CookingStackExchange(this);
        }
    }
}

