/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.cv.output.Rectangle;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class Mask
extends Rectangle {
    private static final long serialVersionUID = 1L;
    private float[][] probDist;
    private boolean fullImageMask;

    public Mask(double x, double y, double width, double height, float[][] dist) {
        this(x, y, width, height, dist, false);
    }

    public Mask(double x, double y, double width, double height, float[][] dist, boolean fullImageMask) {
        super(x, y, width, height);
        this.probDist = dist;
        this.fullImageMask = fullImageMask;
    }

    public float[][] getProbDist() {
        return this.probDist;
    }

    public boolean isFullImageMask() {
        return this.fullImageMask;
    }

    @Override
    public JsonObject serialize() {
        JsonObject ret = super.serialize();
        if (this.fullImageMask) {
            ret.add("fullImageMask", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        ret.add("mask", JsonUtils.GSON.toJsonTree((Object)this.probDist));
        return ret;
    }

    public static float[][] toMask(NDArray array) {
        Shape maskShape = array.getShape();
        int height = (int)maskShape.get(0);
        int width = (int)maskShape.get(1);
        float[] flattened = array.toFloatArray();
        float[][] mask = new float[height][width];
        for (int i = 0; i < height; ++i) {
            System.arraycopy(flattened, i * width, mask[i], 0, width);
        }
        return mask;
    }
}

