/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.metric;

import ai.djl.metric.Dimension;
import ai.djl.metric.Unit;
import com.google.gson.annotations.SerializedName;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Metric {
    private static final Pattern PATTERN = Pattern.compile("\\s*([\\w\\s]+)\\.([\\w\\s]+):([0-9\\-,.e]+)(?>\\|#([^|]*))?(?>\\|(\\d+))?");
    private static final Dimension HOST = new Dimension("Host", Metric.getLocalHostName());
    @SerializedName(value="MetricName")
    private String metricName;
    @SerializedName(value="Value")
    private String value;
    @SerializedName(value="Unit")
    private String unit;
    @SerializedName(value="Dimensions")
    private Dimension[] dimensions;
    @SerializedName(value="Timestamp")
    private String timestamp;

    public Metric(String metricName, Number value) {
        this(metricName, value, Unit.COUNT);
    }

    public Metric(String metricName, Number value, Unit unit) {
        this(metricName, value.toString(), unit.getValue(), null, HOST);
    }

    public Metric(String metricName, Number value, Unit unit, Dimension ... dimensions) {
        this(metricName, value.toString(), unit.getValue(), null, dimensions);
    }

    private Metric(String metricName, String value, String unit, String timestamp, Dimension ... dimensions) {
        this.metricName = metricName;
        this.unit = unit;
        this.value = value;
        this.timestamp = timestamp;
        this.dimensions = dimensions;
    }

    public Metric copyOf(String name) {
        return new Metric(name, this.value, this.unit, this.timestamp, this.dimensions);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Double getValue() {
        return Double.valueOf(this.value);
    }

    public Unit getUnit() {
        return Unit.fromValue(this.unit);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Dimension[] getDimensions() {
        return this.dimensions;
    }

    public static Metric parse(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String metricName = matcher.group(1);
        String unit = matcher.group(2);
        String value = matcher.group(3);
        String dimension = matcher.group(4);
        String timestamp = matcher.group(5);
        Dimension[] dimensions = null;
        if (dimension != null) {
            String[] dims = dimension.split(",");
            dimensions = new Dimension[dims.length];
            int index = 0;
            for (String dim : dims) {
                String[] pair = dim.split(":");
                if (pair.length != 2) continue;
                dimensions[index++] = new Dimension(pair[0], pair[1]);
            }
        }
        return new Metric(metricName, value, unit, timestamp, dimensions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.metricName).append('.').append(this.unit).append(':').append(this.value);
        if (this.dimensions != null) {
            boolean first = true;
            for (Dimension dimension : this.dimensions) {
                if (dimension == null) continue;
                if (first) {
                    sb.append("|#");
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(dimension.getName()).append(':').append(dimension.getValue());
            }
        }
        if (this.timestamp != null) {
            sb.append('|').append(this.timestamp);
        }
        return sb.toString();
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }
}

