/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.hyperparameter.optimizer;

import ai.djl.training.hyperparameter.optimizer.HpOptimizer;
import ai.djl.training.hyperparameter.param.HpSet;
import ai.djl.util.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseHpOptimizer
implements HpOptimizer {
    protected HpSet hyperParams;
    protected Map<HpSet, Float> results;

    public BaseHpOptimizer(HpSet hyperParams) {
        this.hyperParams = hyperParams;
        this.results = new LinkedHashMap<HpSet, Float>();
    }

    @Override
    public void update(HpSet config, float loss) {
        this.results.compute(config, (k, oldLoss) -> Float.valueOf(oldLoss != null ? Math.max(oldLoss.floatValue(), loss) : loss));
    }

    @Override
    public float getLoss(HpSet config) {
        return this.results.get(config).floatValue();
    }

    @Override
    public Pair<HpSet, Float> getBest() {
        Map.Entry<HpSet, Float> entry = Collections.min(this.results.entrySet(), (e1, e2) -> Float.compare(((Float)e1.getValue()).floatValue(), ((Float)e2.getValue()).floatValue()));
        return new Pair<HpSet, Float>(entry.getKey(), entry.getValue());
    }
}

