/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.ndarray.NDArray;
import ai.djl.nn.Parameter;
import ai.djl.util.PairList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class Utils {
    private Utils() {
    }

    public static <T> int indexOf(T[] array, T value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return Utils.indexOf(array, value) >= 0;
    }

    public static void pad(StringBuilder sb, char c, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
    }

    public static void deleteQuietly(Path dir) {
        try {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void moveQuietly(Path source, Path target) throws IOException {
        block2: {
            try {
                Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                if (Files.exists(target, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    public static String toString(InputStream is) throws IOException {
        return new String(Utils.toByteArray(is), StandardCharsets.UTF_8.name());
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int read;
        byte[] buf = new byte[81920];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(81920);
        while ((read = is.read(buf)) != -1) {
            bos.write(buf, 0, read);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static List<String> readLines(Path file) throws IOException {
        return Utils.readLines(file, false);
    }

    public static List<String> readLines(Path file, boolean trim) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            List<String> list = Utils.readLines(is, trim);
            return list;
        }
    }

    public static List<String> readLines(InputStream is) {
        return Utils.readLines(is, false);
    }

    public static List<String> readLines(InputStream is, boolean trim) {
        ArrayList<String> list = new ArrayList<String>();
        try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\n|\\r\\n");){
            while (scanner.hasNext()) {
                String line = scanner.next();
                if (trim && (line = line.trim()).isEmpty()) continue;
                list.add(line);
            }
        }
        return list;
    }

    public static float[] toFloatArray(List<? extends Number> list) {
        float[] ret = new float[list.size()];
        int idx = 0;
        for (Number number : list) {
            ret[idx++] = number.floatValue();
        }
        return ret;
    }

    public static int getCurrentEpoch(Path modelDir, String modelName) throws IOException {
        Pattern pattern = Pattern.compile(Pattern.quote(modelName) + "-(\\d{4}).params");
        List checkpoints = Files.walk(modelDir, 1, new FileVisitOption[0]).map(p -> {
            Matcher m = pattern.matcher(p.toFile().getName());
            if (m.matches()) {
                return Integer.parseInt(m.group(1));
            }
            return null;
        }).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (checkpoints.isEmpty()) {
            return -1;
        }
        return (Integer)checkpoints.get(checkpoints.size() - 1);
    }

    public static void checkParameterValues(PairList<String, Parameter> parameters, boolean checkGradient, Logger logger) {
        for (Parameter parameter : parameters.values()) {
            logger.debug("Checking parameter: {} Shape: {}", (Object)parameter.getName(), (Object)parameter.getArray().getShape());
            Utils.checkNDArrayValues(parameter.getArray(), logger, "weight");
            if (!parameter.requiresGradient() || !checkGradient) continue;
            logger.debug("Checking gradient of: {}", (Object)parameter.getName());
            Utils.checkNDArrayValues(parameter.getArray().getGradient(), logger, "grad");
        }
    }

    public static void checkNDArrayValues(NDArray array, Logger logger, String prefix) {
        if (array.isNaN().any().getBoolean(new long[0])) {
            logger.warn("There are NANs in value:");
            int i = 0;
            while ((long)i < array.size(0)) {
                logger.warn("{}", (Object)array.get(i));
                ++i;
            }
        }
        logger.debug("{} sum: {}", (Object)prefix, (Object)Float.valueOf(array.sum().getFloat(new long[0])));
        logger.debug("{} mean: {}", (Object)prefix, (Object)Float.valueOf(array.mean().getFloat(new long[0])));
        logger.debug("{} max: {}", (Object)prefix, (Object)Float.valueOf(array.max().getFloat(new long[0])));
        logger.debug("{} min: {}", (Object)prefix, (Object)Float.valueOf(array.min().getFloat(new long[0])));
        logger.debug("{} shape: {}", (Object)prefix, (Object)array.getShape().toString());
    }

    public static Path getEngineCacheDir(String engine) {
        return Utils.getEngineCacheDir().resolve(engine);
    }

    public static Path getEngineCacheDir() {
        String cacheDir = System.getProperty("ENGINE_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("ENGINE_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            return Utils.getCacheDir();
        }
        return Paths.get(cacheDir, new String[0]);
    }

    public static Path getCacheDir() {
        String cacheDir = System.getProperty("DJL_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("DJL_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            Path dir = Paths.get(System.getProperty("user.home"), new String[0]);
            if (!Files.isWritable(dir)) {
                dir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            }
            return dir.resolve(".djl.ai");
        }
        return Paths.get(cacheDir, new String[0]);
    }
}

