/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.norm;

import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.IOException;

public class Dropout
extends AbstractBlock {
    private static final byte VERSION = 2;
    private float rate;

    Dropout(Builder builder) {
        super((byte)2);
        this.rate = builder.rate;
    }

    @Override
    protected NDList forwardInternal(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        return Dropout.dropout(inputs.singletonOrThrow(), this.rate, training);
    }

    @Override
    public Shape[] getOutputShapes(Shape[] inputShapes) {
        return new Shape[]{inputShapes[0]};
    }

    @Override
    public void loadMetadata(byte version, DataInputStream is) throws IOException, MalformedModelException {
        if (version == 2) {
            this.readInputShapes(is);
        } else if (version != 1) {
            throw new MalformedModelException("Unsupported encoding version: " + version);
        }
    }

    @Override
    public String toString() {
        return "Dropout()";
    }

    public static NDList dropout(NDArray input) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.dropout(input, 0.5f, true);
    }

    public static NDList dropout(NDArray input, float rate) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.dropout(input, rate, true);
    }

    public static NDList dropout(NDArray input, float rate, boolean training) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.dropout(input, rate, training);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float rate = 0.5f;

        Builder() {
        }

        public Builder optRate(float rate) {
            this.rate = rate;
            return this;
        }

        public Dropout build() {
            return new Dropout(this);
        }
    }
}

