/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.ndarray.NDList;

public class MultiBoxTarget {
    int minNegativeSamples;
    private float iouThreshold;
    private float negativeMiningRatio;
    private float ignoreLabel;
    private float negativeMiningThreshold;

    public MultiBoxTarget(Builder builder) {
        this.minNegativeSamples = builder.minNegativeSamples;
        this.iouThreshold = builder.iouThreshold;
        this.negativeMiningThreshold = builder.negativeMiningThreshold;
        this.negativeMiningRatio = builder.negativeMinigRatio;
        this.ignoreLabel = builder.ignoreLabel;
    }

    public NDList target(NDList inputs) {
        if (inputs == null || inputs.size() != 3) {
            throw new IllegalArgumentException("NDList must contain anchors, labels, and class predictions");
        }
        return inputs.head().getNDArrayInternal().multiBoxTarget(inputs, this.iouThreshold, this.ignoreLabel, this.negativeMiningRatio, this.negativeMiningThreshold, this.minNegativeSamples);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        int minNegativeSamples;
        float iouThreshold = 0.5f;
        float ignoreLabel = -1.0f;
        float negativeMiningThreshold = 0.5f;
        float negativeMinigRatio = -1.0f;

        Builder() {
        }

        public Builder optMinNegativeSamples(int minNegativeSamples) {
            this.minNegativeSamples = minNegativeSamples;
            return this;
        }

        public Builder optIouThreshold(float iouThreshold) {
            this.iouThreshold = iouThreshold;
            return this;
        }

        public Builder optIgnoreLabel(float ignoreLabel) {
            this.ignoreLabel = ignoreLabel;
            return this;
        }

        public Builder optNegativeMiningThreshold(float negativeMiningThreshold) {
            this.negativeMiningThreshold = negativeMiningThreshold;
            return this;
        }

        public Builder optNegativeMinigRatio(float negativeMinigRatio) {
            this.negativeMinigRatio = negativeMinigRatio;
            return this;
        }

        public MultiBoxTarget build() {
            return new MultiBoxTarget(this);
        }
    }
}

