/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality;

import ai.djl.util.PairList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Input {
    private String requestId;
    private Map<String, String> properties;
    private PairList<String, byte[]> content;

    public Input(String requestId) {
        this.requestId = requestId;
        this.properties = new ConcurrentHashMap<String, String>();
        this.content = new PairList();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public PairList<String, byte[]> getContent() {
        return this.content;
    }

    public void setContent(PairList<String, byte[]> content) {
        this.content = content;
    }

    public void addData(byte[] data) {
        this.addData(null, data);
    }

    public void addData(String key, byte[] data) {
        if (this.content == null) {
            this.content = new PairList();
        }
        this.content.add(key, data);
    }

    public void addData(int index, byte[] data) {
        if (this.content == null) {
            this.content = new PairList();
        }
        this.content.add(index, null, data);
    }
}

