/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import javax.jms.JMSException;
import org.activemq.store.PersistenceAdapter;
import org.activemq.util.Callback;
import org.activemq.util.JMSExceptionHelper;

public class TransactionTemplate {
    private PersistenceAdapter persistenceAdapter;

    public TransactionTemplate(PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
    }

    public void run(Callback task) throws JMSException {
        this.persistenceAdapter.beginTransaction();
        Throwable throwable = null;
        try {
            task.execute();
        }
        catch (JMSException t) {
            throwable = t;
            throw t;
        }
        catch (RuntimeException t) {
            throwable = t;
            throw t;
        }
        catch (Throwable t) {
            throwable = t;
            throw JMSExceptionHelper.newJMSException("Persistence task failed: " + t, t);
        }
        finally {
            if (throwable == null) {
                this.persistenceAdapter.commitTransaction();
            } else {
                this.persistenceAdapter.rollbackTransaction();
            }
        }
    }
}

