/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class FactoryFinder {
    private String path;
    private Map classes = new HashMap();

    public FactoryFinder(String path) {
        this.path = path;
    }

    public Object newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class type = this.findClass(key);
        return type.newInstance();
    }

    public Class findClass(String key) throws IOException, ClassNotFoundException {
        Class answer = (Class)this.classes.get(key);
        if (answer == null) {
            answer = this.doFindClass(key);
            this.classes.put(key, answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class doFindClass(String key) throws IOException, ClassNotFoundException {
        String uri = this.path + key;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        if (in == null && (in = this.getClass().getClassLoader().getResourceAsStream(uri)) == null) {
            throw new IOException("Could not find class for resource: " + uri);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            if (line == null) {
                throw new IOException("Empty file found for: " + uri);
            }
            Class answer = this.loadClass(line = line.trim());
            if (answer == null) {
                throw new ClassNotFoundException("Could not find class: " + line);
            }
            Class clazz = answer;
            return clazz;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(name);
        }
    }
}

