/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQBytesMessage;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.transport.stomp.AckListener;
import org.activemq.transport.stomp.FrameBuilder;
import org.activemq.transport.stomp.StompWireFormat;

class Subscription {
    private ActiveMQDestination destination;
    private int ackMode = 1;
    private StompWireFormat format;
    private short consumer_no;
    private final String consumerId;
    private final String subscriptionId;
    public static final String NO_ID = "~~ NO SUCH THING ~~%%@#!Q";
    static final int AUTO_ACK = 1;
    static final int CLIENT_ACK = 2;

    Subscription(StompWireFormat format, short consumer_no, String consumerId, String subscriptionId) {
        this.format = format;
        this.consumer_no = consumer_no;
        this.consumerId = consumerId;
        this.subscriptionId = subscriptionId;
    }

    void setDestination(ActiveMQDestination actual_dest) {
        this.destination = actual_dest;
    }

    void receive(ActiveMQTextMessage msg, DataOutput out) throws IOException, JMSException {
        if (this.ackMode == 2) {
            AckListener listener = new AckListener(msg, this.consumerId, this.consumer_no, this.subscriptionId);
            this.format.addAckListener(listener);
        } else if (this.ackMode == 1) {
            MessageAck ack = new MessageAck();
            ack.setDestination(msg.getJMSActiveMQDestination());
            ack.setConsumerId(this.consumerId);
            ack.setMessageID(msg.getJMSMessageID());
            ack.setMessageRead(true);
            ack.setSessionId(this.format.getSessionId());
            ack.setProducerKey(msg.getProducerKey());
            ack.setSequenceNumber(msg.getSequenceNumber());
            ack.setPersistent(msg.getJMSDeliveryMode() == 2);
            this.format.enqueuePacket(ack);
        }
        FrameBuilder builder = new FrameBuilder("MESSAGE").addHeaders(msg).setBody(msg.getText().getBytes());
        if (!this.subscriptionId.equals(NO_ID)) {
            builder.addHeader("subscription", this.subscriptionId);
        }
        out.write(builder.toFrame());
    }

    void receive(ActiveMQBytesMessage msg, DataOutput out) throws IOException, JMSException {
        if (this.ackMode == 2) {
            AckListener listener = new AckListener(msg, this.consumerId, this.consumer_no, this.subscriptionId);
            this.format.addAckListener(listener);
        } else if (this.ackMode == 1) {
            MessageAck ack = new MessageAck();
            ack.setDestination(msg.getJMSActiveMQDestination());
            ack.setConsumerId(this.consumerId);
            ack.setMessageID(msg.getJMSMessageID());
            ack.setMessageRead(true);
            ack.setSessionId(this.format.getSessionId());
            ack.setProducerKey(msg.getProducerKey());
            ack.setSequenceNumber(msg.getSequenceNumber());
            ack.setPersistent(msg.getJMSDeliveryMode() == 2);
            this.format.enqueuePacket(ack);
        }
        FrameBuilder builder = new FrameBuilder("MESSAGE").addHeaders(msg).setBody(msg.getBodyAsBytes().getBuf());
        if (!this.subscriptionId.equals(NO_ID)) {
            builder.addHeader("subscription", this.subscriptionId);
        }
        out.write(builder.toFrame());
    }

    ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setAckMode(int clientAck) {
        this.ackMode = clientAck;
    }

    public ConsumerInfo close() {
        ConsumerInfo unsub = new ConsumerInfo();
        unsub.setStarted(false);
        unsub.setDestination(this.destination);
        unsub.setClientId(this.format.getClientId());
        unsub.setConsumerNo(this.consumer_no);
        return unsub;
    }
}

