/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.relation.join;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.executor.etree.ETCancelState;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.HHJoinDataSource;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.HashRowView;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.HasherFactory;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.IHasher;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.IMasterJoinUnit;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.ISlaveJoinUnit;
import com.cloudera.impala.sqlengine.executor.etree.temptable.IRowView;
import com.cloudera.impala.sqlengine.executor.etree.temptable.InMemTable;
import com.cloudera.impala.sqlengine.executor.etree.temptable.IndexRowView;
import com.cloudera.impala.sqlengine.executor.etree.temptable.LongDataStore;
import com.cloudera.impala.sqlengine.executor.etree.temptable.RowComparator;
import com.cloudera.impala.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class Partition
implements ISlaveJoinUnit,
IMasterJoinUnit {
    private static final int BUFFER_SIZE = 8192;
    private static final int TRACKER_SIZE = 10;
    private HHJoinDataSource m_dataSource = null;
    private RepartitionState m_repState = null;
    private InMemTable m_data = null;
    private boolean m_isSlave = false;
    private int[] m_hashColumns = null;
    private long m_partitionSize = -1L;
    private HasherFactory m_hsFactory = null;
    private boolean[] m_dataNeeded = null;
    private IColumn[] m_columns = null;
    private Partition m_pairedPartion = null;
    private long m_memoryAssigned = 0L;
    private int m_inMemColSizeLimit = -1;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extProp;
    private final IColumn[] m_hashColMeta;
    private Map<Long, List<Integer>> m_hashedData;
    private List<Integer> m_seekedRows;
    private int m_cursor;
    private IHasher m_fineHasher;
    private RowComparator m_comparator;
    private IRowView m_matchingRow;
    private IndexRowView m_dataRow;
    private BitSet m_rowTracker;
    private int m_outerRowCursor;
    private HashRowView m_masterCompRow;
    private HashRowView m_compRow;
    private boolean m_outputOuter;
    private boolean m_saveOuterRows;
    private long[] m_rePartTracker;
    private IHasher m_rePartHasher;
    private LongDataStore m_longDataStore;

    public Partition(HHJoinDataSource hHJoinDataSource, IColumn[] iColumnArray, int[] nArray, IColumn[] iColumnArray2, HasherFactory hasherFactory, boolean[] blArray, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, LongDataStore longDataStore) {
        this.m_extProp = externalAlgorithmProperties;
        this.m_dataSource = hHJoinDataSource;
        this.m_hsFactory = hasherFactory;
        this.m_dataNeeded = blArray;
        this.m_columns = iColumnArray;
        this.m_partitionSize = Long.MAX_VALUE;
        this.m_rePartTracker = null;
        this.m_hashColumns = nArray;
        this.m_memoryAssigned = 0L;
        this.m_inMemColSizeLimit = externalAlgorithmProperties.getCellMemoryLimit();
        this.m_repState = null;
        this.m_longDataStore = longDataStore;
        this.m_isSlave = false;
        this.m_hashColMeta = (IColumn[])iColumnArray2.clone();
    }

    public void finishExecution() throws ErrorException {
        if (this.m_repState != null && !this.m_isSlave) {
            while (this.m_repState.moveToNextRow()) {
            }
        }
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        if (this.m_isSlave) {
            int n2;
            if (this.m_outputOuter) {
                n2 = this.m_outerRowCursor;
            } else {
                assert (this.m_seekedRows != null);
                assert (this.m_cursor >= 0 && this.m_cursor < this.m_seekedRows.size());
                n2 = this.m_seekedRows.get(this.m_cursor);
            }
            if (this.m_data.isLongDataColumn(n)) {
                if (this.m_data.isNull(n2, n)) {
                    eTDataRequest.getData().setNull();
                    return false;
                }
                assert (this.m_longDataStore != null);
                return this.m_longDataStore.retrieveData(this.m_data.getFileMarker(n2, n), eTDataRequest);
            }
            return this.m_data.retrieveData(n2, n, eTDataRequest);
        }
        return this.m_dataSource.retrieveData(n, eTDataRequest);
    }

    @Override
    public void close() {
        this.m_dataSource.close(false);
        if (this.m_data != null) {
            this.m_data.clear();
            this.m_data = null;
        }
    }

    @Override
    public IRowView getRow() {
        assert (!this.m_isSlave);
        return this.m_dataSource;
    }

    @Override
    public void seek(IRowView iRowView) {
        assert (this.m_isSlave);
        this.m_masterCompRow.setRow(iRowView);
        long l = this.m_fineHasher.hash(this.m_masterCompRow, this.m_masterCompRow.getHashColumns());
        this.m_seekedRows = this.m_hashedData.get(l);
        this.m_matchingRow = iRowView;
        this.m_cursor = -1;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (this.m_isSlave) {
            this.m_outputOuter = false;
            if (this.m_seekedRows == null) {
                return false;
            }
            while (++this.m_cursor < this.m_seekedRows.size()) {
                this.m_dataRow.setRowNum(this.m_seekedRows.get(this.m_cursor));
                if (!this.compareRow()) continue;
                return true;
            }
            return false;
        }
        if (this.m_repState != null) {
            return this.m_repState.moveToNextRow();
        }
        return this.m_dataSource.move();
    }

    @Override
    public boolean moveOuter() {
        assert (this.m_isSlave);
        while ((this.m_outerRowCursor = this.m_rowTracker.nextClearBit(this.m_outerRowCursor + 1)) <= this.m_data.getMaxRowNumber()) {
            if (!this.m_data.isRowInTable(this.m_outerRowCursor)) continue;
            this.m_outputOuter = true;
            return true;
        }
        return false;
    }

    @Override
    public void setOutputOuter() {
        assert (this.m_isSlave);
        this.m_outerRowCursor = -1;
    }

    @Override
    public boolean hasOuterRows() {
        block2: {
            assert (this.m_isSlave);
            int n = -1;
            do {
                ++n;
                if ((n = this.m_rowTracker.nextClearBit(n)) > this.m_data.getMaxRowNumber()) break block2;
            } while (!this.m_data.isRowInTable(n));
            return true;
        }
        return false;
    }

    @Override
    public void match() {
        if (this.m_isSlave) {
            this.m_rowTracker.set(this.m_seekedRows.get(this.m_cursor));
        }
    }

    public long getMemUsage() {
        return this.m_memoryAssigned;
    }

    public long takeExtraMem() {
        long l;
        assert (this.m_isSlave && this.m_repState != null);
        long l2 = this.m_memoryAssigned;
        this.m_memoryAssigned = l = (long)this.m_data.getMemUsage();
        return l2 - l;
    }

    public long getSize() {
        return this.m_partitionSize;
    }

    public void initAsSlave(boolean bl, boolean bl2, long l, Partition partition, RowComparator rowComparator, ETCancelState eTCancelState) throws ErrorException {
        if (null != this.m_extProp.getLogger()) {
            LogUtilities.logFunctionEntrance(this.m_extProp.getLogger(), new Object[0]);
        }
        this.m_comparator = rowComparator;
        this.m_isSlave = true;
        this.m_pairedPartion = partition;
        if (l < 0L) {
            throw new IllegalArgumentException("Setting a negative memory limit.");
        }
        this.m_memoryAssigned = l;
        this.m_data = new InMemTable(this.m_columns, this.m_inMemColSizeLimit, -1, this.m_dataNeeded, this.m_extProp.getLogger());
        this.m_data.setMemLimit(l);
        this.m_hashedData = new HashMap<Long, List<Integer>>();
        this.m_seekedRows = null;
        this.m_cursor = -1;
        this.m_fineHasher = this.m_hsFactory.nextHasher(Long.MAX_VALUE);
        this.m_matchingRow = null;
        this.m_dataRow = new IndexRowView(this.m_data);
        this.m_compRow = new HashRowView(this.m_hashColMeta, this.m_hashColumns, this.m_dataRow);
        this.m_masterCompRow = new HashRowView(this.m_hashColMeta, partition.m_hashColumns, null);
        this.m_rowTracker = new BitSet();
        this.m_outerRowCursor = -1;
        this.m_dataSource.reset();
        if (bl) {
            long l2 = this.m_memoryAssigned / 8192L;
            if (l2 < 2L) {
                l2 = 2L;
            }
            int n = this.m_extProp.getMaxNumOpenFiles() - 1;
            if (this.m_longDataStore != null) {
                --n;
            }
            if (l2 > (long)n) {
                if (n < 2) {
                    throw new IllegalStateException("number of sub-partitions is too small: " + n);
                }
                l2 = n;
            }
            this.m_repState = new RepartitionState(bl2, this.m_hsFactory.nextHasher(l2), eTCancelState);
            this.m_repState.repartitionSlave();
        } else {
            this.loadData();
        }
    }

    public void initAsMaster(boolean bl, boolean bl2, long l, Partition partition, boolean bl3, ETCancelState eTCancelState) throws ErrorException {
        if (null != this.m_extProp.getLogger()) {
            LogUtilities.logFunctionEntrance(this.m_extProp.getLogger(), new Object[0]);
        }
        this.m_isSlave = false;
        this.m_saveOuterRows = bl3;
        this.m_pairedPartion = partition;
        this.m_dataSource.reset();
        if (bl) {
            this.m_repState = new RepartitionState(bl2, null, eTCancelState);
            this.m_data = new InMemTable(this.m_columns, this.m_inMemColSizeLimit, -1, this.m_dataNeeded, this.m_extProp.getLogger());
            this.m_data.setMemLimit(l);
        }
    }

    public boolean canRepartition() {
        if (this.m_rePartTracker == null) {
            return true;
        }
        long l = -1L;
        for (long l2 : this.m_rePartTracker) {
            if (l2 <= l) continue;
            l = l2;
        }
        return (double)l / (double)this.getSize() < 0.75;
    }

    public HHJoinDataSource getDataSource() {
        return this.m_dataSource;
    }

    public boolean isRepartion() {
        return this.m_repState != null;
    }

    public Map<Long, Partition> takeSubPartition() throws ErrorException {
        if (null != this.m_extProp.getLogger()) {
            LogUtilities.logFunctionEntrance(this.m_extProp.getLogger(), new Object[0]);
        }
        assert (this.isRepartion());
        HashMap<Long, Partition> hashMap = this.m_repState.m_subPartition;
        this.m_repState.m_subPartition = null;
        for (Long l : hashMap.keySet()) {
            hashMap.get((Object)l).m_dataSource.reset();
        }
        return hashMap;
    }

    public Map<Long, Partition> takeProcessedPartition() throws ErrorException {
        if (null != this.m_extProp.getLogger()) {
            LogUtilities.logFunctionEntrance(this.m_extProp.getLogger(), new Object[0]);
        }
        assert (this.isRepartion());
        HashMap<Long, Partition> hashMap = this.m_repState.m_processedPartitions;
        this.m_repState.m_processedPartitions = null;
        for (Long l : hashMap.keySet()) {
            hashMap.get((Object)l).m_dataSource.reset();
        }
        return hashMap;
    }

    public void destroy() {
        if (null != this.m_extProp.getLogger()) {
            LogUtilities.logFunctionEntrance(this.m_extProp.getLogger(), new Object[0]);
        }
        this.m_dataSource.destroy();
        if (this.m_repState != null) {
            this.m_repState.cleanPartitions();
            this.m_repState = null;
        }
    }

    private void buildIndex(List<Integer> list) {
        HashRowView hashRowView = new HashRowView(this.m_hashColMeta, this.m_hashColumns, this.m_dataRow);
        for (int n : list) {
            this.m_dataRow.setRowNum(n);
            long l = this.m_fineHasher.hash(hashRowView, hashRowView.getHashColumns());
            if (this.m_hashedData.containsKey(l)) {
                this.m_hashedData.get(l).add(n);
                continue;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            this.m_hashedData.put(l, arrayList);
        }
    }

    private boolean compareRow() {
        boolean bl;
        int n = this.m_hashColumns.length;
        this.m_compRow.setRow(this.m_dataRow);
        this.m_masterCompRow.setRow(this.m_matchingRow);
        boolean bl2 = bl = 0 == this.m_comparator.compare(this.m_compRow, this.m_masterCompRow);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_compRow.isNull(i)) {
                return false;
            }
            short s = this.m_compRow.getColumn(i).getTypeMetadata().getType();
            if (!(8 == s || 6 == s ? Double.isNaN(this.m_compRow.getDouble(i)) : 7 == s && Float.isNaN(this.m_compRow.getReal(i)))) continue;
            return false;
        }
        return true;
    }

    private void initAsWriting() {
        this.m_rePartTracker = new long[10];
        this.m_rePartHasher = this.m_hsFactory.nextHasher(10L);
        this.m_partitionSize = 0L;
    }

    private void loadData() throws ErrorException {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (this.m_dataSource.move()) {
            int n = this.m_data.appendRow();
            assert (n >= 0);
            this.m_data.writeRow(n, this.m_dataSource);
            linkedList.add(n);
        }
        this.buildIndex(linkedList);
    }

    private void writeRows(InMemTable inMemTable, List<Integer> list, boolean bl) throws ErrorException {
        IndexRowView indexRowView = new IndexRowView(inMemTable);
        HashRowView hashRowView = new HashRowView(this.m_hashColMeta, this.m_hashColumns, indexRowView);
        for (int n : list) {
            int n2 = inMemTable.getRowSize(n);
            this.m_partitionSize += (long)n2;
            indexRowView.setRowNum(n);
            long l = this.m_rePartHasher.hash(hashRowView, hashRowView.getHashColumns());
            assert (l >= 0L && l < (long)this.m_rePartTracker.length);
            int n3 = (int)l;
            this.m_rePartTracker[n3] = this.m_rePartTracker[n3] + (long)n2;
        }
        this.m_dataSource.writeRows(inMemTable, list, 8192);
        if (bl) {
            for (int n : list) {
                inMemTable.removeRow(n);
            }
        }
    }

    @Override
    public void processUnmatchedOuterRow() throws ErrorException {
        assert (!this.m_isSlave);
        if (this.m_repState != null) {
            this.m_repState.processUnmatchedOuterRow();
        }
    }

    private class RepartitionState {
        private IHasher m_courseHasher;
        HashMap<Long, Partition> m_subPartition;
        HashMap<Long, List<Integer>> m_partialPartitions;
        HashMap<Long, Long> m_partSizes;
        HashMap<Long, List<Integer>> m_inMemPartitions;
        HashMap<Long, Partition> m_processedPartitions;
        private boolean m_maintainAllRows;
        private final ETCancelState m_cancelState;
        private long m_lastRowHashCode;
        private int m_lastRowNumber;

        public RepartitionState(boolean bl, IHasher iHasher, ETCancelState eTCancelState) {
            if (null != Partition.this.m_extProp.getLogger()) {
                LogUtilities.logFunctionEntrance(Partition.this.m_extProp.getLogger(), new Object[0]);
            }
            this.m_courseHasher = iHasher;
            this.m_subPartition = new HashMap();
            this.m_partialPartitions = new HashMap();
            this.m_partSizes = new HashMap();
            this.m_inMemPartitions = new HashMap();
            this.m_maintainAllRows = bl;
            this.m_processedPartitions = new HashMap();
            this.m_cancelState = eTCancelState;
        }

        public void repartitionSlave() throws ErrorException {
            try {
                if (null != Partition.this.m_extProp.getLogger()) {
                    LogUtilities.logFunctionEntrance(Partition.this.m_extProp.getLogger(), new Object[0]);
                }
                HashRowView hashRowView = new HashRowView(Partition.this.m_hashColMeta, Partition.this.m_hashColumns, Partition.this.m_dataSource);
                while (Partition.this.m_dataSource.move()) {
                    this.repartRow(hashRowView);
                }
                this.flushPartitions(this.m_partialPartitions, true);
                this.m_partialPartitions.clear();
                Partition.this.m_data.reduceMemoryUsage();
                if (this.m_maintainAllRows) {
                    this.flushPartitions(this.m_inMemPartitions, false);
                    Iterator<Object> iterator = this.m_inMemPartitions.keySet().iterator();
                    while (iterator.hasNext()) {
                        long l = (Long)iterator.next();
                        assert (this.m_subPartition.containsKey(l));
                        this.m_processedPartitions.put(l, this.m_subPartition.remove(l));
                    }
                }
                this.closePartitions();
                for (List list : this.m_inMemPartitions.values()) {
                    Partition.this.buildIndex(list);
                }
            }
            catch (ErrorException errorException) {
                this.cleanPartitions();
                throw errorException;
            }
            catch (RuntimeException runtimeException) {
                this.cleanPartitions();
                throw runtimeException;
            }
            catch (Error error) {
                this.cleanPartitions();
                throw error;
            }
        }

        public boolean moveToNextRow() throws ErrorException {
            try {
                Object object;
                if (null != Partition.this.m_extProp.getLogger()) {
                    LogUtilities.logFunctionEntrance(Partition.this.m_extProp.getLogger(), new Object[0]);
                }
                HashRowView hashRowView = new HashRowView(Partition.this.m_hashColMeta, Partition.this.m_hashColumns, Partition.this.m_dataSource);
                while (Partition.this.m_dataSource.move()) {
                    object = ((Partition)((Partition)Partition.this).m_pairedPartion).m_repState.m_courseHasher;
                    long l = object.hash(hashRowView, hashRowView.getHashColumns());
                    boolean bl = ((Partition)((Partition)Partition.this).m_pairedPartion).m_repState.m_inMemPartitions.containsKey(l);
                    boolean bl2 = ((Partition)((Partition)Partition.this).m_pairedPartion).m_repState.m_subPartition.containsKey(l);
                    if (!Partition.this.m_saveOuterRows && !bl && !bl2) continue;
                    if (this.m_maintainAllRows || bl2) {
                        this.repartRow(hashRowView);
                    }
                    if (!bl && bl2) continue;
                    return true;
                }
                this.flushPartitions(this.m_inMemPartitions, true);
                this.m_inMemPartitions.clear();
                this.flushPartitions(this.m_partialPartitions, true);
                this.m_partialPartitions.clear();
                if (this.m_maintainAllRows) {
                    object = this.m_subPartition.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry = (Map.Entry)object.next();
                        if (!((Partition)((Partition)Partition.this).m_pairedPartion).m_repState.m_processedPartitions.containsKey(entry.getKey())) continue;
                        object.remove();
                        this.m_processedPartitions.put((Long)entry.getKey(), (Partition)entry.getValue());
                    }
                }
                this.closePartitions();
                return false;
            }
            catch (ErrorException errorException) {
                this.cleanPartitions();
                throw errorException;
            }
            catch (RuntimeException runtimeException) {
                this.cleanPartitions();
                throw runtimeException;
            }
            catch (Error error) {
                this.cleanPartitions();
                throw error;
            }
        }

        public void cleanPartitions() {
            for (Partition partition : this.m_subPartition.values()) {
                partition.destroy();
            }
            this.m_subPartition.clear();
            for (Partition partition : this.m_processedPartitions.values()) {
                partition.destroy();
            }
            this.m_partialPartitions.clear();
        }

        private void closePartitions() {
            for (Partition partition : this.m_subPartition.values()) {
                partition.close();
            }
            for (Partition partition : this.m_processedPartitions.values()) {
                partition.close();
            }
        }

        private void flushPartitions(HashMap<Long, List<Integer>> hashMap, boolean bl) throws ErrorException {
            for (Map.Entry<Long, List<Integer>> entry : hashMap.entrySet()) {
                this.getSubpartition(entry.getKey()).writeRows(Partition.this.m_data, entry.getValue(), bl);
                this.m_partSizes.remove(entry.getKey());
            }
        }

        private Partition getSubpartition(long l) throws ErrorException {
            if (this.m_subPartition.containsKey(l)) {
                return this.m_subPartition.get(l);
            }
            Partition partition = new Partition(new HHJoinDataSource(Partition.this.m_longDataStore, Partition.this.m_dataNeeded, Partition.this.m_columns, Partition.this.m_extProp.getCellMemoryLimit(), Partition.this.m_extProp.getStorageDir(), Partition.this.m_extProp.getLogger()), Partition.this.m_columns, Partition.this.m_hashColumns, Partition.this.m_hashColMeta, Partition.this.m_hsFactory, Partition.this.m_dataNeeded, Partition.this.m_extProp, Partition.this.m_longDataStore);
            partition.initAsWriting();
            this.m_subPartition.put(l, partition);
            return partition;
        }

        private long maxSizePartition(Iterable<Long> iterable) {
            long l = -1L;
            long l2 = -1L;
            for (long l3 : iterable) {
                long l4 = this.m_partSizes.get(l3);
                if (l4 <= l) continue;
                l = l4;
                l2 = l3;
            }
            return l2;
        }

        private long getPartToFlush_slave() {
            if (!this.m_partialPartitions.isEmpty()) {
                long l = this.maxSizePartition(this.m_partialPartitions.keySet());
                if (this.m_partSizes.get(l) >= 8192L || this.m_inMemPartitions.size() == 0) {
                    return l;
                }
                long l2 = this.maxSizePartition(this.m_inMemPartitions.keySet());
                return this.m_partSizes.get(l) < this.m_partSizes.get(l2) ? l2 : l;
            }
            assert (!this.m_inMemPartitions.isEmpty());
            return this.maxSizePartition(this.m_inMemPartitions.keySet());
        }

        private long getPartToFlush_master() {
            if (!this.m_partialPartitions.isEmpty() && !this.m_inMemPartitions.isEmpty()) {
                long l = this.maxSizePartition(this.m_partialPartitions.keySet());
                long l2 = this.maxSizePartition(this.m_inMemPartitions.keySet());
                return this.m_partSizes.get(l) < this.m_partSizes.get(l2) ? l2 : l;
            }
            if (!this.m_partialPartitions.isEmpty()) {
                return this.maxSizePartition(this.m_partialPartitions.keySet());
            }
            assert (!this.m_inMemPartitions.isEmpty());
            return this.maxSizePartition(this.m_inMemPartitions.keySet());
        }

        private void repartRow(HashRowView hashRowView) throws ErrorException {
            HashMap<Long, List<Integer>> hashMap;
            long l;
            int n;
            while ((n = Partition.this.m_data.appendRow()) < 0) {
                this.m_cancelState.checkCancel();
                l = Partition.this.m_isSlave ? this.getPartToFlush_slave() : this.getPartToFlush_master();
                List<Integer> list = this.m_partialPartitions.remove(l);
                if (list == null) {
                    list = this.m_inMemPartitions.remove(l);
                }
                this.getSubpartition(l).writeRows(Partition.this.m_data, list, true);
                this.m_partSizes.remove(l);
            }
            l = Partition.this.m_isSlave ? this.m_courseHasher.hash(hashRowView, hashRowView.getHashColumns()) : ((Partition)((Partition)Partition.this).m_pairedPartion).m_repState.m_courseHasher.hash(hashRowView, hashRowView.getHashColumns());
            Partition.this.m_data.writeRow(n, hashRowView.getWrapped());
            long l2 = Partition.this.m_data.getRowSize(n);
            if (this.m_partSizes.containsKey(l)) {
                this.m_partSizes.put(l, this.m_partSizes.get(l) + l2);
            } else {
                this.m_partSizes.put(l, l2);
            }
            this.m_lastRowHashCode = l;
            this.m_lastRowNumber = n;
            HashMap<Long, List<Integer>> hashMap2 = hashMap = this.m_subPartition.containsKey(l) ? this.m_partialPartitions : this.m_inMemPartitions;
            if (hashMap.containsKey(l)) {
                ((List)hashMap.get(l)).add(n);
            } else {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                hashMap.put(l, arrayList);
                arrayList.add(n);
            }
        }

        public void processUnmatchedOuterRow() throws ErrorException {
            if (this.m_maintainAllRows) {
                List<Integer> list = this.m_inMemPartitions.get(this.m_lastRowHashCode);
                assert (list.get(list.size() - 1) == this.m_lastRowNumber);
                list.remove(list.size() - 1);
                if (list.isEmpty()) {
                    this.m_inMemPartitions.remove(this.m_lastRowHashCode);
                }
            }
        }
    }
}

