/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.datawrapper;

import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.impala.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.impala.support.exceptions.ErrorException;

public final class SqlBinaryDataWrapper
extends DefaultSqlDataWrapper {
    private byte[] m_data;
    private boolean m_isSet = false;
    private final int m_type;

    public SqlBinaryDataWrapper(int n) {
        assert (n == -2 || n == -3 || n == -4);
        this.m_type = n;
    }

    @Override
    public byte[] getBinary() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return this.m_data == null;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setBinary(byte[] byArray) {
        this.m_isSet = true;
        this.m_data = byArray;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            byte[] byArray = null;
            switch (dataWrapper.getType()) {
                case -2: {
                    byArray = dataWrapper.getBinary();
                    break;
                }
                case -3: {
                    byArray = dataWrapper.getVarBinary();
                    break;
                }
                case -4: {
                    byArray = dataWrapper.getLongVarBinary();
                    break;
                }
                case 0: {
                    if (dataWrapper.isNull()) {
                        byArray = null;
                        break;
                    }
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
            this.setBinary(byArray);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        switch (this.m_type) {
            case -2: {
                dataWrapper.setBinary(this.m_data);
                break;
            }
            case -3: {
                dataWrapper.setVarBinary(this.m_data);
                break;
            }
            case -4: {
                dataWrapper.setLongVarBinary(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

