/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.jsontype.impl;

import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.BeanDescription;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.DeserializationContext;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.JavaType;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.JsonMappingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SubTypeValidator {
    protected static final String PREFIX_SPRING = "org.springframework.";
    protected static final String PREFIX_C3P0 = "com.mchange.v2.c3p0.";
    protected static final Set<String> DEFAULT_NO_DESER_CLASS_NAMES;
    protected Set<String> _cfgIllegalClassNames = DEFAULT_NO_DESER_CLASS_NAMES;
    private static final SubTypeValidator instance;

    protected SubTypeValidator() {
    }

    public static SubTypeValidator instance() {
        return instance;
    }

    public void validateSubType(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        String full;
        block6: {
            block7: {
                block8: {
                    Class<?> raw = type.getRawClass();
                    full = raw.getName();
                    if (this._cfgIllegalClassNames.contains(full)) break block6;
                    if (raw.isInterface()) break block7;
                    if (!full.startsWith(PREFIX_SPRING)) break block8;
                    for (Class<?> cls = raw; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                        String name = cls.getSimpleName();
                        if (!"AbstractPointcutAdvisor".equals(name) && !"AbstractApplicationContext".equals(name)) {
                            continue;
                        }
                        break block6;
                    }
                    break block7;
                }
                if (full.startsWith(PREFIX_C3P0) && full.endsWith("DataSource")) break block6;
            }
            return;
        }
        ctxt.reportBadTypeDefinition(beanDesc, "Illegal type (%s) to deserialize: prevented for security reasons", full);
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.collections.functors.InvokerTransformer");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.collections.functors.InstantiateTransformer");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.collections4.functors.InvokerTransformer");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.collections4.functors.InstantiateTransformer");
        s.add("org.codehaus.groovy.runtime.ConvertedClosure");
        s.add("org.codehaus.groovy.runtime.MethodClosure");
        s.add("org.springframework.beans.factory.ObjectFactory");
        s.add("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
        s.add("com.cloudera.impala.jdbc42.internal.apache.xalan.xsltc.trax.TemplatesImpl");
        s.add("com.sun.rowset.JdbcRowSetImpl");
        s.add("java.util.logging.FileHandler");
        s.add("java.rmi.server.UnicastRemoteObject");
        s.add("org.springframework.beans.factory.config.PropertyPathFactoryBean");
        s.add("org.springframework.aop.config.MethodLocatingFactoryBean");
        s.add("org.springframework.beans.factory.config.BeanReferenceFactoryBean");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp2.BasicDataSource");
        s.add("com.sun.org.apache.bcel.internal.util.ClassLoader");
        s.add("org.hibernate.jmx.StatisticsService");
        s.add("com.cloudera.impala.jdbc42.internal.apache.ibatis.datasource.jndi.JndiDataSourceFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.ibatis.parsing.XPathParser");
        s.add("jodd.db.connection.DataSourceConnectionProvider");
        s.add("oracle.jdbc.connector.OracleManagedConnectionFactory");
        s.add("oracle.jdbc.rowset.OracleJDBCRowSet");
        s.add("com.cloudera.impala.jdbc42.internal.slf4j.ext.EventData");
        s.add("flex.messaging.util.concurrent.AsynchBeansWorkManagerExecutor");
        s.add("com.sun.deploy.security.ruleset.DRSHelper");
        s.add("com.cloudera.impala.jdbc42.internal.apache.axis2.jaxws.spi.handler.HandlerResolverImpl");
        s.add("org.jboss.util.propertyeditor.DocumentEditor");
        s.add("com.cloudera.impala.jdbc42.internal.apache.openjpa.ee.RegistryManagedRuntime");
        s.add("com.cloudera.impala.jdbc42.internal.apache.openjpa.ee.JNDIManagedRuntime");
        s.add("com.cloudera.impala.jdbc42.internal.apache.openjpa.ee.WASRegistryManagedRuntime");
        s.add("com.cloudera.impala.jdbc42.internal.apache.axis2.transport.jms.JMSOutTransportInfo");
        s.add("com.mysql.cj.jdbc.admin.MiniAdmin");
        s.add("ch.qos.logback.core.db.DriverManagerConnectionSource");
        s.add("org.jdom.transform.XSLTransformer");
        s.add("org.jdom2.transform.XSLTransformer");
        s.add("net.sf.ehcache.transaction.manager.DefaultTransactionManagerLookup");
        s.add("net.sf.ehcache.hibernate.EhcacheJtaTransactionManagerLookup");
        s.add("ch.qos.logback.core.db.JNDIConnectionSource");
        s.add("com.zaxxer.hikari.HikariConfig");
        s.add("com.zaxxer.hikari.HikariDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.cxf.jaxrs.provider.XSLTJaxbProvider");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.configuration.JNDIConfiguration");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.configuration2.JNDIConfiguration");
        s.add("com.cloudera.impala.jdbc42.internal.apache.xalan.lib.sql.JNDIConnectionPool");
        s.add("com.sun.org.apache.xalan.internal.lib.sql.JNDIConnectionPool");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.dbcp.datasources.PerUserPoolDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.dbcp.datasources.SharedPoolDataSource");
        s.add("com.p6spy.engine.spy.P6DataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.log4j.receivers.db.DriverManagerConnectionSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.log4j.receivers.db.JNDIConnectionSource");
        s.add("net.sf.ehcache.transaction.manager.selector.GenericJndiSelector");
        s.add("net.sf.ehcache.transaction.manager.selector.GlassfishSelector");
        s.add("com.cloudera.impala.jdbc42.internal.apache.xbean.propertyeditor.JndiConverter");
        s.add("com.cloudera.impala.jdbc42.internal.apache.hadoop.shaded.com.zaxxer.hikari.HikariConfig");
        s.add("com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig");
        s.add("br.com.anteros.dbcp.AnterosDBCPConfig");
        s.add("br.com.anteros.dbcp.AnterosDBCPDataSource");
        s.add("javax.swing.JEditorPane");
        s.add("javax.swing.JTextPane");
        s.add("com.cloudera.impala.jdbc42.internal.apache.shiro.realm.jndi.JndiRealmFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.shiro.jndi.JndiObjectFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.ignite.cache.jta.jndi.CacheJndiTmLookup");
        s.add("com.cloudera.impala.jdbc42.internal.apache.ignite.cache.jta.jndi.CacheJndiTmFactory");
        s.add("org.quartz.utils.JNDIConnectionProvider");
        s.add("com.cloudera.impala.jdbc42.internal.apache.aries.transaction.jms.internal.XaPooledConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.aries.transaction.jms.RecoverablePooledConnectionFactory");
        s.add("com.caucho.config.types.ResourceRef");
        s.add("org.aoju.bus.proxy.provider.RmiProvider");
        s.add("org.aoju.bus.proxy.provider.remoting.RmiProvider");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.ActiveMQConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.ActiveMQXAConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.spring.ActiveMQConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.spring.ActiveMQXAConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.pool.JcaPooledConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.pool.PooledConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.pool.XaPooledConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.jms.pool.XaPooledConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.activemq.jms.pool.JcaPooledConnectionFactory");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.proxy.provider.remoting.RmiProvider");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.jelly.impl.Embedded");
        s.add("oadd.org.apache.xalan.lib.sql.JNDIConnectionPool");
        s.add("oadd.org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
        s.add("oadd.org.apache.commons.dbcp.datasources.PerUserPoolDataSource");
        s.add("oadd.org.apache.commons.dbcp.datasources.SharedPoolDataSource");
        s.add("oracle.jms.AQjmsQueueConnectionFactory");
        s.add("oracle.jms.AQjmsXATopicConnectionFactory");
        s.add("oracle.jms.AQjmsTopicConnectionFactory");
        s.add("oracle.jms.AQjmsXAQueueConnectionFactory");
        s.add("oracle.jms.AQjmsXAConnectionFactory");
        s.add("org.jsecurity.realm.jndi.JndiRealmFactory");
        s.add("com.pastdev.httpcomponents.configuration.JndiConfiguration");
        s.add("com.nqadmin.rowset.JdbcRowSetImpl");
        s.add("org.arrah.framework.rdbms.UpdatableJdbcRowsetImpl");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.dbcp2.datasources.PerUserPoolDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.dbcp2.datasources.SharedPoolDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS");
        s.add("com.newrelic.agent.deps.ch.qos.logback.core.db.JNDIConnectionSource");
        s.add("com.newrelic.agent.deps.ch.qos.logback.core.db.DriverManagerConnectionSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp.cpdsadapter.DriverAdapterCPDS");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp.datasources.PerUserPoolDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp2.cpdsadapter.DriverAdapterCPDS");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSource");
        s.add("com.cloudera.impala.jdbc42.internal.apache.tomcat.dbcp.dbcp2.datasources.SharedPoolDataSource");
        s.add("com.oracle.wls.shaded.org.apache.xalan.lib.sql.JNDIConnectionPool");
        s.add("org.docx4j.org.apache.xalan.lib.sql.JNDIConnectionPool");
        DEFAULT_NO_DESER_CLASS_NAMES = Collections.unmodifiableSet(s);
        instance = new SubTypeValidator();
    }
}

