/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.core;

import com.cloudera.impala.hivecommon.AbstractServerVersionUtils;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.HiveJDBCCasePreservingAlias;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.IServerVersion;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.impala.core.ImpalaJDBCServerVersion;
import com.cloudera.impala.jdbc.common.OAuthFlow;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;

public class ImpalaJDBCServerVersionUtils
extends AbstractServerVersionUtils {
    @Override
    public boolean isServerVersionSet(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case AUTO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public OAuthFlow getDefaultOAuthFlow() {
        return null;
    }

    @Override
    public IServerVersion getHighestServerVersion() {
        ImpalaJDBCServerVersion[] impalaJDBCServerVersionArray = ImpalaJDBCServerVersion.values();
        return impalaJDBCServerVersionArray[impalaJDBCServerVersionArray.length - 1];
    }

    @Override
    public int getIsTemporaryColIndex(IServerVersion iServerVersion) {
        return 1;
    }

    @Override
    public int getTableNameColIndex(IServerVersion iServerVersion) {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IServerVersion parseServerVersion(String string, ILogger iLogger) {
        try {
            if (string == "AUTO") {
                return ImpalaJDBCServerVersion.AUTO;
            }
            String[] stringArray = string.split("\\.");
            if (stringArray.length < 1) return ImpalaJDBCServerVersion.Im_1_0_1;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            n = new Integer(stringArray[0]);
            if (stringArray.length >= 2) {
                n2 = new Integer(stringArray[1]);
                if (stringArray.length >= 3) {
                    n3 = CoreUtils.extractPatchNumber(stringArray[2]);
                }
            }
            if (1 == n) {
                if (0 == n2) {
                    return ImpalaJDBCServerVersion.Im_1_0_1;
                }
                if (1 == n2) {
                    return ImpalaJDBCServerVersion.Im_1_1_1;
                }
                if (2 == n2) {
                    if (0 == n3) {
                        return ImpalaJDBCServerVersion.Im_1_2_0;
                    }
                    if (1 == n3) {
                        return ImpalaJDBCServerVersion.Im_1_2_1;
                    }
                    if (2 == n3) {
                        return ImpalaJDBCServerVersion.Im_1_2_2;
                    }
                    if (3 == n3) {
                        return ImpalaJDBCServerVersion.Im_1_2_3;
                    }
                    if (4 > n3) return ImpalaJDBCServerVersion.Im_1_0_1;
                    return ImpalaJDBCServerVersion.Im_1_2_4;
                }
                if (3 == n2) {
                    if (0 == n3) {
                        return ImpalaJDBCServerVersion.Im_1_3_0;
                    }
                    if (1 > n3) return ImpalaJDBCServerVersion.Im_1_0_1;
                    return ImpalaJDBCServerVersion.Im_1_3_1;
                }
                if (4 != n2) return ImpalaJDBCServerVersion.Im_1_4_3;
                if (3 > n3) {
                    return ImpalaJDBCServerVersion.Im_1_4_0;
                }
                if (3 > n3) return ImpalaJDBCServerVersion.Im_1_0_1;
                return ImpalaJDBCServerVersion.Im_1_4_3;
            }
            if (2 == n) {
                if (0 == n2) {
                    if (0 == n3) {
                        return ImpalaJDBCServerVersion.Im_2_0_0;
                    }
                    if (true > n3) return ImpalaJDBCServerVersion.Im_1_0_1;
                    return ImpalaJDBCServerVersion.Im_2_0_1;
                }
                if (1 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_1_0;
                }
                if (2 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_2_0;
                }
                if (3 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_3_0;
                }
                if (4 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_4_0;
                }
                if (5 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_5_0;
                }
                if (6 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_6_0;
                }
                if (7 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_7_0;
                }
                if (8 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_8_0;
                }
                if (9 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_9_0;
                }
                if (10 == n2) {
                    return ImpalaJDBCServerVersion.Im_2_10_0;
                }
                if (11 != n2) return ImpalaJDBCServerVersion.Im_2_12_0;
                return ImpalaJDBCServerVersion.Im_2_11_0;
            }
            if (3 != n) {
                if (3 >= n) return ImpalaJDBCServerVersion.Im_1_0_1;
                return this.getHighestServerVersion();
            }
            if (3 > n2) {
                return ImpalaJDBCServerVersion.Im_3_0_0;
            }
            if (3 > n2) return ImpalaJDBCServerVersion.Im_1_0_1;
            return ImpalaJDBCServerVersion.Im_3_3_0;
        }
        catch (Exception exception) {
            ImpalaJDBCServerVersion impalaJDBCServerVersion = (ImpalaJDBCServerVersion)this.getHighestServerVersion();
            if (null == iLogger) return impalaJDBCServerVersion;
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SERVER_VERSION_SET_HIGHEST_ERR.name(), new String[]{impalaJDBCServerVersion.name(), exception.getMessage()});
            LogUtilities.logWarning(errorException, iLogger);
            return impalaJDBCServerVersion;
        }
    }

    @Override
    public boolean reportsTypeChar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public boolean reportsTypeVarchar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public AuthMech resolveDefaultAuthMech(HiveJDBCSettings hiveJDBCSettings) {
        if (TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
            if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech) {
                return AuthMech.SASL_KERBEROS;
            }
            if (null != hiveJDBCSettings.m_username) {
                return AuthMech.UIDPWD;
            }
            return AuthMech.NOAUTH;
        }
        return AuthMech.NOAUTH;
    }

    @Override
    public boolean supportsComplexTypesInResults() {
        return false;
    }

    @Override
    public boolean supportsDescribeTable(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsV3Protocol(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsV6Protocol(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public boolean supportsV8Protocol(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_8_0);
    }

    @Override
    public boolean supportsAsynchronousOperations(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsCharLength(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public boolean supportsGetColumnsAPINullability(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsVarcharLength(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public boolean supportsDecimalPrecisionAndScale(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_1_4_0);
    }

    @Override
    public boolean supportsTypeBinary(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsTypeChar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public boolean supportsTypeDate(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_3_3_0);
    }

    @Override
    public boolean supportsTypeDecimal(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_1_4_0);
    }

    @Override
    public boolean supportSTypeReal(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_1_2_4);
    }

    @Override
    public boolean supportsTypeTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsTypeVarchar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, ImpalaJDBCServerVersion.Im_2_0_0);
    }

    @Override
    public boolean supportsNestedDataTypes(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_3_0);
    }

    @Override
    public boolean supportsUnionDataTypes(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsDMLstatement(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean hqlSupportsDefaultOrderBy(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean hqlSupportsDefaultOuterJoin(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public String supportsBackTickedAliases(IServerVersion iServerVersion, String string) {
        return "`" + string + "`";
    }

    @Override
    public boolean supportI16BufferForSmallInt(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportPushdownCatalogFilter(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_1_0_1: 
            case Im_1_1_1: 
            case Im_1_2_0: 
            case Im_1_2_1: 
            case Im_1_2_2: 
            case Im_1_2_3: 
            case Im_1_2_4: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsAliasingInScalarFun(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetColumnsAPI(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsQueryCommentHints(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_1_0_1: 
            case Im_1_1_1: 
            case Im_1_2_0: 
            case Im_1_2_1: 
            case Im_1_2_2: 
            case Im_1_2_3: 
            case Im_1_2_4: 
            case Im_1_3_0: 
            case Im_1_3_1: 
            case Im_1_4_0: 
            case Im_1_4_3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDisableLimitZeroForSimpleQuery() {
        return true;
    }

    @Override
    public boolean hasIssueWithNullTypeMetadata(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_1_0_1: 
            case Im_1_1_1: 
            case Im_1_2_0: 
            case Im_1_2_1: 
            case Im_1_2_2: 
            case Im_1_2_3: 
            case Im_1_2_4: 
            case Im_1_3_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasIssueWithNullTypeData(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsGetSchemasAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetTablesAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean needsColumnTypeCastForInsert(IServerVersion iServerVersion) {
        return this.supportsCharLength(iServerVersion);
    }

    @Override
    public boolean needsInsertOptimization(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean preservesAliasCase(HiveJDBCSettings hiveJDBCSettings) {
        return HiveJDBCCasePreservingAlias.PRESERVE_CASE == hiveJDBCSettings.m_columnNameAliaseCase;
    }

    @Override
    public boolean supportsTimeOnlyTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsDateOnlyTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsNewLineCharacter(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsLeftFunction(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_12_0);
    }

    @Override
    public boolean supportsMonthNameFunction(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_12_0);
    }

    @Override
    public boolean supportsQuarterFunction(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_12_0);
    }

    @Override
    public boolean supportsRightFunction(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_12_0);
    }

    @Override
    public boolean supportsWeekFunction(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, ImpalaJDBCServerVersion.Im_2_12_0);
    }

    @Override
    public boolean supportsAuthMech(AuthMech authMech) {
        switch (authMech) {
            case OAUTH_CLIENT_CREDENTIALS: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean sendUidViaOpenSessionReq(AuthMech authMech) {
        return AuthMech.NOAUTH == authMech;
    }

    @Override
    public boolean supportsHttp(AuthMech authMech) {
        switch (authMech) {
            case OAUTH_CLIENT_CREDENTIALS: 
            case NOAUTH: 
            case UIDPWD: 
            case SASL_KERBEROS: 
            case SAML_2_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDMLResults() {
        return true;
    }
}

