/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine.filters;

import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;

public class HiveJDBCFilter
implements IFilter {
    private IFilter m_filter;
    private boolean m_acceptEmptyStringAsCatalog;

    public HiveJDBCFilter(IFilter iFilter) {
        this(iFilter, false);
    }

    public HiveJDBCFilter(IFilter iFilter, boolean bl) {
        this.m_filter = iFilter;
        this.m_acceptEmptyStringAsCatalog = bl;
    }

    public boolean filter(String string) {
        DataWrapper dataWrapper = new DataWrapper();
        dataWrapper.setChar(string);
        if (null == this.m_filter) {
            return true;
        }
        return this.filter(dataWrapper);
    }

    @Override
    public boolean filter(DataWrapper dataWrapper) {
        if (this.m_filter.getColumnTag() == MetadataSourceColumnTag.CATALOG_NAME && this.filterOnCatalogName(dataWrapper)) {
            return true;
        }
        return this.m_filter.filter(dataWrapper);
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_filter.getColumnTag();
    }

    private boolean filterOnCatalogName(DataWrapper dataWrapper) {
        if (this.m_acceptEmptyStringAsCatalog) {
            try {
                if (dataWrapper.getVarChar().equals("")) {
                    return true;
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                // empty catch block
            }
        }
        return false;
    }
}

