/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.Nullable;
import com.cloudera.impala.dsi.exceptions.OperationCanceledException;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.DatabaseMetadataInfo;
import com.cloudera.impala.hivecommon.DownloadableResultSettings;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.api.CurrentBufferContext;
import com.cloudera.impala.hivecommon.api.DataTypeUtilities;
import com.cloudera.impala.hivecommon.api.HS2Buffer;
import com.cloudera.impala.hivecommon.api.HS2ClientWrapper;
import com.cloudera.impala.hivecommon.api.HS2OAuthClientWrapper;
import com.cloudera.impala.hivecommon.api.HS2SSOSAMLClientWrapper;
import com.cloudera.impala.hivecommon.api.HS2v6Buffer;
import com.cloudera.impala.hivecommon.api.HiveClientBase;
import com.cloudera.impala.hivecommon.api.HiveExecutionContext;
import com.cloudera.impala.hivecommon.api.HiveServer2BaseBuffer;
import com.cloudera.impala.hivecommon.api.IExecutorUtility;
import com.cloudera.impala.hivecommon.api.RowsetBuffer;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCPlaceholderTable;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonFunctionsMetadataSourceRow;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonSchemasMetadataSourceRow;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.cloudera.impala.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.exceptions.TETokenExpirationException;
import com.cloudera.impala.hivecommon.utils.HeartBeatThread;
import com.cloudera.impala.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.impala.jdbc.utils.WarningsUtils;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TDmlResult;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchOrientation;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoType;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TNamespace;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationHandle;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationState;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowResultLink;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkGetDirectResults;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkRowSetType;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TStatus;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TStatusCode;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeEntry;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeId;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeQualifiers;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TApplicationException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TBase;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocolException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HS2Client
extends HiveClientBase<HiveServer2BaseBuffer> {
    public HiveJDBCSettings m_settings;
    private static final String CLIENT_PROTOCOL_ERR_KEYWORD = "PROTOCOL";
    private static final String SHOW_DATABASES_STRING = "SHOW DATABASES";
    private static final int SHOW_DATABASES_RESULT_COLUM_IDX = 0;
    private static final String SHARK_REGEX = ".*[Ss][Hh][Aa][Rr][Kk][Ss][Ee][Rr][Vv][Ee][Rr].*";
    private static final Pattern SHARK_HIVE_VERSION = Pattern.compile("(.*)-shark-(.*)");
    private static final String SET_DASH_V_QUERY_STRING = "set -v";
    private static final int SET_DASH_V_RESULT_COLUM_IDX = 0;
    private static final String SET_CASE = "SET";
    private static final String SPARK_SERVER_NAME = "Spark";
    private static final String SPARK_LIVY_SERVER_NAME = "Livy JDBC";
    private static final String SPARK_LIVY_DEFAULT_SPARK_VERSION_STR = "2.4.0";
    private static final Map<String, String> HIVE_SPARK_VERSION_MAP;
    private static final int CATALOGS_MD_RS_NAME_IDX = 0;
    private static final int COLS_MD_RS_CATALOG_NAME_IDX = 0;
    private static final int COLS_MD_RS_SCHEMA_NAME_IDX = 1;
    private static final int COLS_MD_RS_TABLE_NAME_IDX = 2;
    private static final int COLS_MD_RS_COLUMN_NAME_IDX = 3;
    private static final int COLS_MD_RS_TYPE_NAME_IDX = 5;
    private static final int COLS_MD_RS_NULLABLE_IDX = 10;
    private static final int COLS_MD_RS_REMARKS_IDX = 11;
    private static final int TABLES_MD_RS_CATALOG_IDX = 0;
    private static final int TABLES_MD_RS_SCHEMA_IDX = 1;
    private static final int TABLES_MD_RS_NAME_IDX = 2;
    private static final int TABLES_MD_RS_TYPE_IDX = 3;
    private static final int TABLES_MD_RS_COMMENT_IDX = 4;
    private static final int FUNCTIONS_MD_RS_CATALOG_IDX = 0;
    private static final int FUNCTIONS_MD_RS_SCHEMA_IDX = 1;
    private static final int FUNCTIONS_MD_RS_NAME_IDX = 2;
    private static final int FUNCTIONS_MD_RS_COMMENT_IDX = 3;
    private static final int FUNCTIONS_MD_RS_TYPE_IDX = 4;
    private static final int FUNCTIONS_MD_RS_SPECIFIC_NAME_IDX = 5;
    private static final int SCHEMA_MD_RS_SCHEMA_IDX = 0;
    private static final int SCHEMA_MD_RS_CATALOG_IDX = 1;
    private static final String IMPALA_SERVER_NAME = "Impala";
    private static final int FILTER_CATALOG_RESTRICTION_IDX = 0;
    private static final int FILTER_SCHEMA_RESTRICTION_IDX = 1;
    private static final int FILTER_TABLE_RESTRICTION_IDX = 2;
    private static final int FILTER_COLUMN_RESTRICTION_IDX = 3;
    private static final int FILTER_FUNCTION_RESTRICTION_IDX = 4;
    private static final int GET_INFOS_SERVER_NAME_IDX = 0;
    private static final int GET_INFOS_DBMS_VER_IDX = 1;
    private static final String TBL_TYPE_TABLE = "TABLE";
    private static final int EXPECTED_SQLSTATE_STR_LEN = 5;
    private static final TProtocolVersion DEFAULT_HIVE_CLI_SERVICE_PROTOCOL;
    private boolean m_hasOpenSession;
    protected ILogger m_logger;
    private DatabaseMetadataInfo dbmdInfo;
    private HS2ClientWrapper m_client;
    private TOpenSessionResp m_openSessionResp;
    private IWarningListener m_warningListener;
    private HeartBeatThread m_heartBeatThread;
    private boolean m_enableDirectResults = false;
    private boolean m_enableArrow = false;

    public HS2Client(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        this.m_settings = hiveJDBCSettings;
        this.m_client = AuthMech.OAUTH_2 == this.m_settings.m_authMech ? new HS2OAuthClientWrapper(tProtocol, iLogger, this.m_settings) : (AuthMech.SAML_2_0 == this.m_settings.m_authMech ? new HS2SSOSAMLClientWrapper(tProtocol, iLogger, hiveJDBCSettings) : new HS2ClientWrapper(tProtocol, iLogger, hiveJDBCSettings));
        this.m_logger = iLogger;
        this.m_hasOpenSession = false;
        this.m_warningListener = iWarningListener;
        this.openSession();
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.UNION_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeVarchar(this.m_settings)) {
            DataTypeUtilities.addHiveType(TTypeId.VARCHAR_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeChar(this.m_settings)) {
            DataTypeUtilities.addHiveType(TTypeId.CHAR_TYPE, (short)1);
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.ARRAY_TYPE, (short)12);
            DataTypeUtilities.addHiveType(TTypeId.MAP_TYPE, (short)12);
            DataTypeUtilities.addHiveType(TTypeId.STRUCT_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeDate(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.DATE_TYPE, (short)91);
        }
    }

    public void cancelDelegationToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TCancelDelegationTokenReq tCancelDelegationTokenReq = new TCancelDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string);
        try {
            TCancelDelegationTokenResp tCancelDelegationTokenResp = this.m_client.CancelDelegationToken(tCancelDelegationTokenReq);
            this.checkResponseStatus(tCancelDelegationTokenResp.getStatus(), HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{tCancelDelegationTokenResp.getStatus().toString(), string});
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public void cancelOperation(HiveExecutionContext hiveExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TCancelOperationReq tCancelOperationReq = new TCancelOperationReq();
            tCancelOperationReq.setOperationHandle(hiveExecutionContext.m_executeResponse.getOperationHandle());
            TCancelOperationResp tCancelOperationResp = this.m_client.CancelOperation(tCancelOperationReq);
            Thread.sleep(1000L);
            String string = "CancelOperation";
            this.checkIfRespNull(tCancelOperationResp, string);
            this.checkResponseStatus(tCancelOperationResp.getStatus(), string);
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_OPERATION_CANCELLATION_ERR.name());
            errorException.initCause(exception);
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_OPERATION_CANCELLATION_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
        }
    }

    @Override
    public void checkFetchErrors(RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException {
        if (rowsetBuffer.getBuffer().m_hiveServer2Buffer == null) {
            return;
        }
        this.checkResponseStatus(rowsetBuffer.getBuffer().m_hiveServer2Buffer.getStatus(), HiveJDBCMessageKey.CONN_FETCH_RESULT_ERR.name(), new String[]{"Buffer Fetch Error"});
    }

    public void checkFetchSize(HiveExecutionContext hiveExecutionContext, long l) throws ErrorException {
        if (null != hiveExecutionContext.m_statement && this.m_settings.m_enableSetFetchSizeTesting && this.m_settings.m_setFetchSizeTakesPrecedence && l != (long)this.m_settings.m_expectedFetchSize) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SET_FETCH_SIZE_ERR.name(), "Fetch Size Error");
            throw errorException;
        }
    }

    @Override
    public void closeOperation(HiveExecutionContext hiveExecutionContext) {
        try {
            TCloseOperationResp tCloseOperationResp = null;
            if (hiveExecutionContext.m_hasDRCloseOpResp) {
                LogUtilities.logDebug("Using DirectResults TCloseOperationResp", this.m_logger);
                tCloseOperationResp = hiveExecutionContext.m_directResults.getCloseOperation();
                hiveExecutionContext.m_hasDRCloseOpResp = false;
                hiveExecutionContext.m_hasOpenOperation = false;
            } else if (hiveExecutionContext.m_hasOpenOperation) {
                if (hiveExecutionContext.m_heartbeatRegistered) {
                    this.getHeartBeatThread().removeOperationHandle(hiveExecutionContext.m_fetchResultsReq.getOperationHandle());
                }
                TCloseOperationReq tCloseOperationReq = new TCloseOperationReq();
                tCloseOperationReq.setOperationHandle(hiveExecutionContext.m_fetchResultsReq.getOperationHandle());
                hiveExecutionContext.m_hasOpenOperation = false;
                tCloseOperationResp = this.m_client.CloseOperation(tCloseOperationReq);
            }
            if (null != tCloseOperationResp && TStatusCode.ERROR_STATUS == tCloseOperationResp.getStatus().getStatusCode()) {
                LogUtilities.logError(this.buildExceptionFromTStatus(tCloseOperationResp.getStatus(), HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), new String[]{tCloseOperationResp.getStatus().getErrorMessage()}), this.m_logger);
                this.m_warningListener.postWarning(this.buildWarningFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tCloseOperationResp.getStatus()));
            }
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
        }
    }

    @Override
    public void closeSession() throws ErrorException {
        if (this.m_hasOpenSession) {
            try {
                TCloseSessionReq tCloseSessionReq = new TCloseSessionReq();
                tCloseSessionReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                this.m_client.CloseSession(tCloseSessionReq);
                if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                    this.m_client.getInputProtocol().getTransport().close();
                }
                this.m_hasOpenSession = false;
                this.m_settings.m_isConnAlive = false;
            }
            catch (Exception exception) {
                String string = "Close Session Error";
                if (!exception.getMessage().isEmpty()) {
                    string = string + ": " + exception.getMessage();
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), string);
                errorException.initCause(exception);
                throw errorException;
            }
            finally {
                if (this.m_settings.m_thriftHTTPSettings.m_enableSessionTag) {
                    this.m_settings.m_thriftHTTPSettings.removeThriftSessionTag(this.m_logger);
                }
            }
        }
    }

    @Override
    public void disconnect() throws ErrorException {
        if (null != this.m_heartBeatThread) {
            this.m_heartBeatThread.stop();
        }
        this.closeSession();
        try {
            if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                this.m_client.getInputProtocol().getTransport().close();
            }
        }
        catch (Exception exception) {
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public HiveExecutionContext executeStatement(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        boolean bl = false;
        if (iExecutorUtility instanceof HiveJDBCNativeQueryExecutor) {
            bl = ((HiveJDBCNativeQueryExecutor)iExecutorUtility).getStatement().getAsyncExecution();
        }
        return this.executeStatementInternal(string, iExecutorUtility, bl);
    }

    @Override
    public void executeUpdate(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string, iExecutorUtility);
        this.closeOperation(hiveExecutionContext);
    }

    @Override
    public void fetchNRows(HiveExecutionContext hiveExecutionContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        if (hiveExecutionContext.isCanceled()) {
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
        }
        this.fetchFromServer(hiveExecutionContext, rowsetBuffer, n);
        if (!hiveExecutionContext.m_serverHasMoreRows) {
            this.closeOperation(hiveExecutionContext);
        }
    }

    public void fetchFromServer(HiveExecutionContext hiveExecutionContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        try {
            TFetchResultsReq tFetchResultsReq = hiveExecutionContext.m_fetchResultsReq;
            if (this.m_settings.m_setFetchSizeTakesPrecedence) {
                if (null != hiveExecutionContext.m_statement && 0 == hiveExecutionContext.m_fetchSize) {
                    hiveExecutionContext.m_fetchSize = hiveExecutionContext.m_statement.getProperty(6).getInt();
                }
                if (0 < hiveExecutionContext.m_fetchSize) {
                    n = hiveExecutionContext.m_fetchSize;
                }
            }
            tFetchResultsReq.setStartRowOffset(hiveExecutionContext.m_driverSideStartRowOffset);
            tFetchResultsReq.setMaxRows(n);
            this.checkFetchSize(hiveExecutionContext, n);
            tFetchResultsReq.setMaxBytes(this.m_settings.m_arrowMaxBytesPerFetch);
            HiveServer2BaseBuffer hiveServer2BaseBuffer = (HiveServer2BaseBuffer)rowsetBuffer.m_buffer;
            if (hiveExecutionContext.m_hasDRFetchResp) {
                LogUtilities.logDebug("Using fetch response from direct results shortcut", this.m_logger);
                hiveServer2BaseBuffer.m_hiveServer2Buffer = hiveExecutionContext.m_directResults.getResultSet();
                hiveExecutionContext.m_hasDRFetchResp = false;
            } else {
                if (!hiveExecutionContext.m_serverHasMoreRows) {
                    rowsetBuffer.m_bufferHasMoreRows = false;
                    return;
                }
                try {
                    hiveServer2BaseBuffer.m_hiveServer2Buffer = this.m_client.FetchResults(tFetchResultsReq);
                }
                catch (TException tException) {
                    ErrorException errorException;
                    this.closeOperation(hiveExecutionContext);
                    if (tException instanceof TTransportException) {
                        errorException = this.handleTTransportException((TTransportException)tException, "FetchResults for query \"" + CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings) + "\"");
                    } else {
                        errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), tException.getMessage());
                        errorException.initCause(tException);
                    }
                    throw errorException;
                }
            }
            hiveExecutionContext.m_hasOpenOperation = true;
            this.getRowSetInformation(hiveExecutionContext, rowsetBuffer);
            while (this.correctHasMoreRowsResult() && !rowsetBuffer.m_bufferHasMoreRows && hiveServer2BaseBuffer.getHiveServer2Buffer().isHasMoreRows()) {
                LogUtilities.logDebug("Fetching again as hasMoreRows=true, but no rows returned", this.m_logger);
                hiveServer2BaseBuffer.m_hiveServer2Buffer = this.m_client.FetchResults(tFetchResultsReq);
                this.getRowSetInformation(hiveExecutionContext, rowsetBuffer);
            }
            if (TStatusCode.ERROR_STATUS == hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getStatusCode()) {
                try {
                    String string;
                    if (null != hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getErrorMessage() && ((string = hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getErrorMessage().toUpperCase()).contains("CANCELED") || string.contains("CANCELLED"))) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                    }
                    throw this.buildExceptionFromTStatus(hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus(), HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), new String[]{hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getErrorMessage()});
                }
                catch (Throwable throwable) {
                    this.closeOperation(hiveExecutionContext);
                    throw throwable;
                }
            }
            if (hiveServer2BaseBuffer.m_hiveServer2Buffer.isSetResults()) {
                hiveExecutionContext.m_isServerReturnedResultLinks = hiveServer2BaseBuffer.m_hiveServer2Buffer.getResults().isSetResultLinks();
            }
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "FetchResults");
        }
        catch (OperationCanceledException operationCanceledException) {
            throw operationCanceledException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Row Fetching Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected void getRowSetInformation(HiveExecutionContext hiveExecutionContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException {
        HiveServer2BaseBuffer hiveServer2BaseBuffer = rowsetBuffer.getBuffer();
        if (TStatusCode.SUCCESS_STATUS == hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getStatusCode()) {
            rowsetBuffer.initializeBuffer();
            if (hiveServer2BaseBuffer.getHiveServer2Buffer().getResults().isSetResultLinks()) {
                TSparkArrowResultLink tSparkArrowResultLink;
                int n = 0;
                Iterator<TSparkArrowResultLink> iterator = hiveServer2BaseBuffer.getHiveServer2Buffer().getResults().getResultLinks().iterator();
                while (iterator.hasNext() && (n = (int)((long)n + (tSparkArrowResultLink = iterator.next()).getRowCount())) <= 0) {
                }
                rowsetBuffer.m_bufferHasMoreRows = 0 < n;
            } else {
                rowsetBuffer.m_bufferHasMoreRows = 0 < rowsetBuffer.getNumRows();
            }
            hiveExecutionContext.m_serverHasMoreRows = this.correctHasMoreRowsResult() ? hiveServer2BaseBuffer.getHiveServer2Buffer().isHasMoreRows() : rowsetBuffer.m_bufferHasMoreRows;
        }
    }

    @Override
    public void fetchRows(HiveExecutionContext hiveExecutionContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException, OperationCanceledException {
        this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
    }

    @Override
    public int getBinaryColumnSize() {
        return this.m_settings.m_binaryColumnSize;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ArrayList<String> getCatalogs() throws ErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_getColumnsWithQuery) {
            return this.getColumnsWithDescribeQuery(string, string2, string3);
        }
        HashMap<MetadataSourceColumnTag, String> hashMap = new HashMap<MetadataSourceColumnTag, String>();
        hashMap.put(MetadataSourceColumnTag.CATALOG_NAME, string);
        hashMap.put(MetadataSourceColumnTag.SCHEMA_NAME, string2);
        hashMap.put(MetadataSourceColumnTag.TABLE_NAME, string3);
        try {
            return this.getColumns(hashMap, null);
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_getColumnsWithQuery) {
            return null;
        }
        String[] stringArray = this.parseFilters(map, arrayList);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        HS2Client hS2Client = this;
        synchronized (hS2Client) {
            Object object;
            block32: {
                HiveExecutionContext hiveExecutionContext;
                block31: {
                    TOperationHandle tOperationHandle = null;
                    hiveExecutionContext = null;
                    try {
                        ArrayList<HiveCommonColumnMetadata> arrayList2 = new ArrayList<HiveCommonColumnMetadata>();
                        String string5 = this.getCurrentCatalog();
                        TGetColumnsReq tGetColumnsReq = new TGetColumnsReq();
                        if (!this.isMultiCatalogEnabled()) {
                            tGetColumnsReq.setCatalogName(string5);
                            tGetColumnsReq.setCatalogNameIsSet(true);
                        } else if (null != string) {
                            tGetColumnsReq.setCatalogName(string);
                            tGetColumnsReq.setCatalogNameIsSet(true);
                        }
                        if (null != string2) {
                            tGetColumnsReq.setSchemaName(string2);
                            tGetColumnsReq.setSchemaNameIsSet(true);
                        }
                        if (null != string3) {
                            tGetColumnsReq.setTableName(string3);
                            tGetColumnsReq.setTableNameIsSet(true);
                        }
                        if (null != string4) {
                            tGetColumnsReq.setColumnName(string4);
                            tGetColumnsReq.setColumnNameIsSet(true);
                        } else if (this.m_settings.m_isSparkLivyServer) {
                            tGetColumnsReq.setColumnName("%");
                            tGetColumnsReq.setColumnNameIsSet(true);
                        }
                        tGetColumnsReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                        tGetColumnsReq.setSessionHandleIsSet(true);
                        if (this.m_enableDirectResults) {
                            tGetColumnsReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                        }
                        TGetColumnsResp tGetColumnsResp = this.m_client.GetColumns(tGetColumnsReq);
                        tOperationHandle = tGetColumnsResp.getOperationHandle();
                        String string6 = "GetColumns";
                        this.checkIfRespNull(tGetColumnsResp, string6);
                        this.checkResponseStatus(tGetColumnsResp.getStatus(), string6);
                        if (null == tOperationHandle) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GETCOLUMNS_API_CALL_ERR.name(), new String[]{"Unknown", "Unknown"});
                            throw errorException;
                        }
                        List<Object> list = new ArrayList();
                        List<Object> list2 = new ArrayList();
                        List<Object> list3 = new ArrayList();
                        String string7 = this.isMultiCatalogEnabled() ? "" : string5;
                        String string8 = "";
                        String string9 = "";
                        int n = 0;
                        int n2 = 0;
                        ArrayList<String> arrayList3 = null;
                        String string10 = "";
                        TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                        tFetchResultsReq.setOperationHandle(tOperationHandle);
                        hiveExecutionContext = this.createExecutionContext();
                        hiveExecutionContext.m_fetchResultsReq = tFetchResultsReq;
                        hiveExecutionContext.m_hasOpenOperation = true;
                        if (tGetColumnsResp.isSetDirectResults()) {
                            hiveExecutionContext.handleDirectResultsResp(this.m_logger, tGetColumnsResp.getDirectResults());
                        }
                        RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
                        do {
                            object = rowsetBuffer.getBuffer();
                            this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                            n2 = ((HiveServer2BaseBuffer)object).getNumRowsInBuffer();
                            list = ((HiveServer2BaseBuffer)object).getStringColumn(3);
                            list2 = ((HiveServer2BaseBuffer)object).getStringColumn(5);
                            list3 = ((HiveServer2BaseBuffer)object).getStringColumn(11);
                            List<String> list4 = ((HiveServer2BaseBuffer)object).getStringColumn(0);
                            List<String> list5 = ((HiveServer2BaseBuffer)object).getStringColumn(1);
                            List<String> list6 = ((HiveServer2BaseBuffer)object).getStringColumn(2);
                            List<Integer> list7 = new ArrayList<Integer>(Collections.nCopies(list.size(), Nullable.NULLABLE.getIntValue()));
                            if (null != this.m_settings.m_isServerReturnsCorrectNullability && this.m_settings.m_isServerReturnsCorrectNullability.booleanValue()) {
                                list7 = ((HiveServer2BaseBuffer)object).getIntColumn(10);
                            }
                            for (int i = 0; i < n2; ++i, ++n) {
                                String string11 = string = this.isMultiCatalogEnabled() ? list4.get(i) : string7;
                                if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.mismatchedCatalogOrTempCatalog(string5, string)) continue;
                                string2 = list5.get(i);
                                string3 = list6.get(i);
                                if (!(string7.equals(string) && string8.equals(string2) && string9.equals(string3))) {
                                    string7 = string;
                                    string8 = string2;
                                    string9 = string3;
                                    n = 0;
                                    arrayList3 = null;
                                }
                                if ((((String)list2.get(i)).contains("DECIMAL") || ((String)list2.get(i)).contains("VARCHAR") || ((String)list2.get(i)).contains("CHAR")) && !this.m_settings.m_platformVersionUtils.supportsQualifiedTypeNames(this.m_settings.m_serverVersion)) {
                                    if (null == arrayList3) {
                                        arrayList3 = this.getQualifiedTypeNames(string2, string3);
                                    }
                                    string10 = arrayList3.size() > 0 ? arrayList3.get(n) : (String)list2.get(i);
                                } else {
                                    string10 = (String)list2.get(i);
                                }
                                if (this.m_settings.m_isSparkLivyServer) {
                                    string10 = DataTypeUtilities.mapLivyTypeNameToHiveTypeName(string10.toUpperCase(), this.m_settings);
                                }
                                if (string10.toUpperCase().contains("ARRAY<") || string10.toUpperCase().contains("STRUCT<") || string10.toUpperCase().contains("MAP<") || string10.toUpperCase().contains("UNIONTYPE<")) {
                                    string10 = string10.toUpperCase();
                                }
                                try {
                                    arrayList2.add(DataTypeUtilities.createColumn(string, string2, string3, (String)list.get(i), (String)list3.get(i), DataTypeUtilities.mapHiveTypeNameToSqltype(string10, 2, this.m_settings), string10, 2, list7.get(i), this.m_settings));
                                    continue;
                                }
                                catch (Exception exception) {
                                    this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CREATE_COLUMN_METADATA_ERR.name(), new String[]{string2, string3, (String)list.get(i), string10}));
                                }
                            }
                        } while (hiveExecutionContext.m_serverHasMoreRows);
                        object = arrayList2;
                        if (null != hiveExecutionContext) break block31;
                    }
                    catch (TTransportException tTransportException) {
                        try {
                            throw this.handleTTransportException(tTransportException, "GetColumns");
                            catch (Exception exception) {
                                throw exception;
                            }
                        }
                        catch (Throwable throwable) {
                            if (null == hiveExecutionContext) {
                                this.safeCloseOperation(tOperationHandle);
                                throw throwable;
                            }
                            this.closeOperation(hiveExecutionContext);
                            throw throwable;
                        }
                    }
                    this.safeCloseOperation(tOperationHandle);
                    break block32;
                }
                this.closeOperation(hiveExecutionContext);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentCatalog() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_Schema;
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, HiveExecutionContext hiveExecutionContext, CurrentBufferContext currentBufferContext) throws ErrorException {
        Object ApiBufferT = currentBufferContext.m_currentBuffer.m_buffer;
        short s = currentBufferContext.m_columnTypes[n];
        return ApiBufferT.getData(n, l, l2, dataWrapper, currentBufferContext.m_currentRowInBuffer, s, CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings), this.m_settings);
    }

    public String getDelegationToken(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TGetDelegationTokenReq tGetDelegationTokenReq = new TGetDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string, string2);
        try {
            TGetDelegationTokenResp tGetDelegationTokenResp = this.m_client.GetDelegationToken(tGetDelegationTokenReq);
            this.checkResponseStatus(tGetDelegationTokenResp.getStatus(), HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{tGetDelegationTokenResp.getStatus().toString(), string, string2});
            return tGetDelegationTokenResp.getDelegationToken();
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string, string2});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public DatabaseMetadataInfo getDatabaseMetadataInfo() {
        return this.dbmdInfo;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ArrayList<HiveCommonFunctionsMetadataSourceRow> getFunctions(Map<MetadataSourceColumnTag, String> var1_1, ArrayList<String> var2_2) throws ErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public ArrayList<ColumnMetadata> getResultSetMetadata(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        try {
            TGetResultSetMetadataResp tGetResultSetMetadataResp = this.getResultSetMetadataInternal(hiveExecutionContext);
            if (null == tGetResultSetMetadataResp.getSchema()) {
                return new ArrayList<ColumnMetadata>();
            }
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(tGetResultSetMetadataResp.getSchema().getColumns().size());
            for (TColumnDesc tColumnDesc : tGetResultSetMetadataResp.getSchema().getColumns()) {
                TTypeEntry tTypeEntry = tColumnDesc.getTypeDesc().getTypes().get(0);
                if (this.m_settings.m_platformVersionUtils.hasIssueWithNullTypeMetadata(this.m_settings.m_serverVersion) && tTypeEntry.isSetPrimitiveEntry() && tTypeEntry.getPrimitiveEntry().getType().equals(TTypeId.USER_DEFINED_TYPE)) {
                    tTypeEntry.getPrimitiveEntry().setType(TTypeId.BOOLEAN_TYPE);
                }
                String string = this.fullColumnTypeNameBuilder(tTypeEntry);
                arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), null, null, tColumnDesc.getColumnName(), null, DataTypeUtilities.mapHiveTypeToSqlType(tTypeEntry.getPrimitiveEntry().getType()), string, 2, Nullable.NULLABLE.getIntValue(), this.m_settings));
            }
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            String string = "Metadata Result Set Error";
            if (!exception.getMessage().isEmpty()) {
                string = string + ": " + exception.getMessage();
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), string);
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected HiveExecutionContext createExecutionContext() {
        return new HiveExecutionContext(this.m_settings);
    }

    protected TGetResultSetMetadataResp getResultSetMetadataInternal(HiveExecutionContext hiveExecutionContext) throws TException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, hiveExecutionContext);
        try {
            Object object;
            TGetResultSetMetadataResp tGetResultSetMetadataResp;
            if (hiveExecutionContext.m_hasDRGetRsmdResp) {
                LogUtilities.logDebug("Using result set metadata from direct results response", this.m_logger);
                tGetResultSetMetadataResp = hiveExecutionContext.m_directResults.getResultSetMetadata();
            } else {
                object = new TGetResultSetMetadataReq();
                ((TGetResultSetMetadataReq)object).setOperationHandle(hiveExecutionContext.m_executeResponse.getOperationHandle());
                tGetResultSetMetadataResp = this.m_client.GetResultSetMetadata((TGetResultSetMetadataReq)object);
            }
            if (TStatusCode.ERROR_STATUS == tGetResultSetMetadataResp.getStatus().getStatusCode()) {
                try {
                    if (null != tGetResultSetMetadataResp.getStatus().getErrorMessage() && (((String)(object = tGetResultSetMetadataResp.getStatus().getErrorMessage().toUpperCase())).contains("CANCELED") || ((String)object).contains("CANCELLED"))) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                    }
                    throw this.buildExceptionFromTStatus(tGetResultSetMetadataResp.getStatus(), HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), new String[]{tGetResultSetMetadataResp.getStatus().getErrorMessage()});
                }
                catch (Throwable throwable) {
                    this.closeOperation(hiveExecutionContext);
                    throw throwable;
                }
            }
            if (TSparkRowSetType.ARROW_BASED_SET == tGetResultSetMetadataResp.getResultFormat() || TSparkRowSetType.URL_BASED_SET == tGetResultSetMetadataResp.getResultFormat()) {
                hiveExecutionContext.m_rsMdColumns = tGetResultSetMetadataResp.getSchema().getColumns();
                hiveExecutionContext.m_hasArrowResults = true;
            }
            hiveExecutionContext.m_isLz4Compressed = tGetResultSetMetadataResp.isLz4Compressed();
            return tGetResultSetMetadataResp;
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "GetResultSetMetadata for query \"" + CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings) + "\"");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonSchemasMetadataSourceRow> getSchemas(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = this.parseFilters(map, arrayList)[0];
        String string2 = this.getCurrentCatalog();
        ArrayList<HiveCommonSchemasMetadataSourceRow> arrayList2 = new ArrayList<HiveCommonSchemasMetadataSourceRow>();
        if (this.m_settings.m_getSchemasWithQuery || this.m_settings.m_connDBType.equalsIgnoreCase(IMPALA_SERVER_NAME)) {
            try {
                if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.isNonCurrentCatalog(string2, string)) {
                    return arrayList2;
                }
                ArrayList<String> arrayList3 = this.runCatalogFunction(SHOW_DATABASES_STRING, 0);
                Iterator<String> iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    arrayList2.add(new HiveCommonSchemasMetadataSourceRow(string2, string3));
                }
                return arrayList2;
            }
            catch (Exception exception) {
                if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                    throw (ErrorException)exception;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
        TOperationHandle tOperationHandle = null;
        HiveExecutionContext hiveExecutionContext = null;
        HS2Client hS2Client = this;
        synchronized (hS2Client) {
            ArrayList<HiveCommonSchemasMetadataSourceRow> arrayList4;
            block24: {
                block23: {
                    try {
                        TGetSchemasReq tGetSchemasReq = new TGetSchemasReq();
                        boolean bl = this.isMultiCatalogEnabled();
                        if (!bl) {
                            tGetSchemasReq.setCatalogName(string2);
                            tGetSchemasReq.setCatalogNameIsSet(true);
                        } else if (null != string) {
                            tGetSchemasReq.setCatalogName(string);
                            tGetSchemasReq.setCatalogNameIsSet(true);
                        }
                        tGetSchemasReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                        tGetSchemasReq.setSessionHandleIsSet(true);
                        if (this.m_enableDirectResults) {
                            tGetSchemasReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                        }
                        TGetSchemasResp tGetSchemasResp = this.m_client.GetSchemas(tGetSchemasReq);
                        tOperationHandle = tGetSchemasResp.getOperationHandle();
                        String string4 = "GetSchemas";
                        this.checkIfRespNull(tGetSchemasResp, string4);
                        this.checkResponseStatus(tGetSchemasResp.getStatus(), string4);
                        if (null == tOperationHandle) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getSchemas", "Unknown", "Unknown"});
                            throw errorException;
                        }
                        TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                        tFetchResultsReq.setOperationHandle(tOperationHandle);
                        hiveExecutionContext = this.createExecutionContext();
                        hiveExecutionContext.m_fetchResultsReq = tFetchResultsReq;
                        hiveExecutionContext.m_hasOpenOperation = true;
                        if (tGetSchemasResp.isSetDirectResults()) {
                            hiveExecutionContext.handleDirectResultsResp(this.m_logger, tGetSchemasResp.getDirectResults());
                        }
                        RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
                        do {
                            this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                            List<String> list = rowsetBuffer.getBuffer().getStringColumn(0);
                            List<String> list2 = rowsetBuffer.getBuffer().getStringColumn(1);
                            for (int i = 0; rowsetBuffer.getBuffer().getNumRowsInBuffer() > i; ++i) {
                                if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.mismatchedCatalogOrTempCatalog(string2, list2.get(i))) continue;
                                arrayList2.add(new HiveCommonSchemasMetadataSourceRow(bl ? list2.get(i) : string2, list.get(i)));
                            }
                        } while (hiveExecutionContext.m_serverHasMoreRows);
                        arrayList4 = arrayList2;
                        if (null != hiveExecutionContext) break block23;
                    }
                    catch (TTransportException tTransportException) {
                        try {
                            throw this.handleTTransportException(tTransportException, "GetSchemas");
                            catch (Exception exception) {
                                if (exception instanceof ErrorException) {
                                    ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                                }
                                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                                errorException.initCause(exception);
                                throw errorException;
                            }
                        }
                        catch (Throwable throwable) {
                            if (null == hiveExecutionContext) {
                                this.safeCloseOperation(tOperationHandle);
                                throw throwable;
                            }
                            this.closeOperation(hiveExecutionContext);
                            throw throwable;
                        }
                    }
                    this.safeCloseOperation(tOperationHandle);
                    break block24;
                }
                this.closeOperation(hiveExecutionContext);
            }
            return arrayList4;
        }
    }

    @Override
    public short getStringColumnSize() {
        return this.m_settings.m_stringColumnSize;
    }

    @Override
    public HiveJDBCPlaceholderTable getTable(String string, String string2, String string3) throws ErrorException {
        ArrayList<HiveCommonColumnMetadata> arrayList;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.isMultiCatalogEnabled() && this.isNonPlatformCatalog(string)) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.getCurrentSchema();
        }
        if (null == (arrayList = this.getColumns(string, string2, string3)) || arrayList.isEmpty()) {
            return null;
        }
        return new HiveJDBCPlaceholderTable(arrayList);
    }

    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList = new ArrayList<HiveCommonTablesMetadataSourceRow>();
        if (null == string) {
            string = this.getCurrentCatalog();
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.getCurrentSchema();
        }
        try {
            String string3 = "SHOW TABLES in " + string2;
            for (String string4 : this.runCatalogFunction(string3, this.m_settings.m_tableNameColIndex)) {
                arrayList.add(new HiveCommonTablesMetadataSourceRow(string, string2, string4, TBL_TYPE_TABLE, null));
            }
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws ErrorException {
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList2;
        HiveExecutionContext hiveExecutionContext;
        TOperationHandle tOperationHandle;
        block18: {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            if (this.m_settings.m_getTablesWithQuery) {
                return null;
            }
            String string = this.getCurrentCatalog();
            String[] stringArray = this.parseFilters(map, arrayList);
            String string2 = this.isSwitchRestrict() ? stringArray[1] : stringArray[0];
            String string3 = this.isSwitchRestrict() ? stringArray[0] : stringArray[1];
            String string4 = stringArray[2];
            ArrayList<HiveCommonTablesMetadataSourceRow> arrayList3 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
            tOperationHandle = null;
            hiveExecutionContext = null;
            try {
                TGetTablesReq tGetTablesReq = new TGetTablesReq();
                tGetTablesReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                boolean bl = this.isMultiCatalogEnabled();
                if (bl && null != string2) {
                    tGetTablesReq.setCatalogName(string2);
                    tGetTablesReq.setCatalogNameIsSet(true);
                }
                if (null != string3) {
                    tGetTablesReq.setSchemaName(string3);
                    tGetTablesReq.setSchemaNameIsSet(true);
                }
                if (null != string4) {
                    tGetTablesReq.setTableName(string4);
                    tGetTablesReq.setTableNameIsSet(true);
                }
                if (this.m_enableDirectResults) {
                    tGetTablesReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                }
                TGetTablesResp tGetTablesResp = this.m_client.GetTables(tGetTablesReq);
                tOperationHandle = tGetTablesResp.getOperationHandle();
                TGetResultSetMetadataReq tGetResultSetMetadataReq = new TGetResultSetMetadataReq();
                tGetResultSetMetadataReq.setOperationHandle(tGetTablesResp.getOperationHandle());
                String string5 = "GetTables";
                this.checkIfRespNull(tGetTablesResp, string5);
                this.checkResponseStatus(tGetTablesResp.getStatus(), string5);
                if (null == tOperationHandle) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getTables", "Unknown", "Unknown"});
                    throw errorException;
                }
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                hiveExecutionContext = this.createExecutionContext();
                hiveExecutionContext.m_fetchResultsReq = tFetchResultsReq;
                hiveExecutionContext.m_hasOpenOperation = true;
                if (tGetTablesResp.isSetDirectResults()) {
                    hiveExecutionContext.handleDirectResultsResp(this.m_logger, tGetTablesResp.getDirectResults());
                }
                RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
                do {
                    this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                    List<String> list = rowsetBuffer.getBuffer().getStringColumn(0);
                    List<String> list2 = rowsetBuffer.getBuffer().getStringColumn(2);
                    List<String> list3 = rowsetBuffer.getBuffer().getStringColumn(3);
                    List<String> list4 = rowsetBuffer.getBuffer().getStringColumn(4);
                    List<String> list5 = rowsetBuffer.getBuffer().getStringColumn(1);
                    for (int i = 0; rowsetBuffer.getBuffer().getNumRowsInBuffer() > i; ++i) {
                        String string6 = list.get(i);
                        if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.mismatchedCatalogOrTempCatalog(string, string6)) continue;
                        String string7 = list3.get(i);
                        if (string7.isEmpty() && this.m_settings.m_mapEmptyTableTypeToTable) {
                            string7 = TBL_TYPE_TABLE;
                        }
                        boolean bl2 = this.m_settings.m_platformVersionUtils.supportsGetTablesAPIComments(this.m_settings.m_serverVersion);
                        arrayList3.add(new HiveCommonTablesMetadataSourceRow(bl ? string6 : string, list5.get(i), list2.get(i), string7, bl2 ? list4.get(i) : null));
                    }
                } while (hiveExecutionContext.m_serverHasMoreRows);
                arrayList2 = arrayList3;
                if (null != hiveExecutionContext) break block18;
            }
            catch (TTransportException tTransportException) {
                throw this.handleTTransportException(tTransportException, "GetTables");
                catch (Exception exception) {
                    CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                    HiveJDBCExceptionUtils.logException(exception, this.m_logger);
                    ArrayList<HiveCommonTablesMetadataSourceRow> arrayList4 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
                    return arrayList4;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return arrayList2;
        }
        this.closeOperation(hiveExecutionContext);
        return arrayList2;
        finally {
            if (null == hiveExecutionContext) {
                this.safeCloseOperation(tOperationHandle);
            } else {
                this.closeOperation(hiveExecutionContext);
            }
        }
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isArrowEnabled() {
        return this.m_enableArrow;
    }

    @Override
    public boolean isMultiCatalogEnabled() {
        return this.m_settings.m_enableMultiCatalog;
    }

    @Override
    public boolean isSwitchRestrict() {
        return this.m_settings.m_switchCataANDSchema;
    }

    @Override
    public boolean isSessionValid() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.getServerVersion();
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            return false;
        }
        return true;
    }

    @Override
    public RowsetBuffer<HiveServer2BaseBuffer> makeRowsetBuffer(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, hiveExecutionContext);
        if (hiveExecutionContext.m_hasArrowResults) {
            return new RowsetBuffer<HiveServer2BaseBuffer>(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).createArrowBuffer(this.m_logger, hiveExecutionContext.m_rsMdColumns, hiveExecutionContext.m_isLz4Compressed, this.m_settings));
        }
        if (this.isAtLeastV6ProtocolSession()) {
            return new RowsetBuffer<HiveServer2BaseBuffer>(new HS2v6Buffer(this.m_logger, this.m_settings));
        }
        return new RowsetBuffer<HiveServer2BaseBuffer>(new HS2Buffer(this.m_logger, this.m_settings));
    }

    public HiveExecutionContext pollForOperationCompletion(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        if (hiveExecutionContext.isCanceled()) {
            this.cancelOperation(hiveExecutionContext);
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
        }
        try {
            TGetOperationStatusResp tGetOperationStatusResp;
            TExecuteStatementResp tExecuteStatementResp = hiveExecutionContext.m_executeResponse;
            TGetOperationStatusReq tGetOperationStatusReq = new TGetOperationStatusReq();
            if (null == hiveExecutionContext.m_executeResponse.getOperationHandle()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_NULL_OPERATION_HANDLE.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                throw errorException;
            }
            tGetOperationStatusReq.setOperationHandle(tExecuteStatementResp.getOperationHandle());
            tGetOperationStatusReq.setOperationHandleIsSet(true);
            if (hiveExecutionContext.m_hasDROperationStatusResp) {
                tGetOperationStatusResp = hiveExecutionContext.m_directResults.getOperationStatus();
                LogUtilities.logDebug("DirectResults operationStatus: " + (TOperationState.FINISHED_STATE == tGetOperationStatusResp.getOperationState() ? "Finished" : "Not finished"), this.m_logger);
            } else {
                tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                this.checkNumModifiedRows(tGetOperationStatusResp, hiveExecutionContext);
            }
            block12: while (!hiveExecutionContext.isCanceled() && !hiveExecutionContext.m_isExecutionComplete) {
                this.checkResponseStatus(tGetOperationStatusResp.getStatus(), HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{Integer.toString(tGetOperationStatusResp.getStatus().getErrorCode()), tGetOperationStatusResp.getStatus().toString(), CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                if (TStatusCode.SUCCESS_STATUS == tGetOperationStatusResp.getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    switch (tGetOperationStatusResp.getOperationState()) {
                        case CLOSED_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CLOSED_SERVER.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                            throw errorException;
                        }
                        case CANCELED_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL_SERVER.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                            throw errorException;
                        }
                        case ERROR_STATE: {
                            throw this.buildExceptionFromTStatusSqlState(tGetOperationStatusResp.getSqlState(), HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{String.valueOf(tGetOperationStatusResp.getErrorCode()), tGetOperationStatusResp.isSetErrorMessage() ? tGetOperationStatusResp.getErrorMessage() : "No error message available from the server", CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                        }
                        case UKNOWN_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_INVALID_STATE.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                            throw errorException;
                        }
                        case PENDING_STATE: 
                        case RUNNING_STATE: 
                        case INITIALIZED_STATE: {
                            this.timeoutCheck(hiveExecutionContext);
                            Thread.sleep(this.m_settings.m_asyncExecPollInterval);
                            tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                            this.checkNumModifiedRows(tGetOperationStatusResp, hiveExecutionContext);
                            continue block12;
                        }
                        case FINISHED_STATE: {
                            hiveExecutionContext.m_isExecutionComplete = true;
                            continue block12;
                        }
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_INVALID_STATE.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                    throw errorException;
                }
                if (TStatusCode.INVALID_HANDLE_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_INVALID_OPERATION_HANDLE.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                    throw errorException;
                }
                if (TStatusCode.STILL_EXECUTING_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    this.timeoutCheck(hiveExecutionContext);
                    Thread.sleep(this.m_settings.m_asyncExecPollInterval);
                    tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                    continue;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_UNRECOGNIZED_STATUS_CODE.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)});
                throw errorException;
            }
            if (hiveExecutionContext.isCanceled()) {
                this.cancelOperation(hiveExecutionContext);
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
            }
            if (!hiveExecutionContext.m_isManualCanceled.get() && hiveExecutionContext.m_isExecutionComplete) {
                hiveExecutionContext.m_fetchResultsReq = new TFetchResultsReq();
                hiveExecutionContext.m_fetchResultsReq.setOrientation(TFetchOrientation.FETCH_NEXT);
                hiveExecutionContext.m_fetchResultsReq.setOperationHandle(tExecuteStatementResp.getOperationHandle());
                hiveExecutionContext.m_hasOpenOperation = true;
            }
            this.checkNumModifiedRows(tGetOperationStatusResp, hiveExecutionContext);
            if (this.m_settings.m_isEnableHeartBeat && hiveExecutionContext.m_hasOpenOperation && !hiveExecutionContext.m_hasRowcountResult && (null == hiveExecutionContext.m_directResults || !hiveExecutionContext.m_directResults.isSetCloseOperation())) {
                this.getHeartBeatThread().addOperationHandle(hiveExecutionContext.m_fetchResultsReq.getOperationHandle());
                hiveExecutionContext.m_heartbeatRegistered = true;
            }
            return hiveExecutionContext;
        }
        catch (TTransportException tTransportException) {
            ErrorException errorException = null != tTransportException.getCause() && tTransportException.getCause() instanceof SocketTimeoutException ? (0L != hiveExecutionContext.m_timeoutVal ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)}, (Throwable)tTransportException, ExceptionType.TIME_OUT) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STMT_EXEC_SOCKETTIMEOUT_ERR.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)}, (Throwable)tTransportException)) : this.handleTTransportException(tTransportException, "GetOperationStatus for query \"" + CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings) + "\"");
            throw errorException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{exception.getMessage(), "HY000", CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)}, (Throwable)exception);
            throw errorException;
        }
    }

    public void renewDelegationToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TRenewDelegationTokenReq tRenewDelegationTokenReq = new TRenewDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string);
        try {
            TRenewDelegationTokenResp tRenewDelegationTokenResp = this.m_client.RenewDelegationToken(tRenewDelegationTokenReq);
            this.checkResponseStatus(tRenewDelegationTokenResp.getStatus(), HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{tRenewDelegationTokenResp.getStatus().toString(), string});
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    public boolean sendHeartBeat(TOperationHandle tOperationHandle) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TGetOperationStatusReq tGetOperationStatusReq = new TGetOperationStatusReq();
            TGetOperationStatusResp tGetOperationStatusResp = new TGetOperationStatusResp();
            tGetOperationStatusReq.setOperationHandle(tOperationHandle);
            tGetOperationStatusReq.setOperationHandleIsSet(true);
            tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
            if (TStatusCode.SUCCESS_STATUS == tGetOperationStatusResp.getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                if (TOperationState.FINISHED_STATE == tGetOperationStatusResp.getOperationState()) {
                    return true;
                }
                LogUtilities.logWarning("Got wrong status " + tGetOperationStatusResp.getStatus().getStatusCode() + " while sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The error message is: " + tGetOperationStatusResp.getStatus().getErrorMessage(), this.m_logger);
            } else {
                LogUtilities.logWarning("Got wrong status " + tGetOperationStatusResp.getStatus().getStatusCode() + " while sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The error message is: " + tGetOperationStatusResp.getStatus().getErrorMessage(), this.m_logger);
            }
        }
        catch (TTransportException tTransportException) {
            LogUtilities.logWarning("Got a TTransportExceptionwhile sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The exception is: " + tTransportException.getMessage(), this.m_logger);
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Got an Exceptionwhile sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The exception is: " + exception.getMessage(), this.m_logger);
        }
        return false;
    }

    @Override
    public void setCurrentCatalog(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.isMultiCatalogEnabled() && this.m_settings.m_executeSetQueryOnSetCatalogCall) {
            this.runSetCatalog(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSchema(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_executeSetQueryOnSetSchemaCall) {
            this.runSetSchema(string);
        } else {
            HiveJDBCSettings hiveJDBCSettings = this.m_settings;
            synchronized (hiveJDBCSettings) {
                this.m_settings.m_Schema = string;
            }
        }
    }

    @Override
    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    protected void checkIfRespNull(TBase tBase, String string) throws ErrorException {
        if (null == tBase) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, "Unknown", "Unknown"});
            throw errorException;
        }
    }

    protected void checkOpenSessionStatus() throws ErrorException {
        try {
            String string = "OpenSession";
            this.checkIfRespNull(this.m_openSessionResp, string);
            this.checkResponseStatus(this.m_openSessionResp.getStatus(), string);
        }
        catch (ErrorException errorException) {
            this.m_hasOpenSession = false;
            throw errorException;
        }
    }

    @Override
    protected TProtocol getProtocol() {
        return this.m_client.getOutputProtocol();
    }

    protected String getServerVersion() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TGetInfoReq tGetInfoReq = new TGetInfoReq();
            tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_VER);
            tGetInfoReq.setInfoTypeIsSet(true);
            tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tGetInfoReq.setSessionHandleIsSet(true);
            TGetInfoResp tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
            String string = "GetInfo - Server Version";
            this.checkIfRespNull(tGetInfoResp, string);
            this.checkResponseStatus(tGetInfoResp.getStatus(), string);
            return tGetInfoResp.getInfoValue().getStringValue();
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = null != exception.getMessage() ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_ERROR.name(), exception.getMessage()) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_ERROR.name(), "no details available");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected String getServerVersionViaVersionQuery() throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            ArrayList<String> arrayList = this.runCatalogFunction("select version()", 0);
            if (arrayList.size() > 0) {
                return arrayList.get(0);
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SERVER_VERSION_NO_RESULT_ERROR.name());
            throw errorException;
        }
        catch (ErrorException errorException) {
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            throw errorException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    protected void checkResponseStatus(TStatus tStatus, String string) throws ErrorException {
        String string2 = null == tStatus ? "Unknown" : Integer.toString(tStatus.getErrorCode());
        String string3 = null == tStatus ? "Unknown" : tStatus.toString();
        this.checkResponseStatus(tStatus, HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, string2, string3});
    }

    protected void checkResponseStatus(TStatus tStatus, String string, String[] stringArray) throws ErrorException {
        if (null == tStatus) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string, stringArray);
            throw errorException;
        }
        if (TStatusCode.SUCCESS_STATUS != tStatus.getStatusCode() && TStatusCode.SUCCESS_WITH_INFO_STATUS != tStatus.getStatusCode()) {
            throw this.buildExceptionFromTStatus(tStatus, string, stringArray);
        }
    }

    protected boolean correctHasMoreRowsResult() {
        if (null != this.m_settings.m_isServerReturnsCorrectHasMoreRows) {
            return this.m_settings.m_isServerReturnsCorrectHasMoreRows;
        }
        return TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue() || this.m_settings.m_connDBType.equalsIgnoreCase(IMPALA_SERVER_NAME);
    }

    protected boolean isAtLeastV6ProtocolSession() {
        if (this.m_hasOpenSession && null != this.m_openSessionResp) {
            TProtocolVersion tProtocolVersion = this.m_openSessionResp.getServerProtocolVersion();
            return tProtocolVersion.getValue() >= TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue();
        }
        return false;
    }

    protected boolean supportsNamespaceInConfiguration() {
        if (this.m_hasOpenSession && null != this.m_openSessionResp) {
            TProtocolVersion tProtocolVersion = this.m_openSessionResp.getServerProtocolVersion();
            return tProtocolVersion.getValue() >= TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V4.getValue();
        }
        return false;
    }

    protected void openSession() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TOpenSessionReq tOpenSessionReq = this.createOpenSessionReq();
            boolean bl = this.m_settings.m_platformVersionUtils.supportsUnsetClientProtocol();
            if (!this.m_settings.m_platformVersionUtils.isServerVersionSet(this.m_settings.m_serverVersion)) {
                block34: {
                    try {
                        this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                        this.checkOpenSessionStatus();
                        this.m_hasOpenSession = true;
                        this.m_settings.m_isConnAlive = true;
                    }
                    catch (TProtocolException tProtocolException) {
                        if (this.m_settings.m_platformVersionUtils.supportsUnsetClientProtocol() && tProtocolException.getMessage().toUpperCase().contains(CLIENT_PROTOCOL_ERR_KEYWORD)) {
                            LogUtilities.logInfo("Error received when leaving the client protocol unset, trying OpenSession again with highest supported protocol: " + this.m_settings.m_platformVersionUtils.getHighestClientProtocol().toString(), this.m_logger);
                            tOpenSessionReq.setClient_protocol(this.m_settings.m_platformVersionUtils.getHighestClientProtocol());
                            try {
                                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                                this.checkOpenSessionStatus();
                                this.m_hasOpenSession = true;
                            }
                            catch (TApplicationException tApplicationException) {
                                if (tApplicationException.getMessage().toUpperCase().contains(CLIENT_PROTOCOL_ERR_KEYWORD)) {
                                    tOpenSessionReq = this.createOpenSessionReq();
                                    tOpenSessionReq.setClient_protocol(DEFAULT_HIVE_CLI_SERVICE_PROTOCOL);
                                    bl = false;
                                    this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                                    this.checkOpenSessionStatus();
                                    this.m_hasOpenSession = true;
                                }
                                break block34;
                            }
                        }
                        throw tProtocolException;
                    }
                }
                if (bl && this.m_settings.m_platformVersionUtils.isSupportedProtocol(this.m_openSessionResp.getServerProtocolVersion())) {
                    this.m_settings.m_protocolVersion = this.m_openSessionResp.getServerProtocolVersion();
                }
                this.m_settings.m_strServerVersion = this.m_openSessionResp.isSetGetInfos() && 2 == this.m_openSessionResp.getGetInfos().size() ? this.m_openSessionResp.getGetInfos().get(1).getStringValue() : this.getServerVersion();
                if (this.m_settings.m_connDBType == IMPALA_SERVER_NAME) {
                    this.regroupImpalaServerVersion();
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                } else {
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                    this.setSparkServerVersion();
                }
                if (DEFAULT_HIVE_CLI_SERVICE_PROTOCOL == this.m_settings.m_protocolVersion && (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion) || this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion) || this.m_settings.m_platformVersionUtils.supportsV8Protocol(this.m_settings.m_serverVersion))) {
                    this.safeCloseSession();
                    this.m_hasOpenSession = false;
                }
            }
            if (!this.m_settings.m_platformVersionUtils.supportPushdownCatalogFilter(this.m_settings.m_serverVersion)) {
                this.m_settings.m_pushdownCatalogFunctionFilters = false;
            }
            if (DEFAULT_HIVE_CLI_SERVICE_PROTOCOL == this.m_settings.m_protocolVersion) {
                if (this.m_settings.m_platformVersionUtils.supportsV8Protocol(this.m_settings.m_serverVersion)) {
                    tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8);
                } else if (this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion)) {
                    tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
                } else if (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion)) {
                    tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
                }
            }
            if (!this.m_hasOpenSession) {
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
                this.m_settings.m_isConnAlive = true;
            }
            if (this.m_settings.m_dbmsName.isEmpty() || this.m_settings.m_isSparkLivyServer) {
                this.m_settings.m_dbmsName = this.m_openSessionResp.isSetGetInfos() && 1 <= this.m_openSessionResp.getGetInfos().size() ? this.m_openSessionResp.getGetInfos().get(0).getStringValue() : this.getDbmsProdName();
            }
            this.setProtocolSpecificSettings();
            this.setMultiCatalogSettings();
            this.setLivySettings();
            boolean bl2 = false;
            if (this.supportsNamespaceInConfiguration()) {
                if (!this.m_openSessionResp.isSetInitialNamespace()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INITIAL_NAMESPACE_NOT_SET.name());
                    throw errorException;
                }
                TNamespace tNamespace = this.m_openSessionResp.getInitialNamespace();
                if (!tNamespace.isSetCatalogName()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INITIAL_NAMESPACE_CATALOG_NOT_SET.name());
                    throw errorException;
                }
                this.m_settings.m_catalog = tNamespace.getCatalogName();
                if (tNamespace.isSetSchemaName()) {
                    this.m_settings.m_Schema = tNamespace.getSchemaName();
                    bl2 = true;
                } else {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INITIAL_NAMESPACE_SCHEMA_NOT_SET.name());
                    CoreUtils.postWarning(errorException, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, errorException.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                }
            } else {
                this.m_settings.m_catalog = this.m_settings.m_platformCatalog;
            }
            if (!bl2 && !this.m_settings.m_Schema.equals("default")) {
                try {
                    this.runSetSchema(this.m_settings.m_Schema);
                }
                catch (ErrorException errorException) {
                    if (MetadataUtils.checkForCommunicationLinkFailure(errorException)) {
                        throw errorException;
                    }
                    CoreUtils.postWarning(errorException, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, errorException.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                    HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
                    this.m_settings.m_Schema = "default";
                }
            }
            this.dbmdInfo = new DatabaseMetadataInfo(this.m_settings.m_dbmsName, this.m_settings.m_strServerVersion);
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "OpenSession");
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = null != exception.getMessage() ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), exception.getMessage()) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR_NO_DETAIL.name());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected String getDbmsProdName() throws ErrorException, TException {
        TGetInfoReq tGetInfoReq = new TGetInfoReq();
        tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_NAME);
        tGetInfoReq.setInfoTypeIsSet(true);
        tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
        tGetInfoReq.setSessionHandleIsSet(true);
        TGetInfoResp tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
        String string = "GetInfo - Product Name";
        this.checkIfRespNull(tGetInfoResp, string);
        this.checkResponseStatus(tGetInfoResp.getStatus(), string);
        return tGetInfoResp.getInfoValue().getStringValue();
    }

    protected ArrayList<String> runCatalogFunction(String string, int n) throws ErrorException, Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            ArrayList<String> arrayList = new ArrayList<String>();
            HiveExecutionContext hiveExecutionContext = this.executeStatement(string, null);
            if (this.m_enableArrow) {
                this.getResultSetMetadataInternal(hiveExecutionContext);
            }
            RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            do {
                this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                if (!rowsetBuffer.m_bufferHasMoreRows) continue;
                int n2 = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getNumColumns();
                if (n2 <= n) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CATALOG_FUNCTION_COL_IDX_ERR.name(), new String[]{string, Integer.toString(n), Integer.toString(n2)});
                    throw errorException;
                }
                arrayList.addAll(((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(n));
            } while (hiveExecutionContext.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            Collections.sort(arrayList);
            return arrayList;
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "CatalogFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSetCatalog(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = "USE CATALOG " + string;
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string2, null);
        this.closeOperation(hiveExecutionContext);
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            this.m_settings.m_catalog = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSetSchema(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = "USE " + string;
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string2, null);
        this.closeOperation(hiveExecutionContext);
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            this.m_settings.m_Schema = string;
        }
    }

    protected void safeCloseOperation(TOperationHandle tOperationHandle) throws ErrorException {
        TStatus tStatus = null;
        try {
            if (null != tOperationHandle) {
                TCloseOperationReq tCloseOperationReq = new TCloseOperationReq();
                tCloseOperationReq.setOperationHandle(tOperationHandle);
                TCloseOperationResp tCloseOperationResp = this.m_client.CloseOperation(tCloseOperationReq);
                String string = "CloseOperation";
                this.checkIfRespNull(tCloseOperationResp, string);
                tStatus = tCloseOperationResp.getStatus();
                this.checkResponseStatus(tStatus, string);
            }
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "CloseOperation");
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            if (null != tStatus) {
                this.m_warningListener.postWarning(this.buildWarningFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tStatus));
            }
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
    }

    protected void safeCloseSession() throws ErrorException {
        try {
            TCloseSessionReq tCloseSessionReq = new TCloseSessionReq();
            tCloseSessionReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tCloseSessionReq.setSessionHandleIsSet(true);
            TCloseSessionResp tCloseSessionResp = this.m_client.CloseSession(tCloseSessionReq);
            String string = "CloseSession";
            this.checkIfRespNull(tCloseSessionResp, string);
            this.checkResponseStatus(tCloseSessionResp.getStatus(), string);
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "CloseSession");
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
    }

    protected ErrorException buildExceptionFromTStatus(TStatus tStatus, String string, String[] stringArray) {
        String string2 = null;
        if (tStatus.isSetSqlState()) {
            string2 = tStatus.getSqlState();
        }
        return this.buildExceptionFromTStatusSqlState(string2, string, stringArray);
    }

    protected ErrorException buildExceptionFromTStatusSqlState(String string, String string2, String[] stringArray) {
        ErrorException errorException = this.m_settings.m_useSqlStateFromServer != false && null != string && 5 == string.length() ? HiveJDBCCommonDriver.s_HiveMessages.createCustomException(string, string2, stringArray) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string2, stringArray);
        return errorException;
    }

    private Warning buildWarningFromTStatus(String string, TStatus tStatus) {
        if (null != tStatus.getInfoMessages() && tStatus.getInfoMessages().size() > 0) {
            String[] stringArray = new String[tStatus.getInfoMessages().size()];
            tStatus.getInfoMessages().toArray(stringArray);
            return new Warning(WarningCode.GENERAL_WARNING, 101, string, stringArray);
        }
        return new Warning(WarningCode.GENERAL_WARNING, 101, string, new String[]{tStatus.getErrorMessage(), Integer.toString(tStatus.getErrorCode())});
    }

    private void checkNumModifiedRows(TGetOperationStatusResp tGetOperationStatusResp, HiveExecutionContext hiveExecutionContext) throws TException, ErrorException {
        if (this.m_settings.m_supportsNumRowsModified && tGetOperationStatusResp.isSetNumModifiedRows()) {
            hiveExecutionContext.m_rowCount = tGetOperationStatusResp.getNumModifiedRows();
            return;
        }
        if (hiveExecutionContext.m_hasOpenOperation && hiveExecutionContext.m_isExecutionComplete && this.m_settings.m_supportsDMLResults && hiveExecutionContext.m_hasRowcountResult) {
            try {
                TCloseImpalaOperationReq tCloseImpalaOperationReq = new TCloseImpalaOperationReq(hiveExecutionContext.m_executeResponse.getOperationHandle());
                TCloseImpalaOperationResp tCloseImpalaOperationResp = this.m_client.CloseImpalaOperation(tCloseImpalaOperationReq);
                this.checkResponseStatus(tCloseImpalaOperationResp.getStatus(), "closeImpalaOperation");
                hiveExecutionContext.m_hasOpenOperation = false;
                if (tCloseImpalaOperationResp.isSetDml_result()) {
                    TDmlResult tDmlResult = tCloseImpalaOperationResp.getDml_result();
                    if (tDmlResult.isSetRows_modified()) {
                        long l = 0L;
                        for (Map.Entry<String, Long> entry : tDmlResult.getRows_modified().entrySet()) {
                            LogUtilities.logTrace("Partition name: " + entry.getKey() + ", Modify count: " + entry.getValue(), this.m_logger);
                            l += entry.getValue().longValue();
                        }
                        hiveExecutionContext.m_rowCount = l;
                    }
                    if (tDmlResult.isSetNum_row_errors() && 0L < tDmlResult.getNum_row_errors()) {
                        this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, "The server returned" + Long.toString(tDmlResult.getNum_row_errors()) + "row errors for the DML statement."));
                    }
                } else {
                    LogUtilities.logDebug("CloseImpalaOperation successful, but no DmlResult returned.", this.m_logger);
                }
            }
            catch (TException tException) {
                if (tException instanceof TApplicationException && tException.getMessage().contains("CloseImpalaOperation")) {
                    LogUtilities.logWarning("CloseImpalaOperation not supported, setting supportsDMLResults to false: " + tException.getLocalizedMessage(), this.m_logger);
                    this.m_settings.m_supportsDMLResults = false;
                }
                throw tException;
            }
        }
    }

    private TExecuteStatementReq createExecuteStatementReq() {
        TExecuteStatementReq tExecuteStatementReq = new TExecuteStatementReq();
        if (this.m_enableDirectResults) {
            LogUtilities.logDebug("DirectResults is enabled for execution", this.m_logger);
            TSparkGetDirectResults tSparkGetDirectResults = new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock);
            if (this.m_enableArrow) {
                tSparkGetDirectResults.setMaxBytes(this.m_settings.m_arrowMaxBytesPerFetch);
            }
            tExecuteStatementReq.setGetDirectResults(tSparkGetDirectResults);
        }
        if (this.m_enableArrow) {
            if (this.m_settings.m_downloadableResultSettings.m_isEnableQueryResultDownload) {
                tExecuteStatementReq.setCanDownloadResult(true);
                if (this.m_settings.m_downloadableResultSettings.m_maxBytesPerFile != DownloadableResultSettings.MAX_BYTES_PER_FILE_IS_NOT_SET) {
                    tExecuteStatementReq.setMaxBytesPerFile(this.m_settings.m_downloadableResultSettings.m_maxBytesPerFile);
                }
            }
            tExecuteStatementReq.setCanDecompressLZ4Result(this.m_settings.m_isEnableQueryResultLZ4Compression);
            tExecuteStatementReq.setCanReadArrowResult(true);
        }
        return tExecuteStatementReq;
    }

    private TOpenSessionReq createOpenSessionReq() {
        Cloneable cloneable;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TOpenSessionReq tOpenSessionReq = new TOpenSessionReq();
        tOpenSessionReq.setClient_protocol(DEFAULT_HIVE_CLI_SERVICE_PROTOCOL);
        if (this.m_settings.m_platformVersionUtils.supportsUnsetClientProtocol()) {
            LogUtilities.logDebug("Setting client protocol as unset to get highest supported version by the server", this.m_logger);
            tOpenSessionReq.setClient_protocolIsSet(false);
            if (this.m_settings.m_isPassMaxProtocolVerInOpenSessionReq) {
                tOpenSessionReq.setClient_protocol_i64(this.m_settings.m_platformVersionUtils.getHighestClientProtocol().getValue());
            }
        } else {
            tOpenSessionReq.setClient_protocolIsSet(true);
        }
        if (null != this.m_settings.m_delegationUID) {
            cloneable = new HashMap<String, String>();
            cloneable.put(this.m_settings.m_platformDelegationUIDPropertyKey, this.m_settings.m_delegationUID);
            tOpenSessionReq.setConfiguration((Map<String, String>)((Object)cloneable));
        }
        if (AuthMech.UIDPWD == this.m_settings.m_authMech && TransportMode.BINARY == this.m_settings.m_transportMode) {
            tOpenSessionReq.setUsername(this.m_settings.m_username);
            tOpenSessionReq.setPassword(this.m_settings.m_password);
        } else if (this.m_settings.m_platformVersionUtils.sendUidViaOpenSessionReq(this.m_settings.m_authMech) && null != this.m_settings.m_username) {
            tOpenSessionReq.setUsername(this.m_settings.m_username);
        }
        LogUtilities.logDebug("Setting GetInfos in the OpenSession request", this.m_logger);
        cloneable = new ArrayList();
        cloneable.add(0, TGetInfoType.CLI_DBMS_NAME);
        if (!this.m_settings.m_platformVersionUtils.isServerVersionSet(this.m_settings.m_serverVersion)) {
            cloneable.add(1, TGetInfoType.CLI_DBMS_VER);
        }
        tOpenSessionReq.setGetInfos((List<TGetInfoType>)((Object)cloneable));
        if (this.m_settings.m_thriftHTTPSettings.m_enableSessionTag) {
            this.m_settings.m_thriftHTTPSettings.setThriftSessionTag(this.m_logger);
        }
        String string = null;
        String string2 = null;
        if (this.m_settings.m_catalogSetByUser && null != this.m_settings.m_catalog) {
            string = this.m_settings.m_catalog;
        }
        if (null != this.m_settings.m_Schema) {
            string2 = this.m_settings.m_Schema;
        }
        if (null != string || null != string2) {
            TNamespace tNamespace = new TNamespace();
            if (null != string) {
                tNamespace.setCatalogName(string);
            }
            if (null != string2) {
                tNamespace.setSchemaName(string2);
            }
            tOpenSessionReq.setInitialNamespace(tNamespace);
        }
        if (!this.m_settings.m_applySSPWithQueries && null != this.m_settings.m_sspValues) {
            for (String string3 : this.m_settings.m_sspValues.keySet()) {
                tOpenSessionReq.putToConfiguration(string3, this.m_settings.m_sspValues.get(string3));
            }
        }
        tOpenSessionReq.putToConnectionProperties("UseNativeQuery", String.valueOf(this.m_settings.m_useNativeQueryVal));
        tOpenSessionReq.putToConnectionProperties("UseProxy", this.m_settings.m_proxySettings.m_useProxy ? "1" : "0");
        if (null != this.m_settings.m_databricksCatalogSSP) {
            tOpenSessionReq.putToConfiguration("databricks.catalog", this.m_settings.m_databricksCatalogSSP);
        }
        tOpenSessionReq.setCanUseMultipleCatalogs(this.m_settings.m_requestEnableMultiCatalog);
        return tOpenSessionReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HiveExecutionContext executeStatementInternal(String string, IExecutorUtility iExecutorUtility, boolean bl) throws ErrorException {
        boolean bl2 = false;
        try {
            Object object;
            Object object2;
            long l = 0L;
            boolean bl3 = this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion);
            HiveExecutionContext hiveExecutionContext = this.createExecutionContext();
            TExecuteStatementReq tExecuteStatementReq = this.createExecuteStatementReq();
            tExecuteStatementReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            if (string.startsWith(SET_CASE)) {
                object2 = "\n";
                object = "\r";
                String string2 = " ";
                boolean bl4 = this.m_settings.m_platformVersionUtils.supportsNewLineCharacter(this.m_settings.m_serverVersion);
                if (!bl4) {
                    string = string.replace((CharSequence)object2, string2).replace((CharSequence)object, string2);
                }
            }
            tExecuteStatementReq.setStatement(string);
            hiveExecutionContext.m_query = string;
            if (bl3) {
                tExecuteStatementReq.setRunAsyncIsSet(true);
                tExecuteStatementReq.setRunAsync(true);
            }
            object = this;
            synchronized (object) {
                if (null != iExecutorUtility && 0 != iExecutorUtility.getQueryTimeout()) {
                    l = iExecutorUtility.getQueryTimeout();
                    bl2 = true;
                    if (!bl3) {
                        this.setSocketTimeout(iExecutorUtility.getQueryTimeout());
                    } else {
                        this.setSocketTimeout(this.m_settings.m_timeout);
                    }
                } else {
                    this.setSocketTimeout(this.m_settings.m_timeout);
                }
                this.m_settings.m_thriftHTTPSettings.m_currentQuery = string;
                if (null != iExecutorUtility) {
                    hiveExecutionContext.setStatement(iExecutorUtility.getStatement());
                    if (hiveExecutionContext.isCanceled()) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
                    }
                }
                hiveExecutionContext.m_executeResponse = object2 = this.m_client.ExecuteStatement(tExecuteStatementReq);
            }
            if (hiveExecutionContext.m_executeResponse.isSetDirectResults()) {
                hiveExecutionContext.handleDirectResultsResp(this.m_logger, hiveExecutionContext.m_executeResponse.getDirectResults());
            }
            hiveExecutionContext.m_startTime = System.currentTimeMillis();
            hiveExecutionContext.m_timeoutVal = l;
            if (null != iExecutorUtility) {
                iExecutorUtility.setExeContext(hiveExecutionContext);
            }
            this.checkResponseStatus(((TExecuteStatementResp)object2).getStatus(), HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{Integer.toString(((TExecuteStatementResp)object2).getStatus().getErrorCode()), ((TExecuteStatementResp)object2).getStatus().toString(), string});
            if (iExecutorUtility instanceof HiveJDBCNativeQueryExecutor) {
                hiveExecutionContext.m_hasRowcountResult = ((HiveJDBCNativeQueryExecutor)iExecutorUtility).isRowCountQuery();
            }
            if (bl) {
                return hiveExecutionContext;
            }
            return this.pollForOperationCompletion(hiveExecutionContext);
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (TTransportException tTransportException) {
            if (null != tTransportException.getCause() && tTransportException.getCause() instanceof SocketTimeoutException) {
                if (bl2) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{string}, (Throwable)tTransportException, ExceptionType.TIME_OUT);
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STMT_EXEC_SOCKETTIMEOUT_ERR.name(), new String[]{string}, (Throwable)tTransportException);
                throw errorException;
            }
            throw this.handleTTransportException(tTransportException, "ExecuteStatment for query \"" + string + "\"");
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{exception.getMessage(), "HY000", string}, (Throwable)exception);
            throw errorException;
        }
    }

    private String fullColumnTypeNameBuilder(TTypeEntry tTypeEntry) {
        TTypeQualifiers tTypeQualifiers = tTypeEntry.getPrimitiveEntry().getTypeQualifiers();
        TTypeId tTypeId = tTypeEntry.getPrimitiveEntry().getType();
        if (this.m_settings.m_platformVersionUtils.supportsCharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("CHAR_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("characterMaximumLength").getI32Value();
            return "CHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsVarcharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("VARCHAR_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("characterMaximumLength").getI32Value();
            return "VARCHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsDecimalPrecisionAndScale(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("DECIMAL_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("precision").getI32Value();
            int n2 = tTypeQualifiers.getQualifiers().get("scale").getI32Value();
            return "DECIMAL(" + n + ", " + n2 + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            if (tTypeId.name().equalsIgnoreCase("ARRAY_TYPE")) {
                return "ARRAY";
            }
            if (tTypeId.name().equalsIgnoreCase("STRUCT_TYPE")) {
                return "STRUCT";
            }
            if (tTypeId.name().equalsIgnoreCase("MAP_TYPE")) {
                return "MAP";
            }
        }
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("UNION_TYPE")) {
            return "UNION";
        }
        return "null";
    }

    private void timeoutCheck(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        if (0L != hiveExecutionContext.m_timeoutVal && System.currentTimeMillis() - hiveExecutionContext.m_startTime >= hiveExecutionContext.m_timeoutVal) {
            hiveExecutionContext.m_isManualCanceled.set(true);
            this.cancelOperation(hiveExecutionContext);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{CoreUtils.redactQuery(hiveExecutionContext.m_query, this.m_settings)}, ExceptionType.TIME_OUT);
            throw errorException;
        }
    }

    private void regroupImpalaServerVersion() {
        String[] stringArray = this.m_settings.m_strServerVersion.split("-");
        if (stringArray.length > 1) {
            try {
                Integer.parseInt(stringArray[0].substring(0, 1));
                this.m_settings.m_strServerVersion = stringArray[0] + "-" + stringArray[1];
            }
            catch (NumberFormatException numberFormatException) {
                this.m_settings.m_strServerVersion = stringArray[1] + "-" + stringArray[0];
            }
        }
    }

    private ArrayList<String> getQualifiedTypeNames(String string, String string2) throws ErrorException {
        if (this.m_settings.m_enableIsQualifierTypeReturnedTesting) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TYPE_QUALIFIER_SIZE_ERROR.name(), "Qualified Type Names Error");
            throw errorException;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = string == null || string.equals("") ? this.getCurrentSchema() + "." : string + ".";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string3 + string2, null);
            RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            do {
                String string4;
                this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                int n = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getNumRowsInBuffer();
                List<String> list = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(1);
                for (int i = 0; i < n && null != (string4 = list.get(i)); ++i) {
                    arrayList.add(string4.toUpperCase().trim());
                }
            } while (hiveExecutionContext.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<String>();
        }
    }

    private ArrayList<HiveCommonColumnMetadata> getColumnsWithDescribeQuery(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<HiveCommonColumnMetadata> arrayList = new ArrayList<HiveCommonColumnMetadata>();
        try {
            if (string3.contains("\\")) {
                return new ArrayList<HiveCommonColumnMetadata>();
            }
            boolean bl = null != string2 && !string2.equals("");
            String string4 = "`" + (bl ? string2 : this.getCurrentSchema()) + "`.`" + string3 + "`";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string4, null);
            if (hiveExecutionContext == null) {
                return new ArrayList<HiveCommonColumnMetadata>();
            }
            if (this.m_enableArrow) {
                this.getResultSetMetadataInternal(hiveExecutionContext);
            }
            RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            block2: do {
                this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                List<String> list = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(0);
                List<String> list2 = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(1);
                List<String> list3 = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(2);
                for (int i = 0; i < list.size(); ++i) {
                    String string5 = list2.get(i);
                    if (null == string5 || 0 == string5.length()) {
                        rowsetBuffer.m_bufferHasMoreRows = false;
                        continue block2;
                    }
                    string5 = string5.toUpperCase();
                    short s = DataTypeUtilities.mapHiveTypeNameToSqltype(string5, 2, this.m_settings);
                    arrayList.add(DataTypeUtilities.createColumn(string, string2, string3, list.get(i), list3.get(i), s, string5, 2, Nullable.NULLABLE.getIntValue(), this.m_settings));
                }
            } while (hiveExecutionContext.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    private synchronized HeartBeatThread getHeartBeatThread() {
        if (null == this.m_heartBeatThread) {
            this.m_heartBeatThread = new HeartBeatThread(this, this.m_settings.m_heartBeatInterval, this.m_logger);
        }
        return this.m_heartBeatThread;
    }

    protected ErrorException handleTTransportException(TTransportException tTransportException, String string) {
        ErrorException errorException;
        if (null != this.m_heartBeatThread) {
            try {
                this.m_heartBeatThread.stop();
            }
            catch (ErrorException errorException2) {
                HiveJDBCExceptionUtils.logException(errorException2, this.m_logger);
            }
        }
        this.m_settings.m_isConnAlive = false;
        String string2 = "";
        if (this.m_settings.m_addApiCallToTTransportExceptionMessage && string != "") {
            string2 = null == tTransportException.getMessage() || !tTransportException.getMessage().endsWith(".") ? ". " + string : " " + string;
        }
        if (tTransportException instanceof TETokenExpirationException) {
            errorException = new ErrorException("08006", 105, CommonJDBCMessageKey.CONN_OAUTH_TOKEN_EXP.name(), new String[]{(null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown") + string2});
        } else {
            errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{(null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown") + string2});
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        }
        errorException.initCause(tTransportException);
        return errorException;
    }

    private void setLivySettings() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_settings.m_isSparkLivyServer = this.m_settings.m_dbmsName.contains(SPARK_LIVY_SERVER_NAME);
        if (this.m_settings.m_isSparkLivyServer) {
            if (!this.m_settings.m_serverVersionSetByUser) {
                try {
                    this.m_settings.m_strServerVersion = this.getServerVersionViaVersionQuery();
                    this.setSparkServerVersion();
                }
                catch (Exception exception) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_VIA_QUERY_ERROR.name(), new String[]{SPARK_LIVY_DEFAULT_SPARK_VERSION_STR, exception.getMessage()});
                    errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                    LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
                    this.m_settings.m_strServerVersion = SPARK_LIVY_DEFAULT_SPARK_VERSION_STR;
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                }
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.USER_SERVER_VERSION_DISABLE_VERSION_QUERY.name(), this.m_settings.m_strServerVersion);
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            }
        }
    }

    private void setMultiCatalogSettings() throws ErrorException {
        boolean bl;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl2 = bl = this.m_openSessionResp.isSetCanUseMultipleCatalogs() && this.m_openSessionResp.isCanUseMultipleCatalogs();
        if (!this.m_settings.m_requestEnableMultiCatalog && bl) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SERVER_IGNORE_DISABLE_MULTICATALOG.name());
            throw errorException;
        }
        this.m_settings.m_enableMultiCatalog = bl;
        if (this.m_settings.m_enableMultiCatalog) {
            this.m_settings.m_executeSetQueryOnSetCatalogCall = true;
            this.m_settings.m_acceptEmptyStringAsCatalog = true;
            this.m_settings.m_convertSyntheticCatalogToNullForCatalogFunc = true;
            this.m_settings.m_trackCatalogFromQueries = true;
            this.m_settings.m_convertSyntheticCatalogToCurrCatalogForQuery = true;
        }
    }

    private void setProtocolSpecificSettings() {
        boolean bl;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_enableDirectResults = this.m_settings.m_enableDirectResults && TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        this.m_settings.m_mapEmptyTableTypeToTable = TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V2.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        this.m_enableArrow = this.m_settings.m_enableArrow && TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        this.m_settings.m_isServerSupportsNamespace = TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V4.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        boolean bl2 = bl = TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        if (!bl && !this.m_settings.m_applySSPWithQueries) {
            if (!this.m_settings.m_bypassChecksForSSPWithQueries) {
                this.m_settings.m_applySSPWithQueries = true;
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DRIVER_ENABLE_SSP_WITH_QUERY_NO_CONF_OVERLAY.name(), "ApplySSPWithQueries");
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.BYPASS_CHECK_FOR_SSP_WITH_QUERY_NO_CONF_OVERLAY.name(), "ApplySSPWithQueries");
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            }
        }
    }

    private void setSparkServerVersion() throws ErrorException, Exception {
        Object object;
        boolean bl = false;
        String string = null;
        if (this.m_settings.m_dbmsName.contains(SPARK_SERVER_NAME) || this.m_settings.m_dbmsName.contains(SPARK_LIVY_SERVER_NAME)) {
            bl = true;
            string = this.m_settings.m_strServerVersion;
        } else if (this.m_settings.m_strServerVersion.contains("shark")) {
            bl = true;
            object = SHARK_HIVE_VERSION.matcher(this.m_settings.m_strServerVersion);
            if (((Matcher)object).find()) {
                string = ((Matcher)object).group(2);
            }
        } else if (!this.m_settings.m_dbmsName.contains(IMPALA_SERVER_NAME)) {
            object = this.runCatalogFunction(SET_DASH_V_QUERY_STRING, 0);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                if (!((ArrayList)object).get(i).matches(SHARK_REGEX)) continue;
                bl = true;
                string = HIVE_SPARK_VERSION_MAP.get(this.m_settings.m_strServerVersion.substring(0, 4));
            }
        }
        if (bl && SPARK_SERVER_NAME == this.m_settings.m_connDBType) {
            this.m_settings.m_strServerVersion = string;
            this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
        }
        if (bl && SPARK_SERVER_NAME != this.m_settings.m_connDBType || !bl && SPARK_SERVER_NAME == this.m_settings.m_connDBType) {
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Incorrect Server Type Connected To.");
            throw object;
        }
    }

    private String[] parseFilters(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) {
        return this.parseFilters(map, arrayList, false);
    }

    private String[] parseFilters(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, boolean bl) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String[] stringArray = new String[]{null, null, null, null, null};
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string5 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        if (bl && null != string) {
            string = MetadataUtils.EscapeWildCard(string, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string2) {
            string2 = MetadataUtils.EscapeWildCard(string2, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string3) {
            string3 = MetadataUtils.EscapeWildCard(string3, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string4) {
            string4 = MetadataUtils.EscapeWildCard(string4, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string5) {
            string5 = MetadataUtils.EscapeWildCard(string5, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != arrayList) {
            if (null == string && arrayList.size() > MetadataUtils.CATALOG_PATTERN_IDX) {
                string = arrayList.get(MetadataUtils.CATALOG_PATTERN_IDX);
            }
            if (null == string2 && arrayList.size() > MetadataUtils.SCHEMA_PATTERN_IDX) {
                string2 = arrayList.get(MetadataUtils.SCHEMA_PATTERN_IDX);
            }
            if (null == string3 && arrayList.size() > MetadataUtils.TABLE_PATTERN_IDX) {
                string3 = arrayList.get(MetadataUtils.TABLE_PATTERN_IDX);
            }
            if (null == string4 && arrayList.size() > MetadataUtils.COLUMN_PATTERN_IDX) {
                string4 = arrayList.get(MetadataUtils.COLUMN_PATTERN_IDX);
            }
            if (null == string5 && arrayList.size() > MetadataUtils.FUNCTION_PATTERN_IDX) {
                string5 = arrayList.get(MetadataUtils.FUNCTION_PATTERN_IDX);
            }
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
        stringArray[3] = string4;
        stringArray[4] = string5;
        return stringArray;
    }

    private boolean isNonCurrentCatalog(String string, String string2) {
        return string2 != null && !string2.isEmpty() && !string.equalsIgnoreCase(string2);
    }

    private boolean mismatchedCatalogOrTempCatalog(String string, String string2) {
        return !this.m_settings.m_globalTempCatalog.equalsIgnoreCase(string2) && (!this.m_settings.m_acceptEmptyStringAsCatalog || !string2.isEmpty()) && !string.equalsIgnoreCase(string2);
    }

    private boolean isNonPlatformCatalog(String string) {
        return string != null && !string.equalsIgnoreCase(this.m_settings.m_platformCatalog);
    }

    static {
        DEFAULT_HIVE_CLI_SERVICE_PROTOCOL = TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1;
        HIVE_SPARK_VERSION_MAP = new HashMap<String, String>();
        HIVE_SPARK_VERSION_MAP.put("0.11", "0.9");
        HIVE_SPARK_VERSION_MAP.put("0.12", "1.1");
    }
}

