/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.dataengine.utilities;

import com.cloudera.impala.dsi.utilities.CalendarSetter;
import java.sql.Time;
import java.util.Calendar;

public class TimeTz
extends Time {
    private static final long serialVersionUID = 617671935649092790L;
    private Calendar m_timezoneCal;

    public TimeTz(Time time, Calendar calendar) {
        super(time.getTime());
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    public TimeTz(long l, Calendar calendar) {
        super(l);
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof TimeTz) {
            TimeTz timeTz = (TimeTz)object;
            return this.m_timezoneCal.getTimeZone().getOffset(this.getTime()) == timeTz.getTimezoneCalendar().getTimeZone().getOffset(timeTz.getTime());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 7 * this.m_timezoneCal.getTimeZone().getOffset(this.getTime());
    }

    public synchronized Time getAdjustedTime() {
        return CalendarSetter.getTime(this, Calendar.getInstance(), this.m_timezoneCal);
    }

    public Calendar getTimezoneCalendar() {
        return this.m_timezoneCal;
    }

    @Override
    public String toString() {
        String string = super.toString();
        int n = (int)(this.getTime() % 1000L);
        String string2 = String.format("%03d", n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(".");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        TimeTz timeTz = (TimeTz)super.clone();
        if (this.m_timezoneCal != null) {
            timeTz.m_timezoneCal = (Calendar)this.m_timezoneCal.clone();
        }
        return timeTz;
    }
}

