/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.relation.join;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.impala.sqlengine.executor.etree.temptable.IRowBlock;
import com.cloudera.impala.sqlengine.executor.etree.temptable.TemporaryFile;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ColumnSliceArray;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ColumnSliceBuilder;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public class RelationalRowBlock
implements IRowBlock {
    private final ETRelationalExpr m_wrapped;
    private final TemporaryFile m_longDataStore;
    private final ColumnSliceArray m_row;
    private final int m_maxDataSize;
    private final int m_currentRow = 0;

    public RelationalRowBlock(ETRelationalExpr eTRelationalExpr, TemporaryFile temporaryFile, int n, boolean[] blArray) {
        this.m_wrapped = eTRelationalExpr;
        this.m_longDataStore = temporaryFile;
        this.m_maxDataSize = n;
        IColumn[] iColumnArray = new IColumn[this.m_wrapped.getColumnCount()];
        for (int i = 0; i < this.m_wrapped.getColumnCount(); ++i) {
            iColumnArray[i] = this.m_wrapped.getColumn(i);
        }
        this.m_row = ColumnSliceBuilder.buildColumnSliceArray(iColumnArray, blArray, 1, this.m_maxDataSize);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isNull(int n) {
        return this.m_row.get(n).isNull(0);
    }

    @Override
    public long getBigInt(int n) {
        return this.m_row.get(n).getBigInt(0);
    }

    @Override
    public BigDecimal getExactNumber(int n) {
        return this.m_row.get(n).getExactNum(0);
    }

    @Override
    public double getDouble(int n) {
        return this.m_row.get(n).getDouble(0);
    }

    @Override
    public TemporaryFile.FileMarker getFileMarker(int n) {
        return this.m_row.get(n).getFileMarker(0);
    }

    @Override
    public float getReal(int n) {
        return this.m_row.get(n).getReal(0);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.m_row.get(n).getBoolean(0);
    }

    @Override
    public String getString(int n) {
        return this.m_row.get(n).getString(0);
    }

    @Override
    public Date getDate(int n) {
        return this.m_row.get(n).getDate(0);
    }

    @Override
    public Time getTime(int n) {
        return this.m_row.get(n).getTime(0);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        return this.m_row.get(n).getTimestamp(0);
    }

    @Override
    public UUID getGuid(int n) {
        return this.m_row.get(n).getGuid(0);
    }

    @Override
    public int getInteger(int n) {
        return this.m_row.get(n).getInteger(0);
    }

    @Override
    public short getSmallInt(int n) {
        return this.m_row.get(n).getSmallInt(0);
    }

    @Override
    public byte getTinyInt(int n) {
        return this.m_row.get(n).getTinyInt(0);
    }

    @Override
    public byte[] getBytes(int n) {
        return this.m_row.get(n).getBytes(0);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_wrapped.getColumn(n);
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        boolean bl = this.m_wrapped.move();
        if (bl) {
            this.loadRow();
        }
        return bl;
    }

    @Override
    public void reset() throws ErrorException {
        this.m_wrapped.reset();
    }

    private byte[] getLongData(ISqlDataWrapper iSqlDataWrapper) {
        try {
            if (TypeUtilities.isCharacterType(iSqlDataWrapper.getType())) {
                return DataRetrievalUtil.stringToBytes(iSqlDataWrapper.getChar());
            }
            return iSqlDataWrapper.getBinary();
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }

    private void loadRow() throws ErrorException {
        block16: for (IColumnSlice iColumnSlice : this.m_row) {
            ETDataRequest eTDataRequest = new ETDataRequest(0L, this.m_maxDataSize, this.m_wrapped.getColumn(iColumnSlice.columnNumber()));
            if (IColumnSlice.ColumnSliceType.FILE_MARKER == iColumnSlice.getType()) {
                boolean bl;
                long l = 0L;
                do {
                    eTDataRequest.setOffset(l);
                    bl = this.m_wrapped.retrieveData(iColumnSlice.columnNumber(), eTDataRequest);
                    if (eTDataRequest.getData().isNull()) {
                        iColumnSlice.setNull(0);
                        break;
                    }
                    byte[] byArray = this.getLongData(eTDataRequest.getData());
                    l += (long)byArray.length;
                    this.m_longDataStore.append(byArray);
                } while (bl);
                if (!this.m_longDataStore.isAppending()) continue;
                iColumnSlice.setFileMarker(0, this.m_longDataStore.generateFileMarker());
                continue;
            }
            this.m_wrapped.retrieveData(iColumnSlice.columnNumber(), eTDataRequest);
            if (eTDataRequest.getData().isNull()) {
                iColumnSlice.setNull(0);
                continue;
            }
            switch (iColumnSlice.getType()) {
                case BIGINT: {
                    iColumnSlice.setBigInt(0, eTDataRequest.getData().getBigInt().longValue());
                    continue block16;
                }
                case BINARY: {
                    iColumnSlice.setBytes(0, eTDataRequest.getData().getBinary());
                    continue block16;
                }
                case BOOLEAN: {
                    iColumnSlice.setBoolean(0, eTDataRequest.getData().getBoolean());
                    continue block16;
                }
                case CHAR: {
                    iColumnSlice.setString(0, eTDataRequest.getData().getChar());
                    continue block16;
                }
                case DATE: {
                    iColumnSlice.setDate(0, eTDataRequest.getData().getDate());
                    continue block16;
                }
                case DOUBLE: {
                    iColumnSlice.setDouble(0, eTDataRequest.getData().getDouble());
                    continue block16;
                }
                case EXACT_NUM: {
                    iColumnSlice.setExactNum(0, eTDataRequest.getData().getExactNumber());
                    continue block16;
                }
                case GUID: {
                    iColumnSlice.setGuid(0, eTDataRequest.getData().getGuid());
                    continue block16;
                }
                case INTEGER: {
                    iColumnSlice.setInteger(0, (int)eTDataRequest.getData().getInteger());
                    continue block16;
                }
                case REAL: {
                    iColumnSlice.setReal(0, eTDataRequest.getData().getReal());
                    continue block16;
                }
                case SMALLINT: {
                    iColumnSlice.setSmallInt(0, (short)eTDataRequest.getData().getSmallInt());
                    continue block16;
                }
                case TIME: {
                    iColumnSlice.setTime(0, eTDataRequest.getData().getTime());
                    continue block16;
                }
                case TIMESTAMP: {
                    iColumnSlice.setTimestamp(0, eTDataRequest.getData().getTimestamp());
                    continue block16;
                }
                case TINYINT: {
                    iColumnSlice.setTinyInt(0, (byte)eTDataRequest.getData().getTinyInt());
                    continue block16;
                }
            }
            throw new IllegalStateException("Unknown ColumnSliceType.");
        }
    }
}

