/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aetree.statement;

import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAEUnaryNode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEProcedure;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEParameterContainer;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AETreeCopyUtil;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.StatementMetadataProcessor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class AEProcedureCall
implements IAEStatement,
IAEUnaryNode<AEProcedure> {
    private static final int NUM_CHILDREN = 1;
    private final AEProcedure m_procedure;
    private List<AEParameter> m_dynamicParams = null;

    public AEProcedureCall(AEProcedure aEProcedure) {
        assert (null != aEProcedure);
        this.m_procedure = aEProcedure;
        this.m_procedure.setParent(this);
    }

    private AEProcedureCall(AEProcedureCall aEProcedureCall) {
        this.m_procedure = aEProcedureCall.m_procedure.copy();
        this.m_procedure.setParent(this);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEProcedureCall copy() {
        AEProcedureCall aEProcedureCall = new AEProcedureCall(this);
        AETreeCopyUtil.updateColumns(aEProcedureCall);
        return aEProcedureCall;
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AEProcedureCall.this.getOperand();
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 1;
            }
        }.iterator();
    }

    @Override
    public String getLogString() {
        return "AEProcedureCall";
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public IAENode getParent() {
        return null;
    }

    @Override
    public void setParent(IAENode iAENode) {
        throw new UnsupportedOperationException(this.getLogString() + " node does not have a parent.");
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEProcedureCall)) {
            return false;
        }
        return this.m_procedure.isEquivalent(((AEProcedureCall)iAENode).m_procedure);
    }

    @Override
    public void reprocessMetadata() throws ErrorException {
        this.getOperand().acceptVisitor(StatementMetadataProcessor.getInstance());
    }

    @Override
    public void notifyDataNeeded() throws ErrorException {
        AEProcedure aEProcedure = this.getOperand();
        for (int i = 0; i < ((AERelationalExpr)aEProcedure).getColumnCount(); ++i) {
            ((AERelationalExpr)aEProcedure).setDataNeeded(aEProcedure, i);
        }
        this.getOperand().setDataNeededOnChild();
    }

    @Override
    public List<AEParameter> getDynamicParameters() {
        if (null == this.m_dynamicParams) {
            AEParameterContainer aEParameterContainer = new AEParameterContainer();
            aEParameterContainer.initialize(this);
            this.m_dynamicParams = aEParameterContainer.getParameters();
        }
        return this.m_dynamicParams;
    }

    @Override
    public AEProcedure getOperand() {
        return this.m_procedure;
    }
}

