/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aebuilder.relation;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.relation.AEQuerySpecBuilder;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEExcept;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.impala.sqlengine.parser.type.PTListType;
import com.cloudera.impala.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.impala.sqlengine.parser.type.PTPositionalType;
import com.cloudera.impala.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AERelationalExprBuilder
extends AEBuilderBase<AERelationalExpr> {
    private boolean m_isQueryCorrelated;
    private boolean m_startNewQS;

    public AERelationalExprBuilder(AEQueryScope aEQueryScope, boolean bl) {
        super(aEQueryScope);
        if (null == aEQueryScope) {
            throw new NullPointerException("Query scope cannot be null.");
        }
        this.m_isQueryCorrelated = false;
        this.m_startNewQS = bl;
    }

    public boolean isQueryCorrelated() {
        return this.m_isQueryCorrelated;
    }

    @Override
    public AERelationalExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case SELECT_STATEMENT: {
                return this.buildSelectStatement(pTNonterminalNode);
            }
            case SORTED_SELECT_STATEMENT: {
                return this.buildSortedSelectStatement(pTNonterminalNode);
            }
            case UNION: 
            case UNION_ALL: {
                return this.buildUnion(pTNonterminalNode);
            }
            case EXCEPT: 
            case EXCEPT_ALL: {
                return this.buildExcept(pTNonterminalNode);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    @Override
    public AERelationalExpr visit(PTListNode pTListNode) throws ErrorException {
        switch (pTListNode.getListType()) {
            case TABLE_VALUE_LIST: {
                return this.buildTableValueList(pTListNode, null);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    public AERelationalExpr buildTableValueList(PTListNode pTListNode, List<IColumn> list) throws ErrorException {
        assert (PTListType.TABLE_VALUE_LIST == pTListNode.getListType());
        if (pTListNode.numChildren() < 1) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        ArrayList<AEValueExprList> arrayList = new ArrayList<AEValueExprList>();
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
        Iterator<IPTNode> iterator = pTListNode.getChildItr();
        while (iterator.hasNext()) {
            PTListNode pTListNode2;
            IPTNode iPTNode = iterator.next();
            PTListNode pTListNode3 = pTListNode2 = iPTNode instanceof PTListNode ? (PTListNode)iPTNode : null;
            if (null == pTListNode2) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            AEValueExprList aEValueExprList = AERelationalExprBuilder.buildRowValueConstructor(pTListNode2, aEValueExprBuilder);
            if (null != list) {
                if (aEValueExprList.getNumChildren() != list.size()) {
                    throw new SQLEngineException(DiagState.DIAG_INSERT_VAL_LIST_COL_LIST_MISMATCH, SQLEngineMessageKey.INVALID_NUMBER_INSERT_VALUES.name(), new String[]{"" + aEValueExprList.getNumChildren(), "" + list.size()});
                }
                for (int i = 0; i < aEValueExprList.getNumChildren(); ++i) {
                    AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(i);
                    if (!(aEValueExpr instanceof AEDefault)) continue;
                    AEDefault aEDefault = (AEDefault)aEValueExpr;
                    aEDefault.setMetadata(list.get(i));
                }
            }
            arrayList.add(aEValueExprList);
        }
        return new AETableConstructor(arrayList, list, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
    }

    private AERelationalExpr buildSelectStatement(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEQueryScope aEQueryScope = this.m_startNewQS ? this.getQueryScope().createChildScope() : this.getQueryScope();
        AERelationalExpr aERelationalExpr = (AERelationalExpr)new AEQuerySpecBuilder(aEQueryScope).build(pTNonterminalNode);
        this.m_isQueryCorrelated = aEQueryScope.isQueryCorrelated();
        return aERelationalExpr;
    }

    private AERelationalExpr buildSortedSelectStatement(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        Object object = AEBuilderCheck.nonTerminal(PTNonterminalType.ORDER_BY).withExactChildren(PTPositionalType.SORT_SPEC_LIST, AEBuilderCheck.list(PTListType.SORT_SPECIFICATION_LIST));
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.SELECT, AEBuilderCheck.nonEmpty(), PTPositionalType.ORDER_BY, (AEBuilderCheck.ParseTreeMatcher)object));
        object = this.m_startNewQS ? this.getQueryScope().createChildScope() : this.getQueryScope();
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.SELECT);
        IPTNode iPTNode = pTNonterminalNode2.getChild(PTPositionalType.SELECT_LIMIT);
        if (null == iPTNode || iPTNode.isEmptyNode()) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ORDER_BY_IN_SUBQUERY_WITHOUT_TOP.name());
        }
        PTNonterminalNode pTNonterminalNode3 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.ORDER_BY);
        PTListNode pTListNode = (PTListNode)pTNonterminalNode3.getChild(PTPositionalType.SORT_SPEC_LIST);
        ((AEQueryScope)object).setPtSortSpecList(pTListNode);
        ((AEQueryScope)object).setHasOrderBy();
        AERelationalExpr aERelationalExpr = (AERelationalExpr)new AERelationalExprBuilder((AEQueryScope)object, false).build(pTNonterminalNode2);
        this.m_isQueryCorrelated = ((AEQueryScope)object).isQueryCorrelated();
        return aERelationalExpr;
    }

    private AEExcept buildExcept(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEQueryScope aEQueryScope;
        AEQueryScope aEQueryScope2;
        assert (pTNonterminalNode.numChildren() == 2);
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.BINARY_LEFT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.BINARY_RIGHT);
        PTNonterminalType pTNonterminalType = pTNonterminalNode.getNonterminalType();
        if (PTNonterminalType.EXCEPT_ALL != pTNonterminalType && PTNonterminalType.EXCEPT != pTNonterminalType || null == iPTNode || null == iPTNode2) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        if (this.m_startNewQS) {
            aEQueryScope2 = this.getQueryScope().createChildScope();
            aEQueryScope = this.getQueryScope().createChildScope();
        } else {
            aEQueryScope2 = this.getQueryScope();
            aEQueryScope = aEQueryScope2.isTopMost() ? new AEQueryScope(aEQueryScope2.getDataEngine()) : aEQueryScope2.getParentScope().createChildScope();
        }
        boolean bl = PTNonterminalType.EXCEPT_ALL == pTNonterminalType;
        AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(aEQueryScope2, false);
        AERelationalExprBuilder aERelationalExprBuilder2 = new AERelationalExprBuilder(aEQueryScope, false);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
        AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aERelationalExprBuilder2.build(iPTNode2);
        AERelationalExprBuilder.validateSetOperands(aERelationalExpr, aERelationalExpr2, bl ? "EXCEPT ALL" : "EXCEPT");
        this.m_isQueryCorrelated = aERelationalExprBuilder.isQueryCorrelated() || aERelationalExprBuilder2.isQueryCorrelated();
        return new AEExcept(aERelationalExpr, aERelationalExpr2, bl, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
    }

    private AEUnion buildUnion(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (2 == pTNonterminalNode.numChildren()) {
            boolean bl;
            switch (pTNonterminalNode.getNonterminalType()) {
                case UNION: {
                    bl = false;
                    break;
                }
                case UNION_ALL: {
                    bl = true;
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidParseTreeException();
                }
            }
            IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.BINARY_LEFT);
            IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.BINARY_RIGHT);
            if (null != iPTNode && null != iPTNode2) {
                AEQueryScope aEQueryScope;
                AEQueryScope aEQueryScope2;
                if (this.m_startNewQS) {
                    aEQueryScope2 = this.getQueryScope().createChildScope();
                    aEQueryScope = this.getQueryScope().createChildScope();
                } else {
                    aEQueryScope2 = this.getQueryScope();
                    aEQueryScope = aEQueryScope2.isTopMost() ? new AEQueryScope(aEQueryScope2.getDataEngine()) : aEQueryScope2.getParentScope().createChildScope();
                }
                AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(aEQueryScope2, false);
                AERelationalExprBuilder aERelationalExprBuilder2 = new AERelationalExprBuilder(aEQueryScope, false);
                AERelationalExpr aERelationalExpr = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
                AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aERelationalExprBuilder2.build(iPTNode2);
                boolean bl2 = aERelationalExprBuilder.isQueryCorrelated() || aERelationalExprBuilder2.isQueryCorrelated();
                AERelationalExprBuilder.validateSetOperands(aERelationalExpr, aERelationalExpr2, bl ? "UNION ALL" : "UNION");
                this.m_isQueryCorrelated = bl2;
                return new AEUnion(aERelationalExpr, aERelationalExpr2, bl, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private static AEValueExprList buildRowValueConstructor(PTListNode pTListNode, AEValueExprBuilder aEValueExprBuilder) throws ErrorException {
        if (PTListType.ROW_VALUE_LIST != pTListNode.getListType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEValueExprList aEValueExprList = new AEValueExprList();
        for (int i = 0; i < pTListNode.numChildren(); ++i) {
            aEValueExprList.addNode(aEValueExprBuilder.build(pTListNode.getChild(i)));
        }
        return aEValueExprList;
    }

    private static void validateSetOperands(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, String string) throws ErrorException {
        if (aERelationalExpr.getColumnCount() != aERelationalExpr2.getColumnCount()) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.SET_OP_INVALID_NUM_COLUMNS.name(), new String[]{string});
        }
    }
}

