/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.slf4j.impl;

import com.cloudera.impala.jdbc42.internal.slf4j.helpers.Util;
import java.lang.reflect.Method;

public class VersionUtil {
    static final int MINIMAL_VERSION = 5;

    public static int getJavaMajorVersion() {
        String javaVersionString = Util.safeGetSystemProperty("java.version");
        return VersionUtil.getJavaMajorVersion(javaVersionString);
    }

    static int getJavaMajorVersion(String versionString) {
        if (versionString == null) {
            return 5;
        }
        if (versionString.startsWith("1.")) {
            return versionString.charAt(2) - 48;
        }
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object versionObj = versionMethod.invoke(null, new Object[0]);
            Method majorMethod = versionObj.getClass().getMethod("major", new Class[0]);
            Integer resultInteger = (Integer)majorMethod.invoke(versionObj, new Object[0]);
            return resultInteger;
        }
        catch (Exception e) {
            return 5;
        }
    }
}

