/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.message.internal;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.inject.Singleton;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.internal.LocalizationMessages;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.message.internal.HttpDateFormat;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.message.internal.HttpHeaderReader;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.message.internal.Utils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Date;

@Singleton
public class DateProvider
implements HeaderDelegateProvider<Date> {
    @Override
    public boolean supports(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    @Override
    public String toString(Date header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        return HttpDateFormat.getPreferredDateFormat().format(header);
    }

    @Override
    public Date fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        try {
            return HttpHeaderReader.readDate(header);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

