/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.inject.Inject;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.inject.Named;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.client.ClientAsyncExecutor;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.client.internal.LocalizationMessages;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.internal.util.collection.LazyValue;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.internal.util.collection.Value;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.internal.util.collection.Values;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.spi.ThreadPoolExecutorProvider;
import java.util.logging.Logger;

@ClientAsyncExecutor
class DefaultClientAsyncExecutorProvider
extends ThreadPoolExecutorProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultClientAsyncExecutorProvider.class.getName());
    private final LazyValue<Integer> asyncThreadPoolSize;

    @Inject
    public DefaultClientAsyncExecutorProvider(final @Named(value="ClientAsyncThreadPoolSize") int poolSize) {
        super("jersey-client-async-executor");
        this.asyncThreadPoolSize = Values.lazy(new Value<Integer>(){

            @Override
            public Integer get() {
                if (poolSize <= 0) {
                    LOGGER.config(LocalizationMessages.IGNORED_ASYNC_THREADPOOL_SIZE(poolSize));
                    return Integer.MAX_VALUE;
                }
                LOGGER.config(LocalizationMessages.USING_FIXED_ASYNC_THREADPOOL(poolSize));
                return poolSize;
            }
        });
    }

    @Override
    protected int getMaximumPoolSize() {
        return (Integer)this.asyncThreadPoolSize.get();
    }

    @Override
    protected int getCorePoolSize() {
        Integer maximumPoolSize = this.getMaximumPoolSize();
        if (maximumPoolSize != Integer.MAX_VALUE) {
            return maximumPoolSize;
        }
        return 0;
    }
}

