/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.symmetric;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.cms.GCMParameters;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.util.Integers;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

class GcmSpecUtil {
    static final Class gcmSpecClass = ClassUtil.loadClass(GcmSpecUtil.class, "javax.crypto.spec.GCMParameterSpec");

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static boolean isGcmSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        return gcmSpecClass != null && gcmSpecClass.isInstance(algorithmParameterSpec);
    }

    static boolean isGcmSpec(Class clazz) {
        return gcmSpecClass == clazz;
    }

    static AlgorithmParameterSpec extractGcmSpec(ASN1Primitive aSN1Primitive) throws InvalidParameterSpecException {
        try {
            GCMParameters gCMParameters = GCMParameters.getInstance(aSN1Primitive);
            Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
            return (AlgorithmParameterSpec)constructor.newInstance(Integers.valueOf(gCMParameters.getIcvLen() * 8), gCMParameters.getNonce());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidParameterSpecException("No constructor found!");
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException("Construction failed: " + exception.getMessage());
        }
    }

    static GCMParameters extractGcmParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        try {
            Method method = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
            Method method2 = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
            return new GCMParameters((byte[])method2.invoke((Object)algorithmParameterSpec, new Object[0]), (Integer)method.invoke((Object)algorithmParameterSpec, new Object[0]) / 8);
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException("Cannot process GCMParameterSpec");
        }
    }
}

