/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import java.util.HashMap;
import java.util.Map;

public class RSA {
    private static final String PREFIX = "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.";
    private static final Map<String, String> generalRsaAttributes = new HashMap<String, String>();

    static {
        generalRsaAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.RSAPublicKey|javax.crypto.interfaces.RSAPrivateKey");
        generalRsaAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.OAEP", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi$OAEP");
            configurableProvider.addAlgorithm("AlgorithmParameters.PSS", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi$PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.RSAPSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.RSASSA-PSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA224withRSA/PSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA256withRSA/PSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA384withRSA/PSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA512withRSA/PSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA224WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA256WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA384WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA512WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA3-224WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA3-256WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA3-384WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA3-512WITHRSAANDMGF1", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.RAWRSAPSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.NONEWITHRSAPSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.NONEWITHRSASSA-PSS", "PSS");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.NONEWITHRSAANDMGF1", "PSS");
            configurableProvider.addAttributes("Cipher.RSA", generalRsaAttributes);
            configurableProvider.addAlgorithm("Cipher.RSA", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$NoPadding");
            configurableProvider.addAlgorithm("Cipher.RSA/RAW", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$NoPadding");
            configurableProvider.addAlgorithm("Cipher.RSA/PKCS1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding");
            configurableProvider.addAlgorithm("Cipher", PKCSObjectIdentifiers.rsaEncryption, "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding");
            configurableProvider.addAlgorithm("Cipher", X509ObjectIdentifiers.id_ea_rsa, "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding");
            configurableProvider.addAlgorithm("Cipher.RSA/1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding_PrivateOnly");
            configurableProvider.addAlgorithm("Cipher.RSA/2", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding_PublicOnly");
            configurableProvider.addAlgorithm("Cipher.RSA/OAEP", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$OAEPPadding");
            configurableProvider.addAlgorithm("Cipher", PKCSObjectIdentifiers.id_RSAES_OAEP, "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$OAEPPadding");
            configurableProvider.addAlgorithm("Cipher.RSA/ISO9796-1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$ISO9796d1Padding");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.RSA//RAW", "RSA");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.RSA//NOPADDING", "RSA");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.RSA//PKCS1PADDING", "RSA/PKCS1");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.RSA//OAEPPADDING", "RSA/OAEP");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.RSA//ISO9796-1PADDING", "RSA/ISO9796-1");
            configurableProvider.addAlgorithm("KeyFactory.RSA", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi");
            configurableProvider.addAlgorithm("KeyPairGenerator.RSA", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi");
            KeyFactorySpi keyFactorySpi = new KeyFactorySpi();
            this.registerOid(configurableProvider, PKCSObjectIdentifiers.rsaEncryption, "RSA", keyFactorySpi);
            this.registerOid(configurableProvider, X509ObjectIdentifiers.id_ea_rsa, "RSA", keyFactorySpi);
            this.registerOid(configurableProvider, PKCSObjectIdentifiers.id_RSAES_OAEP, "RSA", keyFactorySpi);
            this.registerOid(configurableProvider, PKCSObjectIdentifiers.id_RSASSA_PSS, "RSA", keyFactorySpi);
            this.registerOidAlgorithmParameters(configurableProvider, PKCSObjectIdentifiers.rsaEncryption, "RSA");
            this.registerOidAlgorithmParameters(configurableProvider, X509ObjectIdentifiers.id_ea_rsa, "RSA");
            this.registerOidAlgorithmParameters(configurableProvider, PKCSObjectIdentifiers.id_RSAES_OAEP, "OAEP");
            this.registerOidAlgorithmParameters(configurableProvider, PKCSObjectIdentifiers.id_RSASSA_PSS, "PSS");
            configurableProvider.addAlgorithm("Signature.RSASSA-PSS", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$PSSwithRSA");
            configurableProvider.addAlgorithm("Signature." + PKCSObjectIdentifiers.id_RSASSA_PSS, "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$PSSwithRSA");
            configurableProvider.addAlgorithm("Signature.OID." + PKCSObjectIdentifiers.id_RSASSA_PSS, "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$PSSwithRSA");
            configurableProvider.addAlgorithm("Signature.RSA", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$noneRSA");
            configurableProvider.addAlgorithm("Signature.RAWRSASSA-PSS", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$nonePSS");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.RAWRSA", "RSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.NONEWITHRSA", "RSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.RAWRSAPSS", "RAWRSASSA-PSS");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.NONEWITHRSAPSS", "RAWRSASSA-PSS");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.NONEWITHRSASSA-PSS", "RAWRSASSA-PSS");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.NONEWITHRSAANDMGF1", "RAWRSASSA-PSS");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.RSAPSS", "RSASSA-PSS");
            this.addPSSSignature(configurableProvider, "SHA224", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA224withRSA");
            this.addPSSSignature(configurableProvider, "SHA256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA256withRSA");
            this.addPSSSignature(configurableProvider, "SHA384", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA384withRSA");
            this.addPSSSignature(configurableProvider, "SHA512", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA512withRSA");
            this.addPSSSignature(configurableProvider, "SHA512(224)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA512_224withRSA");
            this.addPSSSignature(configurableProvider, "SHA512(256)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA512_256withRSA");
            this.addPSSSignature(configurableProvider, "SHA3-224", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA3_224withRSA");
            this.addPSSSignature(configurableProvider, "SHA3-256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA3_256withRSA");
            this.addPSSSignature(configurableProvider, "SHA3-384", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA3_384withRSA");
            this.addPSSSignature(configurableProvider, "SHA3-512", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA3_512withRSA");
            if (configurableProvider.hasAlgorithm("MessageDigest", "MD2")) {
                this.addDigestSignature(configurableProvider, "MD2", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$MD2", PKCSObjectIdentifiers.md2WithRSAEncryption);
            }
            if (configurableProvider.hasAlgorithm("MessageDigest", "MD4")) {
                this.addDigestSignature(configurableProvider, "MD4", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$MD4", PKCSObjectIdentifiers.md4WithRSAEncryption);
            }
            if (configurableProvider.hasAlgorithm("MessageDigest", "MD5")) {
                this.addDigestSignature(configurableProvider, "MD5", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$MD5", PKCSObjectIdentifiers.md5WithRSAEncryption);
                this.addISO9796Signature(configurableProvider, "MD5", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$MD5WithRSAEncryption");
            }
            if (configurableProvider.hasAlgorithm("MessageDigest", "SHA1")) {
                configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA1withRSA/PSS", "PSS");
                configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.SHA1WITHRSAANDMGF1", "PSS");
                this.addPSSSignature(configurableProvider, "SHA1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA1withRSA");
                this.addDigestSignature(configurableProvider, "SHA1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA1", PKCSObjectIdentifiers.sha1WithRSAEncryption);
                this.addISO9796Signature(configurableProvider, "SHA1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA1WithRSAEncryption");
                configurableProvider.addAlgorithm("Alg.Alias.Signature." + OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
                configurableProvider.addAlgorithm("Alg.Alias.Signature.OID." + OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
                this.addX931Signature(configurableProvider, "SHA1", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA1WithRSAEncryption");
            }
            this.addDigestSignature(configurableProvider, "SHA224", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA224", PKCSObjectIdentifiers.sha224WithRSAEncryption);
            this.addDigestSignature(configurableProvider, "SHA256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA256", PKCSObjectIdentifiers.sha256WithRSAEncryption);
            this.addDigestSignature(configurableProvider, "SHA384", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA384", PKCSObjectIdentifiers.sha384WithRSAEncryption);
            this.addDigestSignature(configurableProvider, "SHA512", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512", PKCSObjectIdentifiers.sha512WithRSAEncryption);
            this.addDigestSignature(configurableProvider, "SHA512(224)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512_224", PKCSObjectIdentifiers.sha512_224WithRSAEncryption);
            this.addDigestSignature(configurableProvider, "SHA512(256)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512_256", PKCSObjectIdentifiers.sha512_256WithRSAEncryption);
            this.addDigestSignature(configurableProvider, "SHA3-224", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_224", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
            this.addDigestSignature(configurableProvider, "SHA3-256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_256", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
            this.addDigestSignature(configurableProvider, "SHA3-384", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_384", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
            this.addDigestSignature(configurableProvider, "SHA3-512", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_512", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
            this.addISO9796Signature(configurableProvider, "SHA224", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA224WithRSAEncryption");
            this.addISO9796Signature(configurableProvider, "SHA256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA256WithRSAEncryption");
            this.addISO9796Signature(configurableProvider, "SHA384", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA384WithRSAEncryption");
            this.addISO9796Signature(configurableProvider, "SHA512", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA512WithRSAEncryption");
            this.addISO9796Signature(configurableProvider, "SHA512(224)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA512_224WithRSAEncryption");
            this.addISO9796Signature(configurableProvider, "SHA512(256)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$SHA512_256WithRSAEncryption");
            this.addX931Signature(configurableProvider, "SHA224", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA224WithRSAEncryption");
            this.addX931Signature(configurableProvider, "SHA256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA256WithRSAEncryption");
            this.addX931Signature(configurableProvider, "SHA384", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA384WithRSAEncryption");
            this.addX931Signature(configurableProvider, "SHA512", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA512WithRSAEncryption");
            this.addX931Signature(configurableProvider, "SHA512(224)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA512_224WithRSAEncryption");
            this.addX931Signature(configurableProvider, "SHA512(256)", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$SHA512_256WithRSAEncryption");
            if (configurableProvider.hasAlgorithm("MessageDigest", "RIPEMD128")) {
                this.addDigestSignature(configurableProvider, "RIPEMD128", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD128", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
                this.addDigestSignature(configurableProvider, "RMD128", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD128", null);
                this.addX931Signature(configurableProvider, "RMD128", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$RIPEMD128WithRSAEncryption");
                this.addX931Signature(configurableProvider, "RIPEMD128", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$RIPEMD128WithRSAEncryption");
            }
            if (configurableProvider.hasAlgorithm("MessageDigest", "RIPEMD160")) {
                this.addDigestSignature(configurableProvider, "RIPEMD160", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD160", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
                this.addDigestSignature(configurableProvider, "RMD160", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD160", null);
                configurableProvider.addAlgorithm("Alg.Alias.Signature.RIPEMD160WithRSA/ISO9796-2", "RIPEMD160withRSA/ISO9796-2");
                configurableProvider.addAlgorithm("Signature.RIPEMD160withRSA/ISO9796-2", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$RIPEMD160WithRSAEncryption");
                this.addX931Signature(configurableProvider, "RMD160", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$RIPEMD160WithRSAEncryption");
                this.addX931Signature(configurableProvider, "RIPEMD160", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$RIPEMD160WithRSAEncryption");
            }
            if (configurableProvider.hasAlgorithm("MessageDigest", "RIPEMD256")) {
                this.addDigestSignature(configurableProvider, "RIPEMD256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD256", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
                this.addDigestSignature(configurableProvider, "RMD256", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD256", null);
            }
            if (configurableProvider.hasAlgorithm("MessageDigest", "WHIRLPOOL")) {
                this.addISO9796Signature(configurableProvider, "Whirlpool", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$WhirlpoolWithRSAEncryption");
                this.addISO9796Signature(configurableProvider, "WHIRLPOOL", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.ISOSignatureSpi$WhirlpoolWithRSAEncryption");
                this.addX931Signature(configurableProvider, "Whirlpool", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$WhirlpoolWithRSAEncryption");
                this.addX931Signature(configurableProvider, "WHIRLPOOL", "com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$WhirlpoolWithRSAEncryption");
            }
        }

        private void addDigestSignature(ConfigurableProvider configurableProvider, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
            String string3 = string + "WITHRSA";
            String string4 = string + "withRSA";
            String string5 = string + "WithRSA";
            String string6 = string + "/RSA";
            String string7 = string + "WITHRSAENCRYPTION";
            String string8 = string + "withRSAEncryption";
            String string9 = string + "WithRSAEncryption";
            configurableProvider.addAlgorithm("Signature." + string3, string2);
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string4, string3);
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string5, string3);
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string7, string3);
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string8, string3);
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string9, string3);
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string6, string3);
            if (aSN1ObjectIdentifier != null) {
                configurableProvider.addAlgorithm("Alg.Alias.Signature." + aSN1ObjectIdentifier, string3);
                configurableProvider.addAlgorithm("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier, string3);
            }
        }

        private void addISO9796Signature(ConfigurableProvider configurableProvider, String string, String string2) {
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "withRSA/ISO9796-2", string + "WITHRSA/ISO9796-2");
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "WithRSA/ISO9796-2", string + "WITHRSA/ISO9796-2");
            configurableProvider.addAlgorithm("Signature." + string + "WITHRSA/ISO9796-2", string2);
        }

        private void addPSSSignature(ConfigurableProvider configurableProvider, String string, String string2) {
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "withRSA/PSS", string + "WITHRSAANDMGF1");
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "WithRSA/PSS", string + "WITHRSAANDMGF1");
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "withRSAandMGF1", string + "WITHRSAANDMGF1");
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "WithRSAAndMGF1", string + "WITHRSAANDMGF1");
            configurableProvider.addAlgorithm("Signature." + string + "WITHRSAANDMGF1", string2);
        }

        private void addX931Signature(ConfigurableProvider configurableProvider, String string, String string2) {
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "withRSA/X9.31", string + "WITHRSA/X9.31");
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + string + "WithRSA/X9.31", string + "WITHRSA/X9.31");
            configurableProvider.addAlgorithm("Signature." + string + "WITHRSA/X9.31", string2);
        }
    }
}

