/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.DelayPolicy;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.RetryChecker;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.RetryHandler;
import java.time.Duration;

public class SimpleRetryHandler
implements RetryHandler {
    private final RetryChecker retryChecker;
    private final DelayPolicy delayPolicy;
    private final int maxAttempts;

    public SimpleRetryHandler(RetryChecker retryChecker, DelayPolicy delayPolicy, int maxAttempts) {
        this.retryChecker = ValidationUtils.checkNotNullAndThrow(retryChecker);
        this.delayPolicy = ValidationUtils.checkNotNullAndThrow(delayPolicy);
        ValidationUtils.checkArgumentAndThrow(maxAttempts > 0);
        this.maxAttempts = maxAttempts;
    }

    @Override
    public Duration shouldRetry(int attempts, AltusClientException exception) {
        ValidationUtils.checkNotNullAndThrow(exception);
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        if (attempts < this.maxAttempts && this.retryChecker.shouldRetry(attempts, exception)) {
            return this.getDelay(attempts);
        }
        return DO_NOT_RETRY;
    }

    private Duration getDelay(int attempts) {
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        return this.delayPolicy.delay(attempts);
    }
}

