/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public abstract class AltusResponse {
    public static final String ALTUS_HEADER_REQUESTID = "x-altus-request-id";
    private Integer httpCode = null;
    private Map<String, List<String>> responseHeaders = null;

    public int getHttpCode() {
        ValidationUtils.checkNotNullAndThrow(this.httpCode);
        return this.httpCode;
    }

    void setHttpCode(int httpCode) {
        ValidationUtils.checkStateAndThrow(this.httpCode == null);
        this.httpCode = httpCode;
    }

    @Deprecated
    public Map<String, List<String>> getResponseHeaaders() {
        return this.getResponseHeaders();
    }

    public Map<String, List<String>> getResponseHeaders() {
        ValidationUtils.checkNotNullAndThrow(this.responseHeaders);
        return this.responseHeaders;
    }

    void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        ValidationUtils.checkStateAndThrow(this.responseHeaders == null);
        this.responseHeaders = responseHeaders;
    }

    public String getRequestId() {
        ValidationUtils.checkNotNullAndThrow(this.responseHeaders);
        List<String> values = this.responseHeaders.get(ALTUS_HEADER_REQUESTID);
        if (values == null) {
            return "unknown";
        }
        return Iterables.getOnlyElement(values);
    }
}

