/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfiguration;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.ExponentialBackoffDelayPolicy;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.HttpCodesRetryChecker;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.RetryHandler;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.SimpleRetryHandler;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.base.MoreObjects;
import java.time.Duration;

public class AltusClientConfigurationBuilder {
    private String clientApplicationName = null;
    private Duration readTimeout = Duration.ofMinutes(1L);
    private Duration connectionTimeout = Duration.ofMinutes(1L);
    private RetryHandler retryHandler = new SimpleRetryHandler(new HttpCodesRetryChecker(HttpCodesRetryChecker.DEFAULT_RETRY_CODES), new ExponentialBackoffDelayPolicy(2, Duration.ofMillis(10L)), 13);

    private AltusClientConfigurationBuilder() {
    }

    public AltusClientConfigurationBuilder withClientApplicationName(String clientApplicationName) {
        ValidationUtils.checkNotNullAndThrow(clientApplicationName);
        this.clientApplicationName = clientApplicationName;
        return this;
    }

    public String getClientApplicationName() {
        return this.clientApplicationName;
    }

    public AltusClientConfigurationBuilder withConnectionTimeout(Duration connectionTimeout) {
        ValidationUtils.checkArgumentAndThrow(connectionTimeout.toMillis() > 0L);
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public AltusClientConfigurationBuilder withReadTimeout(Duration readTimeout) {
        ValidationUtils.checkArgumentAndThrow(readTimeout.toMillis() > 0L);
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public AltusClientConfigurationBuilder withRetryHandler(RetryHandler retryHandler) {
        ValidationUtils.checkNotNullAndThrow(retryHandler);
        this.retryHandler = retryHandler;
        return this;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public static AltusClientConfigurationBuilder defaultBuilder() {
        return new AltusClientConfigurationBuilder();
    }

    public AltusClientConfiguration build() {
        return new AltusClientConfiguration(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("readTimeout", this.getReadTimeout()).add("connectionTimeout", this.getConnectionTimeout()).add("clientApplicationName", this.getClientApplicationName()).toString();
    }
}

