/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentialsProvider;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.DefaultAltusCredentialProviderChain;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfiguration;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfigurationBuilder;

@SdkInternalApi
public abstract class AltusClientBuilder<T extends AltusClientBuilder<T>> {
    private static final String ENDPOINT_FORMAT_STRING = "https://%sapi.us-west-1.altus.cloudera.com:443";
    private AltusCredentialsProvider altusCredentialsProvider;
    private AltusClientConfiguration altusClientConfiguration;
    private String altusEndPoint;

    protected AltusClientBuilder(String serviceName) {
        ValidationUtils.checkNotNullAndThrow(serviceName);
        this.altusEndPoint = String.format(ENDPOINT_FORMAT_STRING, serviceName);
        this.altusCredentialsProvider = DefaultAltusCredentialProviderChain.getInstance();
        this.altusClientConfiguration = AltusClientConfigurationBuilder.defaultBuilder().build();
    }

    public AltusCredentialsProvider getAltusCredentials() {
        return this.altusCredentialsProvider;
    }

    public T withCredentials(AltusCredentialsProvider altusCredentialsProvider) {
        ValidationUtils.checkNotNullAndThrow(altusCredentialsProvider);
        this.altusCredentialsProvider = altusCredentialsProvider;
        return this.self();
    }

    public T withEndPoint(String altusEndPoint) {
        ValidationUtils.checkNotNullAndThrow(altusEndPoint);
        this.altusEndPoint = altusEndPoint;
        return this.self();
    }

    public String getAltusEndPoint() {
        return this.altusEndPoint;
    }

    public T withClientConfiguration(AltusClientConfiguration altusClientConfiguration) {
        ValidationUtils.checkNotNullAndThrow(altusClientConfiguration);
        this.altusClientConfiguration = altusClientConfiguration;
        return this.self();
    }

    public final AltusClientConfiguration getAltusClientConfiguration() {
        return this.altusClientConfiguration;
    }

    protected abstract T self();
}

