/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusHTTPException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusServiceException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.Signer;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfiguration;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusResponse;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.ClientConnectionWrapper;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.RetryHandler;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.annotations.VisibleForTesting;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.base.Preconditions;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.ImmutableList;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.ImmutableMap;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.Iterables;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.ProcessingException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.core.GenericType;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.core.Response;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public abstract class AltusClient {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final AltusCredentials credentials;
    private final String endPoint;
    private final RetryHandler retryHandler;
    private final ClientConnectionWrapper clientConnectionWrapper;

    protected AltusClient(AltusCredentials credentials, String endpoint, AltusClientConfiguration clientConfiguration) {
        ValidationUtils.checkNotNullAndThrow(clientConfiguration);
        ValidationUtils.checkNotNullAndThrow(clientConfiguration.getRetryHandler());
        this.credentials = ValidationUtils.checkNotNullAndThrow(credentials);
        this.endPoint = ValidationUtils.checkNotNullAndThrow(endpoint);
        this.retryHandler = clientConfiguration.getRetryHandler();
        this.clientConnectionWrapper = new ClientConnectionWrapper(clientConfiguration);
    }

    /*
     * Exception decompiling
     */
    protected <T extends AltusResponse> T invokeAPI(String path, Object body, GenericType<T> returnType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    protected Response getAPIResponse(String path, Object requestBody) throws AltusServiceException {
        String date = ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
        String auth = new Signer().computeAuthHeader("POST", "application/json", date, path, this.credentials.getAccessKeyId(), this.credentials.getPrivateKey());
        return this.clientConnectionWrapper.doPost(this.endPoint, path, auth, date, requestBody);
    }

    private <T extends AltusResponse> T parse(Response response, GenericType<T> returnType) {
        String requestId;
        String message;
        String code;
        String body;
        Preconditions.checkNotNull(response);
        Preconditions.checkNotNull(returnType);
        int httpCode = response.getStatusInfo().getStatusCode();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            for (Object o : (List)entry.getValue()) {
                listBuilder.add(String.valueOf(o));
            }
            mapBuilder.put(entry.getKey(), listBuilder.build());
        }
        ImmutableMap<String, List<String>> responseHeaders = mapBuilder.build();
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            AltusResponse altusResponse = (AltusResponse)response.readEntity(returnType);
            if (altusResponse == null) {
                throw new AltusHTTPException(httpCode, "Invalid response from server");
            }
            altusResponse.setHttpCode(httpCode);
            altusResponse.setResponseHeaders(responseHeaders);
            return (T)altusResponse;
        }
        try {
            body = response.readEntity(String.class);
        }
        catch (ProcessingException | NullPointerException e) {
            throw new AltusHTTPException(httpCode, "Error reading message from server", e);
        }
        try {
            Map map = (Map)MAPPER.readValue(body, (TypeReference)new MapReference());
            code = (String)map.get("code");
            Preconditions.checkNotNull(code);
            message = (String)map.get("message");
            Preconditions.checkNotNull(message);
            List values = (List)responseHeaders.get("x-altus-request-id");
            Preconditions.checkNotNull(values);
            requestId = (String)Iterables.getOnlyElement(values);
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            throw new AltusHTTPException(httpCode, body, e);
        }
        throw new AltusServiceException(requestId, httpCode, responseHeaders, code, message);
    }

    public void shutdown() {
        if (this.clientConnectionWrapper != null) {
            try {
                this.clientConnectionWrapper.close();
            }
            catch (Exception e) {
                throw new AltusClientException("Error closing client", e);
            }
        }
    }

    private static class MapReference
    extends TypeReference<Map<String, String>> {
        private MapReference() {
        }
    }
}

