/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile.AllAltusProfiles;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile.AltusProfile;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.ImmutableMap;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.io.Closeables;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.ini4j.Ini;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.ini4j.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@SdkInternalApi
class AltusProfileFileLoader {
    AltusProfileFileLoader() {
    }

    AllAltusProfiles loadProfiles(File file) {
        ValidationUtils.checkNotNullAndThrow(file);
        if (!file.exists()) {
            throw new AltusClientException("Error loading Altus profile. Altus profile file not found at: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new AltusClientException("Error loading Altus profile. File is a directory " + file.getAbsolutePath());
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Ini ini = new Ini(is);
            AllAltusProfiles allAltusProfiles = this.loadProfiles(ini);
            return allAltusProfiles;
        }
        catch (IOException ioe) {
            throw new AltusClientException("Unable to load Altus profile specified at " + file.getAbsolutePath(), ioe);
        }
        finally {
            if (is != null) {
                Closeables.closeQuietly(is);
            }
        }
    }

    private AllAltusProfiles loadProfiles(Ini ini) throws IOException {
        ImmutableMap.Builder<String, AltusProfile> profilesByName = ImmutableMap.builder();
        for (String sectionName : ini.keySet()) {
            Profile.Section section = (Profile.Section)ini.get(sectionName);
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (String optionKey : section.keySet()) {
                mapBuilder.put(optionKey, section.get(optionKey));
            }
            profilesByName.put(sectionName, new AltusProfile(mapBuilder.build()));
        }
        return new AllAltusProfiles(profilesByName.build());
    }
}

