/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.BasicAltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile.AllAltusProfiles;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile.AltusProfile;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile.AltusProfileFileLoader;
import java.io.File;

@SdkInternalApi
public class AltusProfileConfigFile {
    private AllAltusProfiles allProfiles;

    public AltusProfileConfigFile() {
        this(AltusProfileConfigFile.getAltusCredentialsLocation());
    }

    public AltusProfileConfigFile(String filePath) {
        this(new File(ValidationUtils.checkNotNullAndThrow(filePath)));
    }

    public AltusProfileConfigFile(File file) {
        this.allProfiles = this.loadProfiles(ValidationUtils.checkNotNullAndThrow(file));
    }

    public AltusCredentials getCredentials(String profileName) {
        ValidationUtils.checkNotNullAndThrow(profileName);
        AltusProfile profile = this.allProfiles.getProfile(profileName);
        if (profile == null) {
            throw new AltusClientException("Unable to find profile named " + profileName);
        }
        return new BasicAltusCredentials(profile.getAltusAccessKeyId(), profile.getAltusPrivateKey());
    }

    private static File getAltusCredentialsLocation() {
        File credProfiles = new File(AltusProfileConfigFile.getAltusDirectory(), "credentials");
        if (credProfiles.exists() && credProfiles.isFile()) {
            return credProfiles;
        }
        return null;
    }

    private static File getAltusDirectory() {
        return new File(AltusProfileConfigFile.getHomeDirectory(), ".altus");
    }

    private static String getHomeDirectory() {
        String userHomeDir = System.getProperty("user.home");
        if (userHomeDir == null) {
            throw new AltusClientException("Unable to load Altus profiles since user.home system property is not set");
        }
        return userHomeDir;
    }

    private AllAltusProfiles loadProfiles(File file) {
        return new AltusProfileFileLoader().loadProfiles(file);
    }
}

